package dev.kikugie.techutils.mixin.containerscan;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DestFactor;
import com.mojang.blaze3d.textures.GpuTextureView;
import dev.kikugie.techutils.feature.containerscan.verifier.InventoryOverlay;
import net.minecraft.class_11231;
import net.minecraft.class_11245;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5481;
import net.minecraft.class_9848;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;

/**
 * Partially taken from <a href="https://modrinth.com/mod/autohud">Auto HUD</a> by Crendgrim.
 *
 * @see <a href="https://github.com/Crendgrim/AutoHUD/blob/fd7cecaad0094b52314e458ec7ad45f6bd3ac733/src/main/java/mod/crend/autohud/mixin/DrawContextMixin.java">DrawContextMixin.java</a>
 */
@Mixin(class_332.class)
public class DrawContextMixin {
	@ModifyArg(
		method = "drawItem(Lnet/minecraft/entity/LivingEntity;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;III)V",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/client/gui/render/state/GuiRenderState;addItem(Lnet/minecraft/client/gui/render/state/ItemGuiElementRenderState;)V"
		),
		index = 0
	)
	private class_11245 saveItemGuiState(class_11245 original) {
		if (InventoryOverlay.isRenderingTransparentItem) {
			InventoryOverlay.transparentItemStates.add(original);
		}
		return original;
	}

	@WrapMethod(method = "fill(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/client/texture/TextureSetup;IIIIILjava/lang/Integer;)V")
	private void fillWithTransparency(
		RenderPipeline pipeline, class_11231 textureSetup, int x1, int y1, int x2, int y2, int color, Integer color2, Operation<Void> original
	) {
		if (InventoryOverlay.isRenderingTransparentItem) {
			color = class_9848.method_61330(Math.round(class_9848.method_61320(color) * InventoryOverlay.MISSING_ITEM_ALPHA), color);
			if (color2 != null) {
				color2 = class_9848.method_61330(Math.round(class_9848.method_61320(color2) * InventoryOverlay.MISSING_ITEM_ALPHA), color2);
			}
		}

		original.call(pipeline, textureSetup, x1, y1, x2, y2, color, color2);
	}

	@WrapMethod(method = "drawTexturedQuad(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lcom/mojang/blaze3d/textures/GpuTextureView;IIIIFFFFI)V")
	private void quadWithTransparency(
		RenderPipeline pipeline, GpuTextureView texture, int x1, int y1, int x2, int y2, float u1, float u2, float v1, float v2, int color, Operation<Void> original
	) {
		if (InventoryOverlay.isRenderingTransparentItem) {
			if (pipeline.getBlendFunction().isPresent() && pipeline.getBlendFunction().get().destAlpha() == DestFactor.ZERO) {
				color = class_9848.method_61321(color, InventoryOverlay.MISSING_ITEM_ALPHA);
			} else {
				color = class_9848.method_61330(Math.round(class_9848.method_61320(color) * InventoryOverlay.MISSING_ITEM_ALPHA), color);
			}
		}

		original.call(pipeline, texture, x1, y1, x2, y2, u1, u2, v1, v2, color);
	}

	@WrapMethod(method = "drawText(Lnet/minecraft/client/font/TextRenderer;Lnet/minecraft/text/OrderedText;IIIZ)V")
	private void textWithTransparency(class_327 textRenderer, class_5481 text, int x, int y, int color, boolean shadow, Operation<Void> original) {
		if (InventoryOverlay.isRenderingTransparentItem) {
			color = class_9848.method_61330(Math.round(class_9848.method_61320(color) * InventoryOverlay.MISSING_ITEM_ALPHA), color);
		}

		original.call(textRenderer, text, x, y, color, shadow);
	}
}
