package dev.kikugie.techutils.util;

import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacementManager;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.SchematicUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

/**
 * Represents world position inside a schematic placement.
 *
 * @param pos       Block position in subregion's block state array.
 * @param region    Name of the targeted subregion
 * @param placement Targeted schematic placement instance
 */
public record LocalPlacementPos(class_2338 pos, String region, SchematicPlacement placement) {
	public static class_2338 getWorldPos(class_2338 pos, String region, SchematicPlacement placement) {
		return placement.getOrigin().method_10081(PositionUtils.getTransformedPlacementPosition(pos, placement, Objects.requireNonNull(placement.getRelativeSubRegionPlacement(region))));
	}

	public static Optional<LocalPlacementPos> get(class_2338 worldPos) {
		List<SchematicPlacementManager.PlacementPart> parts = DataManager
			.getSchematicPlacementManager()
			.getAllPlacementsTouchingChunk(worldPos);

		for (SchematicPlacementManager.PlacementPart part : parts) {
			if (!part.getBox().containsPos(worldPos))
				continue;

			SchematicPlacement placement = part.placement;
			String region = part.subRegionName;
			LitematicaBlockStateContainer container = placement.getSchematic().getSubRegionContainer(region);
			class_2338 schematicPos = SchematicUtils.getSchematicContainerPositionFromWorldPosition(
				worldPos,
				placement.getSchematic(),
				region,
				placement,
				Objects.requireNonNull(
					placement.getRelativeSubRegionPlacement(region),
					"Somehow subregion is null"),
				container);
			return Optional.of(new LocalPlacementPos(schematicPos, region, placement));
		}
		return Optional.empty();
	}

	public class_2338 getWorldPos() {
		return getWorldPos(this.pos, this.region, this.placement);
	}

	public class_2680 blockState() {
		return this.placement.getSchematic().getSubRegionContainer(this.region).get(this.pos.method_10263(), this.pos.method_10264(), this.pos.method_10260());
	}
}
