/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.blocks;

import lilypuree.decorative_blocks.compat.SoulFired;
import lilypuree.decorative_blocks.platform.Services;
import lilypuree.decorative_blocks.registration.DBBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BonfireBlock
extends Block
implements SimpleWaterloggedBlock {
    private static final VoxelShape BONFIRE_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public BonfireBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.below();
        return worldIn.getBlockState(blockpos).isFaceSturdy((BlockGetter)worldIn, blockpos, Direction.UP);
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return BONFIRE_SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.empty();
    }

    public void entityInside(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!entityIn.fireImmune() && entityIn instanceof LivingEntity) {
            entityIn.hurt(entityIn.damageSources().inFire(), 1.0f);
            if (Services.PLATFORM.isModLoaded("soul_fire_d")) {
                SoulFired.setSecondsOnFire(entityIn, 3, state.is((Block)DBBlocks.SOUL_BONFIRE.get()));
            } else {
                entityIn.igniteForSeconds(3.0f);
            }
        }
        super.entityInside(state, worldIn, pos, entityIn);
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        if (rand.nextInt(18) == 0) {
            worldIn.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), SoundEvents.FIRE_AMBIENT, SoundSource.BLOCKS, 1.5f + rand.nextFloat(), rand.nextFloat() * 0.7f + 0.3f, false);
        }
        if (rand.nextInt(10) == 0) {
            worldIn.playLocalSound((double)((float)pos.getX() + 0.5f), (double)((float)pos.getY() + 0.5f), (double)((float)pos.getZ() + 0.5f), SoundEvents.CAMPFIRE_CRACKLE, SoundSource.BLOCKS, (float)((double)0.6f + (double)rand.nextFloat() * 0.3), rand.nextFloat() * 0.6f + 0.5f, false);
        }
        for (int i = 0; i < 3; ++i) {
            double x = (double)pos.getX() + rand.nextDouble();
            double y = (double)pos.getY() + rand.nextDouble() * 0.5 + 1.5;
            double z = (double)pos.getZ() + rand.nextDouble();
            worldIn.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, x, y, z, -0.03 + rand.nextDouble() * 0.06, rand.nextDouble() * 0.1, -0.03 + rand.nextDouble() * 0.06);
        }
    }

    public boolean canPlaceLiquid(@Nullable Player player, BlockGetter worldIn, BlockPos pos, BlockState state, Fluid fluidIn) {
        return false;
    }

    public boolean placeLiquid(LevelAccessor worldIn, BlockPos pos, BlockState state, FluidState fluidStateIn) {
        if (fluidStateIn.getType() == Fluids.WATER) {
            if (!worldIn.isClientSide()) {
                worldIn.setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                worldIn.playSound(null, pos, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 1.2f, 0.6f);
            } else {
                BonfireBlock.spawnExtinguishSmoke(worldIn, pos);
            }
            return true;
        }
        return false;
    }

    public static void spawnExtinguishSmoke(LevelAccessor world, BlockPos pos) {
        RandomSource rand = world.getRandom();
        for (int i = 0; i < 5; ++i) {
            double d0 = world.getRandom().nextGaussian() * 0.02;
            double d1 = world.getRandom().nextGaussian() * 0.02;
            double d2 = world.getRandom().nextGaussian() * 0.02;
            world.addParticle((ParticleOptions)ParticleTypes.CLOUD, (double)pos.getX() + (double)rand.nextFloat(), (double)pos.getY() + 0.4 + (double)rand.nextFloat(), (double)pos.getZ() + (double)rand.nextFloat(), d0, d1, d2);
        }
        world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.25 + rand.nextDouble() / 2.0 * (double)(rand.nextBoolean() ? 1 : -1), (double)pos.getY() + 0.4, (double)pos.getZ() + 0.25 + rand.nextDouble() / 2.0 * (double)(rand.nextBoolean() ? 1 : -1), 0.0, 0.005, 0.0);
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.canSurvive(stateIn, (LevelReader)worldIn, currentPos) ? stateIn : Blocks.AIR.defaultBlockState();
    }
}

