/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChainBlock
extends RotatedPillarBlock
implements SimpleWaterloggedBlock {
    private static final double d0 = 4.0;
    private static final double d1 = 12.0;
    protected static final VoxelShape CHAIN_SHAPE_X = Block.box((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    protected static final VoxelShape CHAIN_SHAPE_Y = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape CHAIN_SHAPE_Z = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
    private static final VoxelShape CHAIN_COLLISION_SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;

    public ChainBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)AXIS);
        switch (axis) {
            case X: {
                return CHAIN_SHAPE_X;
            }
            case Z: {
                return CHAIN_SHAPE_Z;
            }
        }
        return CHAIN_SHAPE_Y;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        if (state.getValue((Property)AXIS) == Direction.Axis.Y) {
            return CHAIN_COLLISION_SHAPE;
        }
        return super.getCollisionShape(state, worldIn, pos, context);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = ifluidstate.is(FluidTags.WATER) && ifluidstate.getAmount() == 8;
        return (BlockState)super.getStateForPlacement(context).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{WATERLOGGED});
    }
}

