/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ChandelierBlock
extends Block {
    protected final VoxelShape CHANDELIER_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0);
    private final boolean isSoul;

    public ChandelierBlock(BlockBehaviour.Properties properties, boolean isSoul) {
        super(properties);
        this.isSoul = isSoul;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.CHANDELIER_SHAPE;
    }

    public void animateTick(BlockState stateIn, Level worldIn, BlockPos pos, RandomSource rand) {
        double d0 = (double)pos.getX() + 0.5;
        double d1 = (double)pos.getY() + 0.7;
        double d2 = (double)pos.getZ() + 0.5;
        double off1 = 0.1875;
        double off2 = 0.3125;
        double off3 = 0.0625;
        worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 - off1, d1, d2 - off2, 0.0, 0.0, 0.0);
        worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 - off2 - off3, d1, d2 + off1 - off3, 0.0, 0.0, 0.0);
        worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + off1 - off3, d1, d2 + off2 + off3, 0.0, 0.0, 0.0);
        worldIn.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + off2, d1, d2 - off1, 0.0, 0.0, 0.0);
        if (this.isSoul) {
            worldIn.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, d0 - off1, d1, d2 - off2, 0.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, d0 - off2 - off3, d1, d2 + off1 - off3, 0.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, d0 + off1 - off3, d1, d2 + off2 + off3, 0.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.SOUL_FIRE_FLAME, d0 + off2, d1, d2 - off1, 0.0, 0.0, 0.0);
        } else {
            worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 - off1, d1, d2 - off2, 0.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 - off2 - off3, d1, d2 + off1 - off3, 0.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + off1 - off3, d1, d2 + off2 + off3, 0.0, 0.0, 0.0);
            worldIn.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + off2, d1, d2 - off1, 0.0, 0.0, 0.0);
        }
    }
}

