/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.state.ModBlockProperties;
import lilypuree.decorative_blocks.entity.DummyEntityForSitting;
import lilypuree.decorative_blocks.items.SwitchableBlockItem;
import lilypuree.decorative_blocks.registration.Registration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SeatBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
IWoodenBlock {
    public static final MapCodec<SeatBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)WoodType.CODEC.fieldOf("wood_type").forGetter(block -> block.woodType), (App)SeatBlock.propertiesCodec()).apply((Applicative)inst, SeatBlock::new));
    protected static final VoxelShape POST_SHAPE = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    protected static final VoxelShape TOP_POST = Block.box((double)6.0, (double)7.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected static final VoxelShape JOIST_NS = Block.box((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)7.0, (double)12.0);
    protected static final VoxelShape JOIST_EW = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)7.0, (double)16.0);
    protected static final VoxelShape SEAT_NS = Shapes.or((VoxelShape)POST_SHAPE, (VoxelShape)JOIST_NS);
    protected static final VoxelShape SEAT_EW = Shapes.or((VoxelShape)POST_SHAPE, (VoxelShape)JOIST_EW);
    protected static final VoxelShape JOIST_POST_NS = Shapes.or((VoxelShape)TOP_POST, (VoxelShape)JOIST_NS);
    protected static final VoxelShape JOIST_POST_EW = Shapes.or((VoxelShape)TOP_POST, (VoxelShape)JOIST_EW);
    protected static final VoxelShape SEAT_POST_NS = Shapes.or((VoxelShape)SEAT_NS, (VoxelShape)TOP_POST);
    protected static final VoxelShape SEAT_POST_EW = Shapes.or((VoxelShape)SEAT_EW, (VoxelShape)TOP_POST);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    public static final BooleanProperty ATTACHED = BlockStateProperties.ATTACHED;
    public static final BooleanProperty POST = ModBlockProperties.POST;
    private WoodType woodType;

    public SeatBlock(WoodType woodType, BlockBehaviour.Properties properties) {
        super(properties);
        this.woodType = woodType;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(false))).setValue((Property)POST, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public WoodType getWoodType() {
        return this.woodType;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction facing = (Direction)state.getValue((Property)FACING);
        boolean attached = (Boolean)state.getValue((Property)ATTACHED);
        boolean post = (Boolean)state.getValue((Property)POST);
        return switch (facing) {
            case Direction.NORTH, Direction.SOUTH -> {
                if (attached) {
                    if (post) {
                        yield SEAT_POST_NS;
                    }
                    yield SEAT_NS;
                }
                if (post) {
                    yield JOIST_POST_NS;
                }
                yield JOIST_NS;
            }
            case Direction.EAST, Direction.WEST -> {
                if (attached) {
                    if (post) {
                        yield SEAT_POST_EW;
                    }
                    yield SEAT_EW;
                }
                if (post) {
                    yield JOIST_POST_EW;
                }
                yield JOIST_EW;
            }
            default -> SEAT_NS;
        };
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        FluidState ifluidstate = world.getFluidState(pos);
        ItemStack stack = context.getItemInHand();
        boolean waterloggedFlag = ifluidstate.is(FluidTags.WATER) && ifluidstate.getAmount() == 8;
        boolean attachedFlag = this.isInAttachablePos((LevelReader)world, pos);
        Direction facingDir = context.getClickedFace();
        Direction placementDir = facingDir == Direction.DOWN || facingDir == Direction.UP ? context.getHorizontalDirection().getOpposite() : facingDir.getClockWise();
        BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)placementDir)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterloggedFlag))).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false))).setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(attachedFlag));
        if (stack.getItem() instanceof SwitchableBlockItem) {
            blockstate = ((SwitchableBlockItem)stack.getItem()).getSwitchedState(blockstate, stack);
        }
        return blockstate;
    }

    public BlockState updateShape(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.getValue((Property)WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        if (facing == Direction.DOWN) {
            return (BlockState)stateIn.setValue((Property)ATTACHED, (Comparable)Boolean.valueOf(this.isInAttachablePos((LevelReader)worldIn, currentPos)));
        }
        return stateIn;
    }

    private boolean isInAttachablePos(LevelReader worldIn, BlockPos pos) {
        if (worldIn.getBlockState(pos.below()).getBlock() == Blocks.LANTERN) {
            return true;
        }
        return Block.canSupportCenter((LevelReader)worldIn, (BlockPos)pos.below(), (Direction)Direction.UP);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, OCCUPIED, ATTACHED, POST});
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = stack.getItem();
        if (!level.isClientSide && item instanceof BlockItem && ((BlockItem)item).getBlock() instanceof LanternBlock) {
            if (hit.getDirection() != Direction.DOWN || !level.getBlockState(pos.below()).isAir()) {
                return ItemInteractionResult.FAIL;
            }
            BlockState newState = (BlockState)state.setValue((Property)ATTACHED, (Comparable)Boolean.TRUE);
            level.setBlockAndUpdate(pos, newState);
            level.sendBlockUpdated(pos, state, newState, 3);
            level.setBlock(pos.below(), (BlockState)((BlockItem)item).getBlock().defaultBlockState().setValue((Property)BlockStateProperties.HANGING, (Comparable)Boolean.TRUE), 19);
            stack.consume(1, (LivingEntity)player);
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit) {
        if (!level.isClientSide && hit.getDirection() == Direction.UP && !((Boolean)state.getValue((Property)OCCUPIED)).booleanValue() && !((Boolean)state.getValue((Property)POST)).booleanValue() && level.getBlockState(pos.above()).isAir() && SeatBlock.isPlayerInRange(player, pos)) {
            DummyEntityForSitting seat = (DummyEntityForSitting)Registration.DUMMY_ENTITY_TYPE.get().create(level);
            seat.setSeatPos(pos);
            level.addFreshEntity((Entity)seat);
            player.startRiding((Entity)seat);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hit);
    }

    private static boolean isPlayerInRange(Player player, BlockPos pos) {
        Vec3 position = pos.getCenter();
        int blockReachDistance = 2;
        AABB range = AABB.ofSize((Vec3)position, (double)blockReachDistance, (double)blockReachDistance, (double)blockReachDistance);
        return range.contains(player.position());
    }

    public void onRemove(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        double x = pos.getX();
        double y = pos.getY();
        double z = pos.getZ();
        List entities = worldIn.getEntitiesOfClass(DummyEntityForSitting.class, new AABB(x, y, z, x + 1.0, y + 1.0, z + 1.0));
        for (DummyEntityForSitting entity : entities) {
            entity.remove(Entity.RemovalReason.DISCARDED);
        }
        super.onRemove(state, worldIn, pos, newState, isMoving);
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }
}

