/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.state.ModBlockProperties;
import lilypuree.decorative_blocks.blocks.state.SupportFaceShape;
import lilypuree.decorative_blocks.items.SwitchableBlockItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SupportBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock,
IWoodenBlock {
    public static final MapCodec<SupportBlock> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)WoodType.CODEC.fieldOf("wood_type").forGetter(block -> block.woodType), (App)SupportBlock.propertiesCodec()).apply((Applicative)inst, SupportBlock::new));
    private static final double d0 = 3.0;
    private static final double d1 = 13.0;
    private static final double d2 = 4.0;
    private static final double d3 = 12.0;
    private static final VoxelShape TOP_LARGE = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape TOP_SMALL_NS = Block.box((double)4.0, (double)13.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0);
    private static final VoxelShape TOP_SMALL_EW = Block.box((double)0.0, (double)13.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0);
    private static final VoxelShape BOTTOM_LARGE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape BOTTOM_SMALL_NS = Block.box((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)3.0, (double)16.0);
    private static final VoxelShape BOTTOM_SMALL_EW = Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)3.0, (double)12.0);
    private static final Map<Direction, VoxelShape> verticalLarge;
    private static final Map<Direction, VoxelShape> verticalSmall;
    public static final BooleanProperty WATERLOGGED;
    public static final BooleanProperty UP;
    public static final EnumProperty<SupportFaceShape> HORIZONTAL_SHAPE;
    public static final EnumProperty<SupportFaceShape> VERTICAL_SHAPE;
    private WoodType woodType;
    private final ImmutableMap<BlockState, VoxelShape> stateToShapeMap;

    public SupportBlock(WoodType woodType, BlockBehaviour.Properties properties) {
        super(properties);
        this.woodType = woodType;
        this.stateToShapeMap = SupportBlock.getStateToShapeMap((StateDefinition<Block, BlockState>)this.getStateDefinition());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)UP, (Comparable)Boolean.TRUE)).setValue(HORIZONTAL_SHAPE, (Comparable)((Object)SupportFaceShape.BIG))).setValue(VERTICAL_SHAPE, (Comparable)((Object)SupportFaceShape.SMALL)));
    }

    @Override
    public WoodType getWoodType() {
        return this.woodType;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (VoxelShape)this.stateToShapeMap.get((Object)state);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState ifluidstate = context.getLevel().getFluidState(context.getClickedPos());
        boolean flag = ifluidstate.is(FluidTags.WATER) && ifluidstate.getAmount() == 8;
        BlockState blockstate = (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(flag));
        ItemStack stack = context.getItemInHand();
        if (stack.getItem() instanceof SwitchableBlockItem) {
            blockstate = ((SwitchableBlockItem)stack.getItem()).getSwitchedState(blockstate, stack);
        }
        if (!((Boolean)blockstate.getValue((Property)UP)).booleanValue()) {
            blockstate = (BlockState)blockstate.setValue(HORIZONTAL_SHAPE, (Comparable)((Object)SupportFaceShape.SMALL));
        }
        return blockstate;
    }

    public static void onSupportActivation(BlockState state, Level worldIn, BlockPos pos, Player player, Vec3 hitPos) {
        boolean hitVertical;
        double hitHeight = hitPos.y() - (double)pos.getY();
        if (((SupportFaceShape)((Object)state.getValue(HORIZONTAL_SHAPE))).isHidden()) {
            hitVertical = true;
        } else if (((SupportFaceShape)((Object)state.getValue(VERTICAL_SHAPE))).isHidden()) {
            hitVertical = false;
        } else if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            hitVertical = hitHeight < 0.8125;
        } else {
            boolean bl = hitVertical = hitHeight > 0.1875;
        }
        if (player.isShiftKeyDown()) {
            if (hitVertical) {
                if (!((SupportFaceShape)((Object)state.getValue(HORIZONTAL_SHAPE))).isHidden()) {
                    worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue(VERTICAL_SHAPE, (Comparable)((Object)SupportFaceShape.HIDDEN)));
                } else {
                    worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue(HORIZONTAL_SHAPE, (Comparable)((Object)SupportFaceShape.BIG)));
                }
            } else if (!((SupportFaceShape)((Object)state.getValue(VERTICAL_SHAPE))).isHidden()) {
                worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue(HORIZONTAL_SHAPE, (Comparable)((Object)SupportFaceShape.HIDDEN)));
            } else {
                worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue(VERTICAL_SHAPE, (Comparable)((Object)SupportFaceShape.SMALL)));
            }
        } else if (hitVertical) {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue(VERTICAL_SHAPE, (Comparable)((Object)((SupportFaceShape)((Object)state.getValue(VERTICAL_SHAPE))).getSwitched())));
        } else {
            worldIn.setBlockAndUpdate(pos, (BlockState)state.setValue(HORIZONTAL_SHAPE, (Comparable)((Object)((SupportFaceShape)((Object)state.getValue(HORIZONTAL_SHAPE))).getSwitched())));
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, WATERLOGGED, UP, HORIZONTAL_SHAPE, VERTICAL_SHAPE});
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter reader, BlockPos pos) {
        return (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    public boolean isPathfindable(BlockState state, PathComputationType pathComputationType) {
        return false;
    }

    private static ImmutableMap<BlockState, VoxelShape> getStateToShapeMap(StateDefinition<Block, BlockState> stateManager) {
        Map map = stateManager.getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), SupportBlock::getShapeForState));
        return ImmutableMap.copyOf(map);
    }

    private static VoxelShape getShapeForState(BlockState blockState) {
        boolean up = (Boolean)blockState.getValue((Property)UP);
        Direction dir = (Direction)blockState.getValue((Property)FACING);
        boolean ns = dir.getAxis() == Direction.Axis.Z;
        VoxelShape horizontal = Shapes.empty();
        VoxelShape vertical = Shapes.empty();
        switch ((SupportFaceShape)((Object)blockState.getValue(HORIZONTAL_SHAPE))) {
            case BIG: {
                horizontal = up ? TOP_LARGE : BOTTOM_LARGE;
                break;
            }
            case SMALL: {
                horizontal = up ? (ns ? TOP_SMALL_NS : TOP_SMALL_EW) : (ns ? BOTTOM_SMALL_NS : BOTTOM_SMALL_EW);
            }
        }
        switch ((SupportFaceShape)((Object)blockState.getValue(VERTICAL_SHAPE))) {
            case BIG: {
                vertical = verticalLarge.get(dir);
                break;
            }
            case SMALL: {
                vertical = verticalSmall.get(dir);
                break;
            }
            case HIDDEN: {
                if (horizontal != Shapes.empty()) break;
                return Shapes.block();
            }
        }
        return Shapes.or((VoxelShape)horizontal, (VoxelShape)vertical);
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    static {
        WATERLOGGED = BlockStateProperties.WATERLOGGED;
        UP = BlockStateProperties.UP;
        HORIZONTAL_SHAPE = ModBlockProperties.HORIZONTAL_SHAPE;
        VERTICAL_SHAPE = ModBlockProperties.VERTICAL_SHAPE;
        verticalSmall = new EnumMap<Direction, VoxelShape>(Direction.class);
        verticalLarge = new EnumMap<Direction, VoxelShape>(Direction.class);
        Direction.Plane.HORIZONTAL.stream().forEach(dir -> {
            int x = dir.getStepX();
            int z = dir.getStepZ();
            verticalLarge.put((Direction)dir, Block.box((double)((double)((1 - x * x) * 0) + (double)(x * x) * (6.5 - 6.5 * (double)x)), (double)0.0, (double)((double)((1 - z * z) * 0) + (double)(z * z) * (6.5 - 6.5 * (double)z)), (double)((double)((1 - x * x) * 16) + (double)(x * x) * (9.5 + -6.5 * (double)x)), (double)16.0, (double)((double)((1 - z * z) * 16) + (double)(z * z) * (9.5 + -6.5 * (double)z))));
            verticalSmall.put((Direction)dir, Block.box((double)((double)(1 - x * x) * 4.0 + (double)(x * x) * (6.5 - 6.5 * (double)x)), (double)0.0, (double)((double)(1 - z * z) * 4.0 + (double)(z * z) * (6.5 - 6.5 * (double)z)), (double)((double)(1 - x * x) * 12.0 + (double)(x * x) * (9.5 + -6.5 * (double)x)), (double)16.0, (double)((double)(1 - z * z) * 12.0 + (double)(z * z) * (9.5 + -6.5 * (double)z))));
        });
    }
}

