/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.client;

import com.mojang.blaze3d.systems.RenderSystem;
import lilypuree.decorative_blocks.fluid.ThatchFluid;
import lilypuree.decorative_blocks.registration.DBTags;
import net.minecraft.client.Camera;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;

public class FogHelper {
    public static Info onColorFog(Camera camera) {
        Level level;
        FluidState state;
        Fluid fluid;
        Entity entity = camera.getEntity();
        if (entity.isEyeInFluid(DBTags.Fluids.THATCH) && (fluid = (state = (level = entity.getCommandSenderWorld()).getFluidState(BlockPos.containing((Position)entity.getEyePosition()))).getType()) instanceof ThatchFluid) {
            ThatchFluid thatchFluid = (ThatchFluid)fluid;
            int color = thatchFluid.getReferenceHolder().color();
            return FogHelper.decodeColor(color);
        }
        return null;
    }

    public static Info decodeColor(int color) {
        float fogRed = (float)(color >> 16 & 0xFF) / 255.0f;
        float fogGreen = (float)(color >> 8 & 0xFF) / 255.0f;
        float fogBlue = (float)(color & 0xFF) / 255.0f;
        long biomeChangedTime = -1L;
        return new Info(fogRed, fogGreen, fogBlue, biomeChangedTime);
    }

    public static void onFogSetup(Entity entity, float farPlaneDist) {
        float end;
        float start;
        if (entity.isSpectator()) {
            start = -8.0f;
            end = farPlaneDist * 0.5f;
        } else {
            start = 0.25f;
            end = 1.0f;
        }
        RenderSystem.setShaderFogStart((float)start);
        RenderSystem.setShaderFogEnd((float)end);
    }

    public record Info(float fogRed, float fogGreen, float fogBlue, long time) {
    }
}

