/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.items;

import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class SwitchableBlockItem
extends BlockItem {
    private final BooleanProperty switching;
    private final boolean defaultState;

    public SwitchableBlockItem(Block blockIn, Item.Properties builder, BooleanProperty switching, boolean defaultState) {
        super(blockIn, builder);
        this.switching = switching;
        this.defaultState = defaultState;
    }

    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand handIn) {
        if (playerIn.isShiftKeyDown()) {
            if (!worldIn.isClientSide()) {
                this.cycleValueTag(playerIn.getItemInHand(handIn));
            }
            return InteractionResultHolder.success((Object)playerIn.getItemInHand(handIn));
        }
        return super.use(worldIn, playerIn, handIn);
    }

    public BlockState getSwitchedState(BlockState state, ItemStack stack) {
        if (state != null && state.hasProperty((Property)this.switching)) {
            state = (BlockState)state.setValue((Property)this.switching, (Comparable)((Boolean)state.getBlock().defaultBlockState().getValue((Property)this.switching)));
            state.setValue((Property)this.switching, (Comparable)Boolean.valueOf(this.getValue(stack)));
        }
        return state;
    }

    private boolean getValue(ItemStack stack) {
        BlockItemStateProperties properties = (BlockItemStateProperties)stack.get(DataComponents.BLOCK_STATE);
        if (properties == null) {
            return this.defaultState;
        }
        Boolean val = (Boolean)properties.get((Property)this.switching);
        return val != null ? val : this.defaultState;
    }

    public void cycleValueTag(ItemStack stack) {
        Boolean val;
        BlockItemStateProperties component = (BlockItemStateProperties)stack.get(DataComponents.BLOCK_STATE);
        if (component == null) {
            component = BlockItemStateProperties.EMPTY;
        }
        stack.set(DataComponents.BLOCK_STATE, (Object)component.with((Property)this.switching, (Comparable)Boolean.valueOf((val = (Boolean)component.get((Property)this.switching)) != null ? !val.booleanValue() : !this.defaultState)));
    }

    public static boolean getValueForStack(ItemStack stack) {
        Item item = stack.getItem();
        return item instanceof SwitchableBlockItem && ((SwitchableBlockItem)item).getValue(stack);
    }
}

