/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.registration;

import com.google.common.collect.ImmutableMap;
import java.util.function.Supplier;
import lilypuree.decorative_blocks.blocks.BarPanelBlock;
import lilypuree.decorative_blocks.blocks.BeamBlock;
import lilypuree.decorative_blocks.blocks.BonfireBlock;
import lilypuree.decorative_blocks.blocks.BrazierBlock;
import lilypuree.decorative_blocks.blocks.ChainBlock;
import lilypuree.decorative_blocks.blocks.ChandelierBlock;
import lilypuree.decorative_blocks.blocks.IWoodenBlock;
import lilypuree.decorative_blocks.blocks.LatticeBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.PillarBlock;
import lilypuree.decorative_blocks.blocks.RockyDirtBlock;
import lilypuree.decorative_blocks.blocks.SeatBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import lilypuree.decorative_blocks.platform.Services;
import lilypuree.decorative_blocks.registration.BlockWrapper;
import lilypuree.decorative_blocks.registration.DBNames;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class DBBlocks {
    public static final BlockWrapper<BonfireBlock> BONFIRE;
    public static final BlockWrapper<ChandelierBlock> CHANDELIER;
    public static final BlockWrapper<BrazierBlock> BRAZIER;
    public static final BlockWrapper<ChandelierBlock> SOUL_CHANDELIER;
    public static final BlockWrapper<BrazierBlock> SOUL_BRAZIER;
    public static final BlockWrapper<BonfireBlock> SOUL_BONFIRE;
    public static final BlockWrapper<BarPanelBlock> BAR_PANEL;
    public static final BlockWrapper<LatticeBlock> LATTICE;
    public static final BlockWrapper<ChainBlock> CHAIN;
    public static final BlockWrapper<PillarBlock> STONE_PILLAR;
    public static final BlockWrapper<RockyDirtBlock> ROCKY_DIRT;
    public static final ImmutableMap<WoodType, BlockWrapper<BeamBlock>> BEAMS;
    public static final ImmutableMap<WoodType, BlockWrapper<PalisadeBlock>> PALISADES;
    public static final ImmutableMap<WoodType, BlockWrapper<SupportBlock>> SUPPORTS;
    public static final ImmutableMap<WoodType, BlockWrapper<SeatBlock>> SEATS;

    public static void init() {
    }

    public static IWoodenBlock createDecorativeBlock(WoodType wood, MapColor mapColor, WoodDecorativeBlockTypes woodDecorativeBlockType) {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.of().mapColor(mapColor).sound(wood.soundType());
        if (!VanillaWoodTypes.isNetherWood(wood)) {
            properties.ignitedByLava();
        }
        if (woodDecorativeBlockType == WoodDecorativeBlockTypes.PALISADE) {
            properties.strength(2.0f, 4.0f);
        } else {
            properties.strength(1.2f);
        }
        return woodDecorativeBlockType.create(wood, properties);
    }

    private static <T extends Block> BlockWrapper<T> registerBlock(String name, Supplier<T> blockSupplier) {
        return new BlockWrapper<T>(Services.PLATFORM.register(BuiltInRegistries.BLOCK, name, blockSupplier));
    }

    static {
        BlockBehaviour.Properties chainProperties = BlockBehaviour.Properties.of().mapColor(MapColor.METAL).strength(4.3f).sound(SoundType.METAL).noOcclusion();
        BlockBehaviour.Properties bonfire = BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(0.0f).mapColor(MapColor.FIRE).pushReaction(PushReaction.DESTROY).replaceable().noCollission().lightLevel(state -> 15).noLootTable();
        BlockBehaviour.Properties soul_bonfire = BlockBehaviour.Properties.of().sound(SoundType.WOOL).strength(0.0f).mapColor(MapColor.COLOR_CYAN).pushReaction(PushReaction.DESTROY).replaceable().noCollission().lightLevel(state -> 14).noLootTable();
        BlockBehaviour.Properties chandelier = BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.3f).pushReaction(PushReaction.DESTROY).replaceable().noCollission().noOcclusion().lightLevel(state -> 15);
        BlockBehaviour.Properties soul_chandelier = BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(0.3f).pushReaction(PushReaction.DESTROY).replaceable().noCollission().noOcclusion().lightLevel(state -> 11);
        BlockBehaviour.Properties brazier = BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(3.0f).mapColor(MapColor.METAL).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 15 : 0);
        BlockBehaviour.Properties soul_brazier = BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(3.0f).mapColor(MapColor.METAL).noOcclusion().lightLevel(state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? 10 : 0);
        BlockBehaviour.Properties bar_panel = BlockBehaviour.Properties.of().sound(SoundType.METAL).strength(5.0f).mapColor(MapColor.METAL).noOcclusion();
        BlockBehaviour.Properties lattice = BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(1.2f).mapColor(MapColor.WOOD).noOcclusion();
        BlockBehaviour.Properties pillar = BlockBehaviour.Properties.of().sound(SoundType.STONE).strength(1.5f, 6.5f).mapColor(MapColor.STONE);
        BONFIRE = DBBlocks.registerBlock("bonfire", () -> new BonfireBlock(bonfire));
        CHANDELIER = DBBlocks.registerBlock("chandelier", () -> new ChandelierBlock(chandelier, false));
        BRAZIER = DBBlocks.registerBlock("brazier", () -> new BrazierBlock(brazier, false));
        SOUL_BONFIRE = DBBlocks.registerBlock("soul_bonfire", () -> new BonfireBlock(soul_bonfire));
        SOUL_CHANDELIER = DBBlocks.registerBlock("soul_chandelier", () -> new ChandelierBlock(soul_chandelier, true));
        SOUL_BRAZIER = DBBlocks.registerBlock("soul_brazier", () -> new BrazierBlock(soul_brazier, true));
        BAR_PANEL = DBBlocks.registerBlock("bar_panel", () -> new BarPanelBlock(bar_panel));
        LATTICE = DBBlocks.registerBlock("lattice", () -> new LatticeBlock(lattice));
        CHAIN = DBBlocks.registerBlock("chain", () -> new ChainBlock(chainProperties));
        STONE_PILLAR = DBBlocks.registerBlock("stone_pillar", () -> new PillarBlock(pillar));
        ROCKY_DIRT = DBBlocks.registerBlock("rocky_dirt", RockyDirtBlock::new);
        ImmutableMap.Builder beams = new ImmutableMap.Builder();
        ImmutableMap.Builder palisades = new ImmutableMap.Builder();
        ImmutableMap.Builder supports = new ImmutableMap.Builder();
        ImmutableMap.Builder seats = new ImmutableMap.Builder();
        for (WoodType woodType : VanillaWoodTypes.VANILLA) {
            MapColor mapColor = VanillaWoodTypes.getPlanks(woodType).defaultMapColor();
            if (woodType != WoodType.BAMBOO) {
                beams.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.BEAM), () -> (BeamBlock)DBBlocks.createDecorativeBlock(woodType, mapColor, WoodDecorativeBlockTypes.BEAM)));
            }
            palisades.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.PALISADE), () -> (PalisadeBlock)DBBlocks.createDecorativeBlock(woodType, mapColor, WoodDecorativeBlockTypes.PALISADE)));
            supports.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.SUPPORT), () -> (SupportBlock)DBBlocks.createDecorativeBlock(woodType, mapColor, WoodDecorativeBlockTypes.SUPPORT)));
            seats.put((Object)woodType, DBBlocks.registerBlock(DBNames.name(woodType, WoodDecorativeBlockTypes.SEAT), () -> (SeatBlock)DBBlocks.createDecorativeBlock(woodType, mapColor, WoodDecorativeBlockTypes.SEAT)));
        }
        BEAMS = beams.build();
        PALISADES = palisades.build();
        SUPPORTS = supports.build();
        SEATS = seats.build();
    }
}

