/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.registration;

import java.util.function.Supplier;
import lilypuree.decorative_blocks.entity.DummyEntityForSitting;
import lilypuree.decorative_blocks.fluid.ThatchFluid;
import lilypuree.decorative_blocks.platform.Services;
import lilypuree.decorative_blocks.registration.DBItems;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;

public class Registration {
    private static final ResourceLocation thatchStillTexture = ResourceLocation.fromNamespaceAndPath((String)"decorative_blocks", (String)"block/thatch_still");
    private static final ResourceLocation thatchFlowingTexture = ResourceLocation.fromNamespaceAndPath((String)"decorative_blocks", (String)"block/thatch_flowing");
    public static final ThatchFluid.FluidReferenceHolder referenceHolder;
    public static final Supplier<ThatchFluid.Flowing> FLOWING_THATCH;
    public static final Supplier<ThatchFluid.Source> STILL_THATCH;
    public static Supplier<LiquidBlock> THATCH_BLOCK;
    public static final Supplier<CreativeModeTab> ITEM_GROUP;
    public static Supplier<EntityType<DummyEntityForSitting>> DUMMY_ENTITY_TYPE;

    public static void init() {
    }

    private static CreativeModeTab getTab() {
        CreativeModeTab.Builder builder = Services.PLATFORM.createModTab();
        builder.icon(() -> DBItems.BRAZIER.get().getDefaultInstance()).title((Component)Component.translatable((String)String.format("itemGroup.%s.general", "decorative_blocks")));
        builder.displayItems((itemDisplayParameters, output) -> {
            output.accept(DBItems.CHANDELIER::get);
            output.accept(DBItems.SOUL_CHANDELIER::get);
            output.accept(DBItems.BRAZIER::get);
            output.accept(DBItems.SOUL_BRAZIER::get);
            output.accept(DBItems.BAR_PANEL::get);
            output.accept(DBItems.LATTICE::get);
            output.accept(DBItems.CHAIN::get);
            output.accept(DBItems.STONE_PILLAR::get);
            output.accept(DBItems.ROCKY_DIRT::get);
            DBItems.BEAM_ITEMBLOCKS.values().forEach(regObject -> output.accept(regObject::get));
            DBItems.SEAT_ITEMBLOCKS.values().forEach(regObject -> output.accept(regObject::get));
            DBItems.SUPPORT_ITEMBLOCKS.values().forEach(regObject -> output.accept(regObject::get));
            DBItems.PALISADE_ITEMBLOCKS.values().forEach(regObject -> output.accept(regObject::get));
        });
        return builder.build();
    }

    static {
        ITEM_GROUP = Services.PLATFORM.register(BuiltInRegistries.CREATIVE_MODE_TAB, "general", Registration::getTab);
        BlockBehaviour.Properties thatchProperties = BlockBehaviour.Properties.of().liquid().replaceable().noCollission().randomTicks().noLootTable().mapColor(MapColor.COLOR_YELLOW).pushReaction(PushReaction.DESTROY).strength(100.0f);
        referenceHolder = new ThatchFluid.FluidReferenceHolder(() -> Blocks.HAY_BLOCK, () -> THATCH_BLOCK.get(), () -> FLOWING_THATCH.get(), () -> STILL_THATCH.get(), thatchStillTexture, thatchFlowingTexture, 11308296);
        FLOWING_THATCH = Services.PLATFORM.register(BuiltInRegistries.FLUID, "flowing_thatch", () -> Services.PLATFORM.createThatchFlowingFluid(referenceHolder));
        STILL_THATCH = Services.PLATFORM.register(BuiltInRegistries.FLUID, "thatch", () -> Services.PLATFORM.createThatchStillFluid(referenceHolder));
        THATCH_BLOCK = Services.PLATFORM.register(BuiltInRegistries.BLOCK, "thatch", () -> Services.PLATFORM.createThatchFluidBlock(STILL_THATCH, thatchProperties));
        DUMMY_ENTITY_TYPE = Services.PLATFORM.register(BuiltInRegistries.ENTITY_TYPE, "dummy_entity", () -> EntityType.Builder.of(Services.PLATFORM::createDummyEntity, (MobCategory)MobCategory.MISC).clientTrackingRange(256).updateInterval(20).sized(1.0E-4f, 1.0E-4f).build("decorative_blocks:dummy"));
    }
}

