/*
 * Decompiled with CFR 0.152.
 */
package org.berezka.berezka_api;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.berezka.berezka_api.BerezkaStructures;
import org.berezka.berezka_api.berezka_api_main;
import org.berezka.berezka_api.structures.BerezkaStructureExtra;
import org.berezka.berezka_api.structures.BerezkaStructurePlacements;
import org.slf4j.Logger;
import org.spongepowered.asm.launch.MixinBootstrap;
import org.spongepowered.asm.mixin.Mixins;

@Mod(value="berezka_api")
public class Berezka_api {
    public static final String MODID = "berezka_api";
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final berezka_api_main API_INSTANCE = new berezka_api_main();
    public static boolean debug_mode = true;
    public static boolean dev_mode = false;
    public static boolean loadFolderData = false;
    public static String resourcePackName = "Berezka API data";
    public static String resourcePackID = "berezka_api_data";
    public static final String discordUrl = "https://discord.gg/uAhSWWyqy3";
    public static boolean reducedLoot = false;
    public static boolean filesPluginsFolderExist = false;
    public static String language;
    public static long MAX_AGE;

    public static berezka_api_main getAPI() {
        return API_INSTANCE;
    }

    public Berezka_api() {
        LOGGER.info("[Berezka API] Berezka is loading...");
        FMLJavaModLoadingContext context = FMLJavaModLoadingContext.get();
        IEventBus modEventBus = context.getModEventBus();
        BerezkaStructures.DEFERRED_REGISTRY_STRUCTURE.register(modEventBus);
        BerezkaStructurePlacements.DEFERRED_REGISTRY_STRUCTURE_PLACEMENT_TYPE.register(modEventBus);
        MixinBootstrap.init();
        Mixins.addConfiguration((String)"berezka_api.mixins.json");
        if (FMLEnvironment.dist == Dist.CLIENT) {
            if (debug_mode) {
                LOGGER.info("[Berezka API] loading on client...");
            }
            language = Minecraft.m_91087_().f_91066_.f_92075_;
        }
        filesPluginsFolderExist = berezka_api_main.doFilePluginsExist();
        LinkedHashMap<String, List<Object>> configParams = new LinkedHashMap<String, List<Object>>();
        configParams.put("DebugMode", Arrays.asList(Boolean.class, "Just debug mode", false, null, null));
        configParams.put("DevMode", Arrays.asList(Boolean.class, "Dev mode adds some commands, must be turned off for release versions of modpacks.", false, null, null));
        configParams.put("DefaultDoExtraChecksValue", Arrays.asList(Boolean.class, "Default value of doExtraChecks (if value isnt provided)", true, null, null));
        configParams.put("UseFolderPluginSystem", Arrays.asList(Boolean.class, "Creates berezka_plugins folder and loads data from it.", false, null, null));
        configParams.put("FolderPluginSystemList", Arrays.asList(List.class, "Defines loot tables to replace: modid:path:target.json (path from loot_tables folder to target, target - name of loot table, required file must be in berezka_plugins/modid/target.json, example: berezka_api:chests/:berezkahousesmall_0.json)", List.of(), null, null));
        configParams.put("SpawnLessLoot", Arrays.asList(Boolean.class, "Spawns less loot.", false, null, null));
        berezka_api_main.createConfig(MODID, "BerezkaAPI", context, configParams);
        MinecraftForge.EVENT_BUS.register((Object)this);
        context.getModEventBus().addListener(this::onConfigLoad);
    }

    public void onConfigLoad(ModConfigEvent.Loading event) {
        if (event.getConfig().getModId().equals(MODID)) {
            berezka_api_main.defaultDoExtraChecksValue = (Boolean)berezka_api_main.getValue("berezka_api:DefaultDoExtraChecksValue");
            loadFolderData = (Boolean)berezka_api_main.getValue("berezka_api:UseFolderPluginSystem");
            debug_mode = (Boolean)berezka_api_main.getValue("berezka_api:DebugMode");
            dev_mode = (Boolean)berezka_api_main.getValue("berezka_api:DevMode");
            reducedLoot = (Boolean)berezka_api_main.getValue("berezka_api:SpawnLessLoot");
            if (debug_mode) {
                LOGGER.info("[Berezka API] debug mode is enabled.");
            }
            if (loadFolderData) {
                berezka_api_main.loadNamespacesFromFromFolder();
                berezka_api_main.parseFolderPluginsList();
            }
        }
    }

    @SubscribeEvent
    public void onServerAboutToStart(ServerAboutToStartEvent event) {
        if (debug_mode && dev_mode) {
            LOGGER.info("[Berezka API] Server is about to start...");
        }
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        if (debug_mode && dev_mode) {
            LOGGER.info("[Berezka API] Server is starting...");
        }
    }

    @SubscribeEvent
    public void onServerStarted(ServerStartedEvent event) {
        ServerLevel overworld = event.getServer().m_129783_();
        if (debug_mode && dev_mode) {
            LOGGER.info("[Berezka API] World has been loaded: " + String.valueOf(overworld.m_46472_().m_135782_()));
        }
        if (dev_mode) {
            MinecraftServer server = event.getServer();
            Registry structureRegistry = server.m_206579_().m_175515_(Registries.f_256944_);
            ArrayList listOfStructures = new ArrayList();
            structureRegistry.m_6579_().forEach(entry -> listOfStructures.add(((ResourceKey)entry.getKey()).m_135782_().toString()));
            LOGGER.info("[Berezka API] Registered Structures List: {}", listOfStructures);
        }
        berezka_api_main.curWorld = overworld;
    }

    @SubscribeEvent
    public void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)levelAccessor;
            if (debug_mode && dev_mode) {
                LOGGER.info("[Berezka API] OnWorldLoad() event data[world:" + String.valueOf(world) + "]");
            }
            berezka_api_main.curWorld = world;
        }
    }

    @SubscribeEvent
    public void onWorldSave(LevelEvent.Save event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)levelAccessor;
            if (debug_mode && dev_mode) {
                LOGGER.info("[Berezka API] OnWorldSave() event data[world:" + String.valueOf(world) + "]");
            }
            BerezkaStructureExtra.clearCache();
        }
    }

    static {
        MAX_AGE = 30000L;
    }
}

