/*
 * Decompiled with CFR 0.152.
 */
package org.berezka.berezka_api;

import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.stream.events.Comment;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.berezka.berezka_api.Berezka_api;
import org.berezka.berezka_api.interfaces.ModStructure;
import org.berezka.berezka_api.structures.DeferredStructureSpawnInfo;
import org.slf4j.Logger;

public class berezka_api_main {
    public static boolean debugMode = Berezka_api.debug_mode;
    public static final Logger LOGGER = LogUtils.getLogger();
    private static ForgeConfigSpec CONFIG_SPEC;
    private static final ConcurrentHashMap<String, ForgeConfigSpec.ConfigValue<?>> configValues;
    public static final int APIVersion = 3;
    public static ConcurrentHashMap<ChunkPos, ConcurrentHashMap<String, DeferredStructureSpawnInfo>> deferredStructures;
    public static ConcurrentHashMap<String, List<String>> FolderRegisteredMods;
    public static ConcurrentHashMap<String, List<Object>> FolderPlugins;
    public static ConcurrentHashMap<String, List<Object>> CodeRegisteredMods;
    public static List<String> CodePluginRegisteredModsNames;
    public static List<String> FolderRegisteredModsNames;
    public static List<String> allRegisteredModsNames;
    public static List<Method> checksForSpawn;
    public static ServerLevel curWorld;
    public static List<String> customLootData;
    public static Map<String, String> customLootDataDic;
    public static boolean defaultDoExtraChecksValue;
    public static int defaultStructuresSpace;
    public static String curModIDForConfig;

    public static String getValueFromPool(Holder<StructureTemplatePool> poolHolder) {
        return poolHolder.m_203543_().map(key -> key.m_135782_()).orElse(new ResourceLocation("unknown", "unregistered_pool")).toString();
    }

    public static int getVersion() {
        return 3;
    }

    public static void createConfig(String modid, String configName, FMLJavaModLoadingContext context, Map<String, List<Object>> parameters) {
        LOGGER.info("[Berezka API] createConfig info: language is " + berezka_api_main.getLanguage() + ", modid:" + modid, (Object)(", curModIDForConfig: " + curModIDForConfig));
        curModIDForConfig = modid;
        ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] Config param list for " + modid + " is " + String.valueOf(parameters));
        }
        for (Map.Entry<String, List<Object>> entry : parameters.entrySet()) {
            String key = entry.getKey();
            List<Object> obj = entry.getValue();
            Class type = (Class)obj.get(0);
            ConfigParam param = new ConfigParam(type, (String)obj.get(1), obj.get(2), (Number)obj.get(3), (Number)obj.get(4));
            if (param.comment != null) {
                builder.comment(param.comment);
            }
            if (param.type == Boolean.class || param.type == Boolean.TYPE) {
                boolean defaultValue = param.defaultValue != null ? (Boolean)param.defaultValue : false;
                configValues.put(modid + ":" + key, (ForgeConfigSpec.ConfigValue<?>)builder.define(key, defaultValue));
                if (Berezka_api.debug_mode && Berezka_api.dev_mode) {
                    LOGGER.info("[Berezka API] saved " + modid + ":" + key + ", new list: " + String.valueOf(configValues));
                }
                if (configValues.containsKey(modid + ":" + key)) continue;
                LOGGER.error("[Berezka API] error: failed to save " + modid + ":" + key + " to config, trying again...");
                ForgeConfigSpec.BooleanValue spec = builder.define(key, defaultValue);
                configValues.put(modid + ":" + key, (ForgeConfigSpec.ConfigValue<?>)spec);
                continue;
            }
            if (param.type == Integer.class || param.type == Integer.TYPE) {
                int defaultValue;
                int min = param.min != null ? param.min.intValue() : Integer.MIN_VALUE;
                int max = param.max != null ? param.max.intValue() : Integer.MAX_VALUE;
                int n = defaultValue = param.defaultValue != null ? (Integer)param.defaultValue : 0;
                if (Berezka_api.debug_mode && Berezka_api.dev_mode) {
                    LOGGER.info("[Berezka API] saved " + modid + ":" + key);
                }
                configValues.put(modid + ":" + key, (ForgeConfigSpec.ConfigValue<?>)builder.defineInRange(key, defaultValue, min, max));
                continue;
            }
            if (param.type == Float.class || param.type == Float.TYPE) {
                float defaultValue;
                float min = param.min != null ? param.min.floatValue() : -3.4028235E38f;
                float max = param.max != null ? param.max.floatValue() : Float.MAX_VALUE;
                float f = defaultValue = param.defaultValue != null ? ((Float)param.defaultValue).floatValue() : 0.0f;
                if (Berezka_api.debug_mode && Berezka_api.dev_mode) {
                    LOGGER.info("[Berezka API] saved " + modid + ":" + key + ", default value:" + defaultValue);
                }
                configValues.put(modid + ":" + key, builder.define(key, (Object)Float.valueOf(defaultValue)));
                continue;
            }
            if (param.type == String.class) {
                String defaultValue;
                String string = defaultValue = param.defaultValue != null ? (String)param.defaultValue : "";
                if (Berezka_api.debug_mode && Berezka_api.dev_mode) {
                    LOGGER.info("[Berezka API] saved " + modid + ":" + key);
                }
                configValues.put(modid + ":" + key, builder.define(key, (Object)defaultValue));
                continue;
            }
            if (param.type == List.class) {
                List defaultValue;
                List list = defaultValue = param.defaultValue != null ? (List)param.defaultValue : List.of();
                if (Berezka_api.debug_mode && Berezka_api.dev_mode) {
                    LOGGER.info("[Berezka API] saved " + modid + ":" + key);
                }
                configValues.put(modid + ":" + key, builder.defineList(key, defaultValue, o -> o instanceof String));
                continue;
            }
            if (param.type == Comment.class && param.comment != null) {
                if (!Berezka_api.debug_mode || !Berezka_api.dev_mode) continue;
                LOGGER.info("[Berezka API] added comment " + param.comment + " to config " + configName + ".toml");
                continue;
            }
            throw new IllegalArgumentException("[Berezka API] Unsupported config type: " + param.type.getSimpleName());
        }
        CONFIG_SPEC = builder.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CONFIG_SPEC, configName + ".toml");
        curModIDForConfig = "";
        LOGGER.info("[Berezka API] Config for {} successfully registered!", (Object)modid);
        if (Berezka_api.debug_mode) {
            if (Berezka_api.dev_mode) {
                LOGGER.info("[Berezka API] Config spec: {}", (Object)CONFIG_SPEC);
            }
            LOGGER.info("[Berezka API] Config file path: {}\\config\\{}.toml", (Object)FMLPaths.GAMEDIR.get(), (Object)configName);
        }
    }

    public static void registerMod(String _modid, String mainClassName) {
        LOGGER.info("[Berezka API] register mod: " + _modid + " class: " + mainClassName);
        try {
            Class<?> clazz = Class.forName(mainClassName);
            HashMap<String, Method> methods = new HashMap<String, Method>();
            List resources = (List)clazz.getMethod("getResources", new Class[0]).invoke((Object)_modid, new Object[0]);
            methods.put("listResource", clazz.getMethod("isResourceListened", String.class));
            methods.put("handleResource", clazz.getMethod("handleResource", String.class));
            methods.put("getJson", clazz.getMethod("getJson", String.class));
            if (Berezka_api.debug_mode && Berezka_api.dev_mode) {
                LOGGER.info("[Berezka API] methods: " + String.valueOf(methods));
            }
            List<Object> _modData = Arrays.asList(clazz, methods, resources);
            if (Berezka_api.debug_mode && Berezka_api.dev_mode) {
                LOGGER.info("[Berezka API] mod data: " + String.valueOf(_modData));
            }
            CodeRegisteredMods.put(_modid, _modData);
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] Register: " + _modid);
            }
            CodePluginRegisteredModsNames.add(_modid);
            if (!allRegisteredModsNames.contains(_modid)) {
                allRegisteredModsNames.add(_modid);
            }
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] Registered mods: " + String.valueOf(CodePluginRegisteredModsNames));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("[Berezka API] Error 272: " + String.valueOf(e));
        }
    }

    public static void registerMod(String _modid, String mainClassName, int APIVersion) {
        LOGGER.info("[Berezka API] register mod: " + _modid + " class: " + mainClassName);
        try {
            Class<?> clazz = Class.forName(mainClassName);
            HashMap<String, Method> methods = new HashMap<String, Method>();
            List resources = (List)clazz.getMethod("getResources", new Class[0]).invoke((Object)_modid, new Object[0]);
            methods.put("listResource", clazz.getMethod("isResourceListened", String.class));
            methods.put("handleResource", clazz.getMethod("handleResource", String.class));
            methods.put("getJson", clazz.getMethod("getJson", String.class));
            if (APIVersion >= 3) {
                methods.put("onStructureSpawn", clazz.getMethod("onStructureSpawn", String.class, Structure.GenerationContext.class));
                methods.put("customSpawn", clazz.getMethod("customSpawn", Structure.GenerationContext.class, BlockPos.class, String.class));
                methods.put("getJigsaw", clazz.getMethod("getJigsawBlocksForTemplate", String.class, BlockPos.class));
            }
            if (Berezka_api.debug_mode && Berezka_api.dev_mode) {
                LOGGER.info("[Berezka API] methods: " + String.valueOf(methods));
            }
            List<Object> _modData = Arrays.asList(clazz, methods, resources);
            if (Berezka_api.debug_mode && Berezka_api.dev_mode) {
                LOGGER.info("[Berezka API] mod data: " + String.valueOf(_modData));
            }
            CodeRegisteredMods.put(_modid, _modData);
            if (Berezka_api.debug_mode && Berezka_api.dev_mode) {
                LOGGER.info("[Berezka API] Register: " + _modid);
            }
            CodePluginRegisteredModsNames.add(_modid);
            if (!allRegisteredModsNames.contains(_modid)) {
                allRegisteredModsNames.add(_modid);
            }
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] Registered mods: " + String.valueOf(CodePluginRegisteredModsNames));
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("[Berezka API] Error (error-227): " + String.valueOf(e));
        }
    }

    public static void registerMod(String _modid, ModStructure mainClass, int APIVersion) {
        LOGGER.info("[Berezka API] register mod: " + _modid + " class: " + ModStructure.class.getName());
        try {
            Class<?> clazz = mainClass.getClass();
            HashMap<String, Method> methods = new HashMap<String, Method>();
            List resources = (List)clazz.getMethod("getResources", new Class[0]).invoke((Object)_modid, new Object[0]);
            methods.put("listResource", clazz.getMethod("isResourceListened", String.class));
            methods.put("handleResource", clazz.getMethod("handleResource", String.class));
            methods.put("getJson", clazz.getMethod("getJson", String.class));
            if (APIVersion >= 3) {
                methods.put("onStructureSpawn", clazz.getMethod("onStructureSpawn", String.class, Structure.GenerationContext.class));
                methods.put("customSpawn", clazz.getMethod("customSpawn", Structure.GenerationContext.class, BlockPos.class, String.class));
                methods.put("getJigsaw", clazz.getMethod("getJigsawBlocksForTemplate", String.class, BlockPos.class));
            }
            if (Berezka_api.debug_mode && Berezka_api.dev_mode) {
                LOGGER.info("[Berezka API] methods: " + String.valueOf(methods));
            }
            List<Object> _modData = Arrays.asList(clazz, methods, resources);
            if (Berezka_api.debug_mode && Berezka_api.dev_mode) {
                LOGGER.info("[Berezka API] mod data: " + String.valueOf(_modData));
            }
            CodeRegisteredMods.put(_modid, _modData);
            if (Berezka_api.debug_mode && Berezka_api.dev_mode) {
                LOGGER.info("[Berezka API] Register: " + _modid);
            }
            CodePluginRegisteredModsNames.add(_modid);
            if (!allRegisteredModsNames.contains(_modid)) {
                allRegisteredModsNames.add(_modid);
            }
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] Registered mods: " + String.valueOf(CodePluginRegisteredModsNames));
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("[Berezka API] Error (error-384): " + String.valueOf(e));
        }
    }

    public static <T> T getValue(String key) {
        boolean exist = configValues.containsKey(key);
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] getValue: key: " + key + " is exist?: " + exist + ", list: " + String.valueOf(configValues));
        }
        if (!exist) {
            throw new IllegalArgumentException("[Berezka API] Unknown config key: " + key + " (try to restart game). (error-338)");
        }
        return (T)configValues.get(key).get();
    }

    public static List<String> loadLootDataFiles() {
        return customLootData;
    }

    public static void addCustomLootData(String name, String jsonData) {
        customLootData.add(name);
        customLootDataDic.put(name, jsonData);
    }

    public static void runCommand(Level world, Player player, String command) {
        if (world.f_46443_) {
            return;
        }
        MinecraftServer server = berezka_api_main.getCurWorld().m_7654_();
        if (server != null) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] info: runCommand called on server");
            }
            CommandSourceStack source = server.m_129893_().m_81325_(4).m_81324_();
            server.m_129892_().m_230957_(source, command);
        } else if (Berezka_api.debug_mode) {
            LOGGER.warn("[Berezka API] info: runCommand called on client");
        }
    }

    public static void runCommand(Level world, String command) {
        if (world.f_46443_) {
            return;
        }
        MinecraftServer server = berezka_api_main.getCurWorld().m_7654_();
        if (server != null) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] info: runCommand called on server");
            }
            CommandSourceStack source = server.m_129893_().m_81325_(4).m_81324_();
            server.m_129892_().m_230957_(source, command);
        } else if (Berezka_api.debug_mode) {
            LOGGER.warn("[Berezka API] info: runCommand called on client");
        }
    }

    public static Boolean doFilePluginsExist() {
        String fullpath = FMLPaths.GAMEDIR.get().toString() + File.separator + "berezka_plugins" + File.separator + "berezka_api";
        File directory = new File(fullpath);
        File[] files = directory.listFiles();
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] info: loading old plugins from folder: " + fullpath + " directory exist: " + (files != null));
        }
        return files != null;
    }

    public static List<String> loadLootDataFiles(String directoryPath) {
        File[] files;
        ArrayList<String> lootDataFiles = new ArrayList<String>();
        File directory = new File(directoryPath);
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles((dir, name) -> name.endsWith(".json"))) != null) {
            for (File file : files) {
                lootDataFiles.add(file.getName());
            }
        }
        return lootDataFiles;
    }

    public static List<String> loadLootDataFiles(String directoryPath, Boolean useOnlyNames) {
        File[] files;
        ArrayList<String> lootDataFiles = new ArrayList<String>();
        File directory = new File(directoryPath);
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles((dir, name) -> name.endsWith(".json"))) != null) {
            for (File file : files) {
                if (useOnlyNames.booleanValue()) {
                    lootDataFiles.add(file.getName().replace(".json", ""));
                    continue;
                }
                lootDataFiles.add(file.getName());
            }
        }
        return lootDataFiles;
    }

    public static Boolean isDebugMode() {
        return Berezka_api.debug_mode;
    }

    public static void loadNamespacesFromFromFolder() {
        String fullpath = FMLPaths.GAMEDIR.get().toString() + File.separator + "berezka_plugins";
        File directory = new File(fullpath);
        Object[] files = directory.listFiles();
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] loading berezka plugins from folder. Data: directory: " + String.valueOf(directory) + " files: " + Arrays.toString(files));
        }
        if (files != null) {
            for (Object file : files) {
                String namespace = ((File)file).getName();
                List<String> jsons = berezka_api_main.loadLootDataFiles(String.valueOf(directory) + File.separator + namespace, true);
                FolderRegisteredModsNames.add(namespace);
                FolderRegisteredMods.put(namespace, jsons);
                if (!allRegisteredModsNames.contains(namespace)) {
                    allRegisteredModsNames.add(namespace);
                }
                if (!Berezka_api.debug_mode) continue;
                LOGGER.info("[Berezka API] FolderRegisteredMods: " + String.valueOf(FolderRegisteredMods));
            }
        }
    }

    public static void parseFolderPluginsList() {
        List configValue = (List)berezka_api_main.getValue("berezka_api:FolderPluginSystemList");
        LOGGER.info("[Berezka API] parsing config with FolderPluginsList: " + String.valueOf(configValue));
        for (String line : configValue) {
            LOGGER.info("[Berezka API] parsing config with line: " + line);
            String[] parts = line.split(":");
            LOGGER.info("[Berezka API] parts of parsing config with line: " + String.valueOf(parts));
            String modid = parts[0];
            String path = parts[1];
            String file = parts[2].replace(".json", "");
            List<Object> list = FolderPlugins.get(modid);
            List<CallSite> body = List.of(file, path + file + ".json");
            LOGGER.info("[Berezka API] list of parsing config with line: " + String.valueOf(list) + " (empty?: " + (list == null) + ") trying to add: " + String.valueOf(body));
            if (list == null) {
                list = new ArrayList<Object>();
            }
            list.add(body);
            LOGGER.info("[Berezka API] new list of parsing config with line: " + String.valueOf(list));
            FolderPlugins.put(modid, list);
            LOGGER.info("[Berezka API] End of parsing config line: " + line + " new FolderPlugins: " + String.valueOf(FolderPlugins));
        }
    }

    public static String getFileFromFolderPlugins(String fileName, String namespace) {
        if (Berezka_api.debug_mode) {
            LOGGER.info("getFileFromFolderPlugins (0/3) is called with file name: " + fileName + " for: " + namespace);
        }
        String fullpath = FMLPaths.GAMEDIR.get().toString() + File.separator + "berezka_plugins" + File.separator + namespace + File.separator + fileName + ".json";
        String result = "";
        if (Berezka_api.debug_mode) {
            LOGGER.info("getFileFromFolderPlugins (1/3) from: " + fullpath);
        }
        try {
            result = berezka_api_main.readFileAsString(fullpath);
            if (Berezka_api.debug_mode) {
                LOGGER.info("getFileFromFolderPlugins (2/3) from: " + fullpath + " readFileAsString() result: " + result);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("getFileFromFolderPlugins (3/3) from: " + fullpath + " returning result: " + result);
        }
        return result;
    }

    public static boolean checkChunk(ChunkPos pos) {
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] checkChunk at: " + String.valueOf(pos));
        }
        if (!checksForSpawn.isEmpty()) {
            for (Method check : checksForSpawn) {
                try {
                    boolean result = (Boolean)check.invoke((Object)Berezka_api.getAPI(), pos);
                    if (Berezka_api.debug_mode) {
                        LOGGER.info("[Berezka API] checkChunk with method: " + String.valueOf(check) + " result: " + result);
                    }
                    if (result) continue;
                    return false;
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (Berezka_api.debug_mode && Berezka_api.dev_mode) {
            LOGGER.info("[Berezka API] checkChunk returns true.");
        }
        return true;
    }

    public static void AddCustomChunkCheck(String _modid, String mainClassName, String methodName) {
        LOGGER.info("[Berezka API] AddCustomChunkCheck() from mod: " + _modid + " in class: " + mainClassName);
        try {
            Class<?> clazz = Class.forName(mainClassName);
            checksForSpawn.add(clazz.getMethod(methodName, ChunkPos.class));
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new RuntimeException("[Berezka API] Error: %s while trying to add custom chunk check.".formatted(e));
        }
    }

    public static Method getValueMethod(String name) {
        try {
            return Berezka_api.getAPI().getClass().getMethod("getValue", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public static ServerLevel getCurWorld() {
        return curWorld;
    }

    public static String getText(String value) {
        return value;
    }

    public static String getLanguage() {
        return Berezka_api.language;
    }

    public static int generateStructureSalt(int modID, int structureID) {
        return modID * 10000 + structureID;
    }

    public static String readFileAsString(String filePath) throws IOException {
        return Files.readString(Paths.get(filePath, new String[0]));
    }

    public static boolean isLootReduced() {
        return Berezka_api.reducedLoot;
    }

    public static void placeTemplate(ServerLevel world, BlockPos spawnPos, ChunkPos chunk, String name, Rotation rotation) {
        DeferredStructureSpawnInfo data = new DeferredStructureSpawnInfo(spawnPos, rotation, name);
        deferredStructures.computeIfAbsent(chunk, k -> new ConcurrentHashMap()).put(name, data);
    }

    public static void placeJigsawTemplate(LevelAccessor world, StructureTemplate structure, BlockPos spawnPos, boolean checkCorners, StructurePlaceSettings settings) {
        if (world.m_5776_()) {
            return;
        }
        ServerLevel serverWorld = (ServerLevel)world;
        Vec3i vec = structure.m_163801_();
        berezka_api_main.activateAllJigsawsInArea(serverWorld, spawnPos, new BlockPos(vec.m_123341_(), vec.m_123342_(), vec.m_123343_()));
    }

    private static void activateAllJigsawsInArea(ServerLevel world, BlockPos center, BlockPos structureSize) {
        int searchRadius = Math.max(structureSize.m_123341_(), structureSize.m_123343_()) + 10;
        int centerX = center.m_123341_();
        int centerY = center.m_123342_();
        int centerZ = center.m_123343_();
        for (int x = centerX - searchRadius; x <= centerX + searchRadius; ++x) {
            for (int y = centerY - 10; y <= centerY + structureSize.m_123342_() + 10; ++y) {
                for (int z = centerZ - searchRadius; z <= centerZ + searchRadius; ++z) {
                    BlockPos checkPos = new BlockPos(x, y, z);
                    BlockState blockState = world.m_8055_(checkPos);
                    if (blockState.m_60734_() != Blocks.f_50678_) continue;
                    LOGGER.info("[Berezka API] activating jigsaw at {}", (Object)checkPos);
                    berezka_api_main.activateJigsawBlock(world, checkPos);
                }
            }
        }
    }

    public static void activateJigsawBlock(ServerLevel world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof JigsawBlockEntity) {
            JigsawBlockEntity jigsaw = (JigsawBlockEntity)blockEntity;
            try {
                LOGGER.info("[Berezka API] spawning jigsaw at {}, with joint {}", (Object)berezka_api_main.readebleCoordinates(pos), (Object)jigsaw.m_59446_());
                jigsaw.m_59420_(world, 7, false);
            }
            catch (Exception e) {
                LOGGER.error("[Berezka API] error generating jigsaw at " + berezka_api_main.readebleCoordinates(pos) + ": " + e.getMessage());
            }
        } else {
            LOGGER.warn("[Berezka API] there is no jigsaw at " + berezka_api_main.readebleCoordinates(pos));
        }
    }

    public static BlockPos getCenterOfBoundingBox(BoundingBox box) {
        int centerX = (box.m_162395_() + box.m_162399_()) / 2;
        int centerY = (box.m_162396_() + box.m_162400_()) / 2;
        int centerZ = (box.m_162398_() + box.m_162401_()) / 2;
        return new BlockPos(centerX, centerY, centerZ);
    }

    public static String readebleCoordinates(BlockPos pos) {
        return "[%s 100 %s]".formatted(pos.m_123341_(), pos.m_123343_());
    }

    static {
        configValues = new ConcurrentHashMap();
        deferredStructures = new ConcurrentHashMap();
        FolderRegisteredMods = new ConcurrentHashMap();
        FolderPlugins = new ConcurrentHashMap();
        CodeRegisteredMods = new ConcurrentHashMap();
        CodePluginRegisteredModsNames = new ArrayList<String>(List.of("berezka_api"));
        FolderRegisteredModsNames = new ArrayList<String>(List.of("berezka_api"));
        allRegisteredModsNames = new ArrayList<String>(List.of("berezka_api"));
        checksForSpawn = new ArrayList<Method>(List.of());
        curWorld = null;
        customLootData = new ArrayList<String>();
        customLootDataDic = new HashMap<String, String>();
        defaultDoExtraChecksValue = true;
        defaultStructuresSpace = 100;
        curModIDForConfig = "";
    }

    public static class ConfigParam {
        public final Class<?> type;
        public final String comment;
        public final Object defaultValue;
        public final Number min;
        public final Number max;

        public ConfigParam(Class<?> type, String comment, Object defaultValue, Number min, Number max) {
            this.type = type;
            this.comment = comment;
            this.defaultValue = defaultValue;
            this.min = min;
            this.max = max;
        }
    }
}

