/*
 * Decompiled with CFR 0.152.
 */
package org.berezka.berezka_api.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.berezka.berezka_api.BerezkaStructures;
import org.berezka.berezka_api.Berezka_api;
import org.berezka.berezka_api.berezka_api_main;
import org.berezka.berezka_api.structures.BerezkaStructureExtra;
import org.berezka.berezka_api.structures.DeferredStructureSpawnInfo;
import org.slf4j.Logger;

public class BerezkaDeferredStructure
extends Structure {
    public static ConcurrentHashMap StructuresIDList = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Rotation> StructuresRotations = new ConcurrentHashMap();
    public static ConcurrentHashMap<ChunkPos, String> TERRAIN_CACHE = new ConcurrentHashMap();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<BerezkaDeferredStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BerezkaDeferredStructure.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.STRING.fieldOf("name").forGetter(structure -> structure.structureName), (App)Codec.STRING.optionalFieldOf("spawn_event").forGetter(structure -> structure.spawnEvent), (App)Codec.intRange((int)1, (int)1000).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)0, (int)180).optionalFieldOf("structure_rotation").forGetter(structure -> structure.structrure_rotation), (App)Codec.BOOL.optionalFieldOf("do_extra_checks").forGetter(structure -> structure.doExtraChecks), (App)Codec.BOOL.optionalFieldOf("only_flat_terrain").forGetter(structure -> structure.onlyFlatTerrain), (App)Codec.BOOL.optionalFieldOf("check_for_structures").forGetter(structure -> structure.checkForStructures), (App)Codec.BOOL.optionalFieldOf("allow_custom_checks").forGetter(structure -> structure.allowCustomChecks), (App)Codec.BOOL.optionalFieldOf("big_structure").forGetter(structure -> structure.bigStructure)).apply((Applicative)instance, BerezkaDeferredStructure::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final Optional<Integer> structrure_rotation;
    private final Optional<Boolean> doExtraChecks;
    private final Optional<Boolean> allowCustomChecks;
    private final Optional<Boolean> checkForStructures;
    private final Optional<Boolean> onlyFlatTerrain;
    private final String structureName;
    private final Optional<String> spawnEvent;
    private final Optional<Boolean> bigStructure;

    public BerezkaDeferredStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, String name, Optional<String> spawnEvent, int maxDistanceFromCenter, Optional<Integer> structrure_rotation, Optional<Boolean> doExtraChecks, Optional<Boolean> checkForStructures, Optional<Boolean> onlyFlatTerrain, Optional<Boolean> allowCustomChecks, Optional<Boolean> bigStructure) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.structrure_rotation = structrure_rotation;
        this.doExtraChecks = doExtraChecks;
        this.allowCustomChecks = allowCustomChecks;
        this.checkForStructures = checkForStructures;
        this.onlyFlatTerrain = onlyFlatTerrain;
        this.structureName = name;
        this.spawnEvent = spawnEvent;
        this.bigStructure = bigStructure;
    }

    private static DeferredStructureSpawnInfo extraSpawningChecks(Structure.GenerationContext context, BerezkaDeferredStructure myData) {
        ChunkPos chunkPos = context.f_226628_();
        if (berezka_api_main.deferredStructures.containsKey(chunkPos) && berezka_api_main.deferredStructures.get(chunkPos).containsKey(myData.structureName)) {
            DeferredStructureSpawnInfo data = berezka_api_main.deferredStructures.get(chunkPos).get(myData.structureName);
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Deferred Structures] extraSpawningChecks for deferred structure {} at {} - {}, chunkIsInList {}, same {}", new Object[]{berezka_api_main.getValueFromPool(myData.startPool), chunkPos, data.spawnPos, true, true});
            }
            return data;
        }
        LOGGER.info("[Deferred Structures] extraSpawningChecks for deferred structure {} at {} - {}, chunkIsInList {}, same {}", new Object[]{berezka_api_main.getValueFromPool(myData.startPool), chunkPos, berezka_api_main.readebleCoordinates(chunkPos.m_45615_()), berezka_api_main.deferredStructures.containsKey(chunkPos), false});
        LOGGER.info("[Deferred Structures] extraSpawningChecks for deferred structure {} at {} keys list: {}", new Object[]{berezka_api_main.getValueFromPool(myData.startPool), chunkPos, berezka_api_main.deferredStructures.keys()});
        return null;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        Optional<Structure.GenerationStub> result;
        ServerLevel world;
        DeferredStructureSpawnInfo data = BerezkaDeferredStructure.extraSpawningChecks(context, this);
        if (data == null) {
            return Optional.empty();
        }
        ChunkPos chunkPos = context.f_226628_();
        String structureId = berezka_api_main.getValueFromPool(this.startPool);
        if (!StructuresIDList.contains(berezka_api_main.getValueFromPool(this.startPool))) {
            StructuresIDList.put(berezka_api_main.getValueFromPool(this.startPool), StructuresIDList.size() + 1);
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] adding new structure {} to StructuresIDList, new list: {}", (Object)berezka_api_main.getValueFromPool(this.startPool), (Object)StructuresIDList);
            }
        }
        boolean manual = BerezkaDeferredStructure.isManualPlacement();
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] findGenerationPoint called. (Manual: {})", (Object)manual);
        }
        if ((world = berezka_api_main.getCurWorld()) == null) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] findGenerationPoint warn: world is null, returning Optional.empty().");
            }
            return Optional.empty();
        }
        BlockPos centerPos = chunkPos.m_151394_(world.m_5736_());
        if (!world.m_46739_(centerPos)) {
            LOGGER.info("[Berezka API] findGenerationPoint centerPos at {} is out of World bounds.", (Object)centerPos);
            return Optional.empty();
        }
        if (!StructuresRotations.containsKey(structureId)) {
            StructuresRotations.put(structureId, data.rotation);
        }
        if (manual) {
            int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
            BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
            Optional structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] Spawning deferred structure with command and without any checks.");
            }
            return structurePiecesGenerator;
        }
        Optional structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)data.spawnPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
        if (structurePiecesGenerator.isEmpty()) {
            return Optional.empty();
        }
        Structure.GenerationStub stub = (Structure.GenerationStub)structurePiecesGenerator.get();
        BlockPos genPos = stub.f_226669_();
        Consumer originalConsumer = (Consumer)stub.f_226670_().left().get();
        Optional<Structure.GenerationStub> optional = result = this.bigStructure.isPresent() && this.bigStructure.get() != false ? BerezkaStructureExtra.getBigGenerationStub(context, genPos, originalConsumer, structureId, this.startPool, this.spawnEvent) : this.getGenerationStub(context, genPos, originalConsumer, structureId, data);
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Deferred Structures] Spawning deferred structure {} at {} {} ({})", new Object[]{structureId, data.spawnPos, chunkPos, stub.f_226669_()});
        }
        return result;
    }

    private Optional<Structure.GenerationStub> getGenerationStub(Structure.GenerationContext context, BlockPos genPos, Consumer<StructurePiecesBuilder> originalConsumer, String structureId, DeferredStructureSpawnInfo info) {
        Structure.GenerationStub newStub = new Structure.GenerationStub(genPos, builder -> {
            final ArrayList recordedPieces = new ArrayList();
            StructureTemplateManager manager = context.f_226625_();
            StructurePlaceSettings settings = new StructurePlaceSettings();
            BlockPos pos1 = genPos.m_7918_(0, -1, 0);
            StructureTemplatePool pool1 = (StructureTemplatePool)context.f_226621_().m_175515_(Registries.f_256948_).m_7745_(new ResourceLocation("the_lost_city", "city_megapolis_street"));
            StructurePoolElement structurepoolelement1 = pool1.m_227355_((RandomSource)context.f_226626_());
            PoolElementStructurePiece poolelementstructurepiece = new PoolElementStructurePiece(manager, structurepoolelement1, pos1, structurepoolelement1.m_210540_(), info.rotation, structurepoolelement1.m_214015_(manager, pos1, info.rotation));
            BlockPos pos2 = info.spawnPos.m_7918_(0, genPos.m_123342_() - 1, 125);
            StructureTemplatePool pool2 = (StructureTemplatePool)context.f_226621_().m_175515_(Registries.f_256948_).m_7745_(new ResourceLocation("the_lost_city", "city_megapolis_street2"));
            StructurePoolElement structurepoolelement2 = pool2.m_227355_((RandomSource)context.f_226626_());
            PoolElementStructurePiece poolelementstructurepiece2 = new PoolElementStructurePiece(manager, structurepoolelement2, pos2, structurepoolelement2.m_210540_(), info.rotation, structurepoolelement2.m_214015_(manager, pos2, info.rotation));
            BlockPos pos3 = info.spawnPos.m_7918_(125, genPos.m_123342_() - 1, 125);
            StructureTemplatePool pool3 = (StructureTemplatePool)context.f_226621_().m_175515_(Registries.f_256948_).m_7745_(new ResourceLocation("the_lost_city", "city_megapolis_street3"));
            StructurePoolElement structurepoolelement3 = pool3.m_227355_((RandomSource)context.f_226626_());
            PoolElementStructurePiece poolelementstructurepiece3 = new PoolElementStructurePiece(manager, structurepoolelement3, pos3, structurepoolelement3.m_210540_(), info.rotation, structurepoolelement3.m_214015_(manager, pos3, info.rotation));
            BlockPos pos4 = info.spawnPos.m_7918_(125, genPos.m_123342_() - 1, 0);
            StructureTemplatePool pool4 = (StructureTemplatePool)context.f_226621_().m_175515_(Registries.f_256948_).m_7745_(new ResourceLocation("the_lost_city", "city_megapolis_street4"));
            StructurePoolElement structurepoolelement4 = pool4.m_227355_((RandomSource)context.f_226626_());
            PoolElementStructurePiece poolelementstructurepiece4 = new PoolElementStructurePiece(manager, structurepoolelement4, pos4, structurepoolelement4.m_210540_(), info.rotation, structurepoolelement4.m_214015_(manager, pos4, info.rotation));
            StructurePieceType type = StructurePieceType.f_210125_;
            StructurePiecesBuilder proxyBuilder = new StructurePiecesBuilder((StructurePiecesBuilder)builder, poolelementstructurepiece, poolelementstructurepiece2, poolelementstructurepiece3, poolelementstructurepiece4, genPos, pos2, pos3, pos4){
                final /* synthetic */ StructurePiecesBuilder val$builder;
                final /* synthetic */ PoolElementStructurePiece val$poolelementstructurepiece;
                final /* synthetic */ PoolElementStructurePiece val$poolelementstructurepiece2;
                final /* synthetic */ PoolElementStructurePiece val$poolelementstructurepiece3;
                final /* synthetic */ PoolElementStructurePiece val$poolelementstructurepiece4;
                final /* synthetic */ BlockPos val$genPos;
                final /* synthetic */ BlockPos val$pos2;
                final /* synthetic */ BlockPos val$pos3;
                final /* synthetic */ BlockPos val$pos4;
                {
                    this.val$builder = structurePiecesBuilder;
                    this.val$poolelementstructurepiece = poolElementStructurePiece;
                    this.val$poolelementstructurepiece2 = poolElementStructurePiece2;
                    this.val$poolelementstructurepiece3 = poolElementStructurePiece3;
                    this.val$poolelementstructurepiece4 = poolElementStructurePiece4;
                    this.val$genPos = blockPos;
                    this.val$pos2 = blockPos2;
                    this.val$pos3 = blockPos3;
                    this.val$pos4 = blockPos4;
                }

                public void m_142679_(StructurePiece piece) {
                    recordedPieces.add(piece);
                    this.val$builder.m_142679_(piece);
                    this.val$builder.m_142679_((StructurePiece)this.val$poolelementstructurepiece);
                    this.val$builder.m_142679_((StructurePiece)this.val$poolelementstructurepiece2);
                    this.val$builder.m_142679_((StructurePiece)this.val$poolelementstructurepiece3);
                    this.val$builder.m_142679_((StructurePiece)this.val$poolelementstructurepiece4);
                    LOGGER.info("[Deferred Structures] ChunkManager: spawning pieces at 1: {} 2: {} 3: {} 4: {} 5: {}", new Object[]{berezka_api_main.readebleCoordinates(piece.m_142171_()), berezka_api_main.readebleCoordinates(this.val$genPos), berezka_api_main.readebleCoordinates(this.val$pos2), berezka_api_main.readebleCoordinates(this.val$pos3), berezka_api_main.readebleCoordinates(this.val$pos4)});
                }
            };
            originalConsumer.accept(proxyBuilder);
            if (berezka_api_main.debugMode) {
                for (StructurePiece piece : recordedPieces) {
                    BoundingBox box = piece.m_73547_();
                    int minChunkX = box.m_162395_() >> 4;
                    int maxChunkX = box.m_162399_() >> 4;
                    int minChunkZ = box.m_162398_() >> 4;
                    int maxChunkZ = box.m_162401_() >> 4;
                    for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
                        for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                            ChunkPos chunkpos = new ChunkPos(cx, cz);
                            if (!berezka_api_main.getCurWorld().m_46749_(chunkpos.m_45615_())) {
                                LOGGER.error("[Deferred Structures] ChunkManager: chunk at {} {} is not loaded. (structure: {})", new Object[]{chunkpos, berezka_api_main.readebleCoordinates(chunkpos.m_45615_()), structureId});
                                continue;
                            }
                            LOGGER.info("[Deferred Structures] ChunkManager: chunk at {} {} is loaded. (structure: {})", new Object[]{chunkpos, berezka_api_main.readebleCoordinates(chunkpos.m_45615_()), structureId});
                        }
                    }
                }
            }
        });
        Optional<Structure.GenerationStub> result = Optional.of(newStub);
        LOGGER.info("[Deferred Structures] onStructureSpawn1() info:{} name:{} at:{}", new Object[]{this.spawnEvent.isPresent(), berezka_api_main.getValueFromPool(this.startPool), context.f_226628_()});
        if (this.spawnEvent.isPresent()) {
            String namespace = berezka_api_main.getValueFromPool(this.startPool).split(":")[0];
            LOGGER.info("[Deferred Structures] onStructureSpawn2() namespace: {}", (Object)namespace);
            if (berezka_api_main.CodeRegisteredMods.containsKey(namespace)) {
                LOGGER.info("[Deferred Structures] onStructureSpawn3()");
                List<Object> modData = berezka_api_main.CodeRegisteredMods.get(namespace);
                Map methods = (Map)modData.get(1);
                if (methods.containsKey("onStructureSpawn")) {
                    LOGGER.info("[Deferred Structures] onStructureSpawn4()");
                    try {
                        LOGGER.info("[Deferred Structures] onStructureSpawn5()");
                        ((Method)methods.get("onStructureSpawn")).invoke((Object)Berezka_api.getAPI(), this.spawnEvent.get(), context);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException("[Deferred Structures] error: " + String.valueOf(e));
                    }
                }
            }
        }
        return result;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)BerezkaStructures.BEREZKA_STRUCTURES_EXTRA.get();
    }

    public static boolean isManualPlacement() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().contains("PlaceCommand") && !element.getMethodName().contains("place")) continue;
            return true;
        }
        return false;
    }

    public static void clearCache() {
        ArrayList<ChunkPos> chunks = Collections.list(TERRAIN_CACHE.keys());
        for (ChunkPos chunk : chunks) {
            if (berezka_api_main.getCurWorld().m_46749_(chunk.m_45615_())) continue;
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] removing {} from cache.", (Object)chunk.m_45615_());
            }
            TERRAIN_CACHE.remove(chunk);
        }
        chunks.clear();
    }

    public static Boolean boxContainsStructures(BoundingBox box, String structureID) {
        int minChunkX = box.m_162395_() >> 4;
        int maxChunkX = box.m_162399_() >> 4;
        int minChunkZ = box.m_162398_() >> 4;
        int maxChunkZ = box.m_162401_() >> 4;
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                ChunkPos chunkpos = new ChunkPos(cx, cz);
                boolean contains = TERRAIN_CACHE.containsKey(chunkpos);
                boolean same = TERRAIN_CACHE.getOrDefault(chunkpos, "not found").equals(structureID);
                if (!contains || same) continue;
                return true;
            }
        }
        return false;
    }

    public static Rotation getRotationOfStructure(Structure.GenerationContext context, String id) {
        return StructuresRotations.getOrDefault(id, Rotation.m_221990_((RandomSource)context.f_226626_()));
    }
}

