/*
 * Decompiled with CFR 0.152.
 */
package org.berezka.berezka_api.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.berezka.berezka_api.BerezkaStructures;
import org.berezka.berezka_api.Berezka_api;
import org.berezka.berezka_api.berezka_api_main;
import org.berezka.berezka_api.data.StructureCacheEntry;
import org.berezka.berezka_api.events.onStructureSpawned;
import org.slf4j.Logger;

public class BerezkaStructureExtra
extends Structure {
    public static ConcurrentHashMap<String, Rotation> StructuresRotations = new ConcurrentHashMap();
    public static ConcurrentHashMap<ChunkPos, StructureCacheEntry> TERRAIN_CACHE = new ConcurrentHashMap();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<BerezkaStructureExtra> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BerezkaStructureExtra.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.STRING.optionalFieldOf("spawn_event").forGetter(structure -> structure.spawnEvent), (App)Codec.intRange((int)1, (int)1000).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)0, (int)180).optionalFieldOf("structure_rotation").forGetter(structure -> structure.structrure_rotation), (App)Codec.BOOL.optionalFieldOf("do_extra_checks").forGetter(structure -> structure.doExtraChecks), (App)Codec.BOOL.optionalFieldOf("only_flat_terrain").forGetter(structure -> structure.onlyFlatTerrain), (App)Codec.BOOL.optionalFieldOf("check_for_structures").forGetter(structure -> structure.checkForStructures), (App)Codec.BOOL.optionalFieldOf("allow_custom_checks").forGetter(structure -> structure.allowCustomChecks), (App)Codec.BOOL.optionalFieldOf("custom_spawn").forGetter(structure -> structure.customSpawn)).apply((Applicative)instance, BerezkaStructureExtra::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final Optional<Integer> structrure_rotation;
    private final Optional<Boolean> doExtraChecks;
    private final Optional<Boolean> allowCustomChecks;
    private final Optional<Boolean> checkForStructures;
    private final Optional<Boolean> onlyFlatTerrain;
    private final Optional<Boolean> customSpawn;
    private final Optional<String> spawnEvent;

    public BerezkaStructureExtra(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, Optional<String> spawnEvent, int maxDistanceFromCenter, Optional<Integer> structrure_rotation, Optional<Boolean> doExtraChecks, Optional<Boolean> checkForStructures, Optional<Boolean> onlyFlatTerrain, Optional<Boolean> allowCustomChecks, Optional<Boolean> customSpawn) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.structrure_rotation = structrure_rotation;
        this.doExtraChecks = doExtraChecks;
        this.allowCustomChecks = allowCustomChecks;
        this.checkForStructures = checkForStructures;
        this.onlyFlatTerrain = onlyFlatTerrain;
        this.customSpawn = customSpawn;
        this.spawnEvent = spawnEvent;
    }

    private static boolean extraSpawningChecks(Structure.GenerationContext context, BerezkaStructureExtra data, Heightmap.Types projectStartToHeightmap) {
        boolean heightCheck;
        ServerLevel world;
        ChunkPos chunkpos = context.f_226628_();
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] extraSpawningChecks called at {}.", (Object)chunkpos.m_45615_());
        }
        if ((world = berezka_api_main.getCurWorld()) == null) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] extraSpawningChecks warn: world is null, returning false.");
            }
            return false;
        }
        int occupiedYPos = context.f_226622_().m_223235_(chunkpos.m_45604_(), chunkpos.m_45605_(), projectStartToHeightmap, context.f_226629_(), context.f_226624_());
        NoiseColumn columnOfBlocks = context.f_226622_().m_214184_(chunkpos.m_151382_(0), chunkpos.m_151391_(0), context.f_226629_(), context.f_226624_());
        BlockState blockState = columnOfBlocks.m_183556_(occupiedYPos);
        boolean bl = heightCheck = occupiedYPos < 100;
        if (!heightCheck) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] extraSpawningChecks info: returning: false (heightCheck = false)");
            }
            return false;
        }
        boolean terrainCheck = BerezkaStructureExtra.isValidTerrainForSpawn(world, chunkpos, data);
        if (!terrainCheck) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] extraSpawningChecks info: returning: false (terrainCheck = false)");
            }
            return false;
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] checking {} for structures, chunk has any structures: {}.", (Object)chunkpos.m_45615_(), (Object)(TERRAIN_CACHE.containsKey(chunkpos) && !TERRAIN_CACHE.get(chunkpos).getValue().equals(berezka_api_main.getValueFromPool(data.startPool)) ? 1 : 0));
        }
        if (TERRAIN_CACHE.containsKey(chunkpos) && !TERRAIN_CACHE.get(chunkpos).getValue().equals(berezka_api_main.getValueFromPool(data.startPool))) {
            return false;
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] extraSpawningChecks info: returning: true");
        }
        return true;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        Optional<Structure.GenerationStub> result;
        Optional structurePiecesGenerator;
        ChunkPos chunkPos = context.f_226628_();
        String structureId = berezka_api_main.getValueFromPool(this.startPool);
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] CACHE: {}, current pos: {} {}, contains chunk: {}, value: {}", new Object[]{TERRAIN_CACHE, chunkPos, chunkPos.m_45615_(), TERRAIN_CACHE.containsKey(chunkPos), TERRAIN_CACHE.containsKey(chunkPos) ? TERRAIN_CACHE.get(chunkPos).getValue() : "not found"});
        }
        boolean manual = BerezkaStructureExtra.isManualPlacement();
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] findGenerationPoint called. (Manual: %s)".formatted(manual));
        }
        ServerLevel world = berezka_api_main.getCurWorld();
        int rotation = 0;
        Optional<Integer> optionalRotation = this.structrure_rotation;
        if (optionalRotation.isPresent()) {
            rotation = optionalRotation.get();
        }
        if (world == null) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] findGenerationPoint warn: world is null, returning Optional.empty().");
            }
            return Optional.empty();
        }
        BlockPos centerPos = chunkPos.m_151394_(world.m_5736_());
        if (!world.m_46739_(centerPos)) {
            LOGGER.info("[Berezka API] findGenerationPoint centerPos is out of World bounds.");
            return Optional.empty();
        }
        Rotation _rotation = Rotation.NONE;
        if (rotation >= 90 && rotation < 180) {
            _rotation = Rotation.CLOCKWISE_90;
        } else if (rotation >= 180 && rotation < 270) {
            _rotation = Rotation.CLOCKWISE_180;
        } else if (rotation >= 270) {
            _rotation = Rotation.COUNTERCLOCKWISE_90;
        }
        if (!StructuresRotations.containsKey(structureId) && optionalRotation.isPresent()) {
            StructuresRotations.put(structureId, _rotation);
        }
        if (manual) {
            int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
            BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
            Optional structurePiecesGenerator2 = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] Spawning structure with command and without any checks.");
            }
            return structurePiecesGenerator2;
        }
        if (TERRAIN_CACHE.containsKey(chunkPos) && !TERRAIN_CACHE.get(chunkPos).getValue().equals(berezka_api_main.getValueFromPool(this.startPool))) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] Structure {} can't be spawned in {}, because it already contains: {}", new Object[]{berezka_api_main.getValueFromPool(this.startPool), chunkPos.m_45615_(), TERRAIN_CACHE.get(chunkPos).getValue()});
            }
            return Optional.empty();
        }
        boolean extraCheck = true;
        int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos chunkToBlock = chunkPos.m_45615_();
        BlockPos blockPos = new BlockPos(chunkToBlock.m_123341_(), startY, chunkToBlock.m_123343_());
        if (this.doExtraChecks.orElse(true).booleanValue() && !BerezkaStructureExtra.extraSpawningChecks(context, this, this.projectStartToHeightmap.orElse(Heightmap.Types.OCEAN_FLOOR_WG)) || !extraCheck) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] findGenerationPoint warn: extraSpawningCheck || isValidTerrainForSpawn returned false, returning Optional.empty().");
            }
            return Optional.empty();
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] Structure rotation: " + String.valueOf(_rotation) + "(original:" + rotation + ").");
        }
        if ((structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter)).isEmpty()) {
            return Optional.empty();
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] findGenerationPoint info: returning structurePiecesGenerator. (data: pos:" + String.valueOf(blockPos) + ", pool:" + berezka_api_main.getValueFromPool(this.startPool) + ", rotation: " + rotation + ", rotation isPreset?: " + optionalRotation.isPresent() + ")");
            LOGGER.info("[Berezka API] spawning structure %s at %s".formatted(berezka_api_main.getValueFromPool(this.startPool), chunkPos.m_45615_()));
        }
        Structure.GenerationStub stub = (Structure.GenerationStub)structurePiecesGenerator.get();
        BlockPos genPos = stub.f_226669_();
        Consumer originalConsumer = (Consumer)stub.f_226670_().left().get();
        Optional<Structure.GenerationStub> optional = result = this.customSpawn.isPresent() ? BerezkaStructureExtra.getBigGenerationStub(context, genPos, originalConsumer, structureId, this.startPool, this.spawnEvent) : this.getGenerationStub(context, genPos, originalConsumer, structureId);
        if (Berezka_api.debug_mode || Berezka_api.dev_mode) {
            LOGGER.info("[Berezka API] returning result.");
        }
        return result;
    }

    private Optional<Structure.GenerationStub> getGenerationStub(Structure.GenerationContext context, BlockPos genPos, Consumer<StructurePiecesBuilder> originalConsumer, String structureId) {
        Structure.GenerationStub newStub = new Structure.GenerationStub(genPos, builder -> {
            final ArrayList<StructurePiece> recordedPieces = new ArrayList<StructurePiece>();
            ArrayList<ChunkPos> occupiedChunks = new ArrayList<ChunkPos>();
            StructurePiecesBuilder proxyBuilder = new StructurePiecesBuilder((StructurePiecesBuilder)builder){
                final /* synthetic */ StructurePiecesBuilder val$builder;
                {
                    this.val$builder = structurePiecesBuilder;
                }

                public void m_142679_(StructurePiece piece) {
                    recordedPieces.add(piece);
                    this.val$builder.m_142679_(piece);
                }
            };
            originalConsumer.accept(proxyBuilder);
            for (StructurePiece piece : recordedPieces) {
                BoundingBox box = piece.m_73547_();
                int minChunkX = box.m_162395_() >> 4;
                int maxChunkX = box.m_162399_() >> 4;
                int minChunkZ = box.m_162398_() >> 4;
                int maxChunkZ = box.m_162401_() >> 4;
                for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
                    for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                        BlockPos newPos;
                        BlockPos pos;
                        ChunkPos chunkPos = new ChunkPos(cx, cz);
                        boolean contains = TERRAIN_CACHE.containsKey(chunkPos);
                        boolean same = (TERRAIN_CACHE.containsKey(chunkPos) ? TERRAIN_CACHE.get(chunkPos).getValue() : "not found").equals(structureId);
                        if (this.allowCustomChecks.orElse(berezka_api_main.defaultDoExtraChecksValue).booleanValue() && !berezka_api_main.checkChunk(chunkPos)) {
                            pos = piece.m_142171_();
                            newPos = new BlockPos(pos.m_123341_(), pos.m_123342_() + 500, pos.m_123343_());
                            for (StructurePiece pieceToDelete : recordedPieces) {
                                pieceToDelete.m_6324_(newPos.m_123341_(), newPos.m_123342_(), newPos.m_123343_());
                            }
                            LOGGER.info("[Berezka API] structure {} at {} was removed.", (Object)structureId, (Object)berezka_api_main.readebleCoordinates(genPos));
                        }
                        if (!contains) {
                            if (Berezka_api.debug_mode || Berezka_api.dev_mode) {
                                LOGGER.info("[Berezka API] adding chunk {} to cache with value {}", (Object)chunkPos.m_45615_(), (Object)berezka_api_main.getValueFromPool(this.startPool));
                            }
                            BerezkaStructureExtra.saveChunkInCache(chunkPos, structureId);
                            occupiedChunks.add(chunkPos);
                            continue;
                        }
                        if (Berezka_api.debug_mode) {
                            LOGGER.info("[Berezka API] chunk: {} in cache: {}, same: {} ({} {} {})", new Object[]{berezka_api_main.readebleCoordinates(chunkPos.m_45615_()), contains, same, structureId, same ? "==" : "!=", TERRAIN_CACHE.containsKey(chunkPos) ? TERRAIN_CACHE.get(chunkPos).getValue() : "not found"});
                        }
                        if (same) continue;
                        LOGGER.warn("[Berezka API] structure {} at {} is spawned inside other structure {}, trying to destroy structure...", new Object[]{structureId, berezka_api_main.readebleCoordinates(genPos), TERRAIN_CACHE.containsKey(chunkPos) ? TERRAIN_CACHE.get(chunkPos).getValue() : "not found"});
                        pos = piece.m_142171_();
                        newPos = new BlockPos(pos.m_123341_(), pos.m_123342_() + 500, pos.m_123343_());
                        for (StructurePiece pieceToDelete : recordedPieces) {
                            pieceToDelete.m_6324_(newPos.m_123341_(), newPos.m_123342_(), newPos.m_123343_());
                        }
                        LOGGER.info("[Berezka API] structure {} at {} was removed.", (Object)structureId, (Object)berezka_api_main.readebleCoordinates(genPos));
                        return;
                    }
                }
            }
            onStructureSpawned event = new onStructureSpawned(recordedPieces, structureId, genPos, occupiedChunks);
            if (Berezka_api.debug_mode || Berezka_api.dev_mode) {
                LOGGER.info("[Berezka API] onStructureSpawned event was called at: {}", (Object)genPos);
            }
            MinecraftForge.EVENT_BUS.post((Event)event);
        });
        Optional<Structure.GenerationStub> result = Optional.of(newStub);
        if (Berezka_api.debug_mode || Berezka_api.dev_mode) {
            LOGGER.info("[Berezka API] onStructureSpawn1() 1:{} 2:{}", (Object)this.spawnEvent.isPresent(), (Object)berezka_api_main.getValueFromPool(this.startPool));
        }
        if (this.spawnEvent.isPresent()) {
            String namespace = berezka_api_main.getValueFromPool(this.startPool).split(":")[0];
            if (Berezka_api.debug_mode || Berezka_api.dev_mode) {
                LOGGER.info("[Berezka API] onStructureSpawn2() namespace: {}", (Object)namespace);
            }
            if (berezka_api_main.CodeRegisteredMods.containsKey(namespace)) {
                List<Object> modData;
                Map methods;
                if (Berezka_api.debug_mode || Berezka_api.dev_mode) {
                    LOGGER.info("[Berezka API] onStructureSpawn3()");
                }
                if ((methods = (Map)(modData = berezka_api_main.CodeRegisteredMods.get(namespace)).get(1)).containsKey("onStructureSpawn")) {
                    if (Berezka_api.debug_mode || Berezka_api.dev_mode) {
                        LOGGER.info("[Berezka API] onStructureSpawn4()");
                    }
                    try {
                        if (Berezka_api.debug_mode || Berezka_api.dev_mode) {
                            LOGGER.info("[Berezka API] onStructureSpawn5()");
                        }
                        ((Method)methods.get("onStructureSpawn")).invoke((Object)Berezka_api.getAPI(), this.spawnEvent.get(), context);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException("[Berezka API] error: " + String.valueOf(e));
                    }
                }
            }
        }
        return result;
    }

    public static Optional<Structure.GenerationStub> getBigGenerationStub(Structure.GenerationContext context, BlockPos genPos, Consumer<StructurePiecesBuilder> originalConsumer, String structureId, Holder<StructureTemplatePool> startPool, Optional<String> spawnEvent) {
        Structure.GenerationStub newStub = new Structure.GenerationStub(genPos, builder -> {
            final ArrayList recordedPieces = new ArrayList();
            ArrayList customPieces = new ArrayList();
            HashMap methods = new HashMap();
            StructureTemplateManager manager = context.f_226625_();
            String namespace = berezka_api_main.getValueFromPool(startPool).split(":")[0];
            if (berezka_api_main.CodeRegisteredMods.containsKey(namespace)) {
                List<Object> modData = berezka_api_main.CodeRegisteredMods.get(namespace);
                methods.putAll((Map)modData.get(1));
                if (methods.containsKey("customSpawn")) {
                    try {
                        customPieces.addAll((List)((Method)methods.get("customSpawn")).invoke((Object)Berezka_api.getAPI(), context, genPos, structureId));
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException("[Berezka API] error: " + String.valueOf(e));
                    }
                }
            }
            StructurePiecesBuilder proxyBuilder = new StructurePiecesBuilder((StructurePiecesBuilder)builder, customPieces){
                final /* synthetic */ StructurePiecesBuilder val$builder;
                final /* synthetic */ List val$customPieces;
                {
                    this.val$builder = structurePiecesBuilder;
                    this.val$customPieces = list2;
                }

                public void m_142679_(StructurePiece piece) {
                    recordedPieces.add(piece);
                    this.val$builder.m_142679_(piece);
                    for (PoolElementStructurePiece customPiece : this.val$customPieces) {
                        this.val$builder.m_142679_((StructurePiece)customPiece);
                    }
                }
            };
            if (methods.containsKey("getJigsaw")) {
                try {
                    List jigsawBlocks = (List)((Method)methods.get("getJigsaw")).invoke((Object)Berezka_api.getAPI(), structureId, genPos);
                    ResourceLocation location = new ResourceLocation("the_lost_city:city_megapolis");
                    ServerLevel level = berezka_api_main.getCurWorld();
                    ResourceKey poolKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256948_, (ResourceLocation)location);
                    Holder pool = level.m_9598_().m_175515_(Registries.f_256948_).m_203636_(poolKey).orElse(null);
                    if (pool != null) {
                        for (BlockPos jigsawBlock : jigsawBlocks) {
                            JigsawPlacement.m_227203_((ServerLevel)level, (Holder)pool, (ResourceLocation)location, (int)7, (BlockPos)jigsawBlock, (boolean)false);
                        }
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException("[Berezka API] error: " + String.valueOf(e));
                }
            }
            originalConsumer.accept(proxyBuilder);
            if (berezka_api_main.debugMode) {
                for (StructurePiece piece : recordedPieces) {
                    BoundingBox box = piece.m_73547_();
                    int minChunkX = box.m_162395_() >> 4;
                    int maxChunkX = box.m_162399_() >> 4;
                    int minChunkZ = box.m_162398_() >> 4;
                    int maxChunkZ = box.m_162401_() >> 4;
                    for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
                        for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                            ChunkPos chunkpos = new ChunkPos(cx, cz);
                            if (!berezka_api_main.getCurWorld().m_46749_(chunkpos.m_45615_())) {
                                LOGGER.error("[Deferred Structures] ChunkManager: chunk at {} {} is not loaded. (structure: {})", new Object[]{chunkpos, berezka_api_main.readebleCoordinates(chunkpos.m_45615_()), structureId});
                                continue;
                            }
                            LOGGER.info("[Deferred Structures] ChunkManager: chunk at {} {} is loaded. (structure: {})", new Object[]{chunkpos, berezka_api_main.readebleCoordinates(chunkpos.m_45615_()), structureId});
                        }
                    }
                }
            }
        });
        Optional<Structure.GenerationStub> result = Optional.of(newStub);
        if (spawnEvent.isPresent()) {
            String namespace = berezka_api_main.getValueFromPool(startPool).split(":")[0];
            LOGGER.info("[Deferred Structures] onStructureSpawn2() namespace: {}", (Object)namespace);
            if (berezka_api_main.CodeRegisteredMods.containsKey(namespace)) {
                LOGGER.info("[Deferred Structures] onStructureSpawn3()");
                List<Object> modData = berezka_api_main.CodeRegisteredMods.get(namespace);
                Map methods = (Map)modData.get(1);
                if (methods.containsKey("onStructureSpawn")) {
                    LOGGER.info("[Deferred Structures] onStructureSpawn4()");
                    try {
                        LOGGER.info("[Deferred Structures] onStructureSpawn5()");
                        ((Method)methods.get("onStructureSpawn")).invoke((Object)Berezka_api.getAPI(), spawnEvent.get(), context);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException("[Deferred Structures] error: " + String.valueOf(e));
                    }
                }
            }
        }
        return result;
    }

    public static Boolean isValidTerrainForSpawn(ServerLevel world, ChunkPos chunkPos, BerezkaStructureExtra data) {
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] isValidTerrainForSpawn called. (ChunkPos:%s, World: %s)".formatted(chunkPos, world));
        }
        if (TERRAIN_CACHE.containsKey(chunkPos)) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] isValidTerrainForSpawn info: returning cached value: %s.".formatted(TERRAIN_CACHE.get(chunkPos).getValue().equals("0") || TERRAIN_CACHE.get(chunkPos).getValue().equals(berezka_api_main.getValueFromPool(data.startPool))));
            }
            return TERRAIN_CACHE.get(chunkPos).getValue().equals("0") || TERRAIN_CACHE.get(chunkPos).getValue().equals(berezka_api_main.getValueFromPool(data.startPool));
        }
        return true;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)BerezkaStructures.BEREZKA_STRUCTURES_EXTRA.get();
    }

    public static boolean isManualPlacement() {
        return false;
    }

    public static void saveChunkInCache(ChunkPos chunk, String value) {
        if (TERRAIN_CACHE.size() > 1000 && Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] cache is full. calling clearCache()");
            BerezkaStructureExtra.clearCache();
        }
        TERRAIN_CACHE.put(chunk, new StructureCacheEntry(value));
    }

    public static void clearCache() {
        long now = System.currentTimeMillis();
        TERRAIN_CACHE.entrySet().removeIf(entry -> {
            StructureCacheEntry value = (StructureCacheEntry)entry.getValue();
            return now - value.getTime() > Berezka_api.MAX_AGE;
        });
    }

    public static Boolean boxContainsStructures(BoundingBox box, String structureID) {
        int minChunkX = box.m_162395_() >> 4;
        int maxChunkX = box.m_162399_() >> 4;
        int minChunkZ = box.m_162398_() >> 4;
        int maxChunkZ = box.m_162401_() >> 4;
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                ChunkPos chunkPos = new ChunkPos(cx, cz);
                boolean contains = TERRAIN_CACHE.containsKey(chunkPos);
                boolean same = (TERRAIN_CACHE.containsKey(chunkPos) ? TERRAIN_CACHE.get(chunkPos).getValue() : "not found").equals(structureID);
                if (!contains || same) continue;
                return true;
            }
        }
        return false;
    }

    public static Rotation getRotationOfStructure(String id) {
        return StructuresRotations.getOrDefault(id, null);
    }
}

