/*
 * Decompiled with CFR 0.152.
 */
package org.berezka.berezka_api;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;

public class BerezkasWorldData
extends SavedData {
    private static final String DATA_NAME = "berezka_structures";
    private final HashMap<ChunkPos, Integer> structures = new HashMap();

    public int get(ChunkPos pos) {
        return this.structures.getOrDefault(pos, -1);
    }

    public void save(ChunkPos pos, int salt) {
        this.structures.put(pos, salt);
        this.m_77762_();
    }

    public void remove(ChunkPos pos) {
        this.structures.remove(pos);
        this.m_77762_();
    }

    public HashMap<ChunkPos, Integer> getStructureData() {
        return new HashMap<ChunkPos, Integer>(this.structures);
    }

    public boolean contains(ChunkPos pos) {
        return this.structures.containsKey(pos);
    }

    public static BerezkasWorldData get(Level level) {
        if (level.m_5776_()) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        return (BerezkasWorldData)serverLevel.m_8895_().m_164861_(BerezkasWorldData::load, BerezkasWorldData::create, DATA_NAME);
    }

    public static BerezkasWorldData create() {
        return new BerezkasWorldData();
    }

    public static BerezkasWorldData load(CompoundTag tag) {
        BerezkasWorldData data = new BerezkasWorldData();
        CompoundTag structuresTag = tag.m_128469_("structures");
        for (String key : structuresTag.m_128431_()) {
            String[] coords = key.split("_");
            if (coords.length != 2) continue;
            try {
                int x = Integer.parseInt(coords[0]);
                int z = Integer.parseInt(coords[1]);
                int salt = structuresTag.m_128451_(key);
                data.structures.put(new ChunkPos(x, z), salt);
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid chunk coordinates: " + key);
            }
        }
        return data;
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        CompoundTag structuresTag = new CompoundTag();
        for (Map.Entry<ChunkPos, Integer> entry : this.structures.entrySet()) {
            String key = entry.getKey().f_45578_ + "_" + entry.getKey().f_45579_;
            structuresTag.m_128405_(key, entry.getValue().intValue());
        }
        tag.m_128365_("structures", (Tag)structuresTag);
        return tag;
    }
}

