/*
 * Decompiled with CFR 0.152.
 */
package org.berezka.berezka_api;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.fml.loading.FMLPaths;
import org.berezka.berezka_api.Berezka_api;
import org.berezka.berezka_api.berezka_api_main;
import org.slf4j.Logger;

public class BuiltInResourcePack
implements PackResources {
    private static final Gson GSON = new Gson();
    public static final Logger LOGGER = LogUtils.getLogger();
    private static String reducedSmallHouseLoot = "{\n  \"type\": \"minecraft:chest\",\n  \"pools\": [\n    {\n      \"rolls\": 5,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"weight\": 5,\n          \"functions\": [\n            {\n              \"function\": \"minecraft:set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 5\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:iron_ingot\",\n          \"weight\": 1\n        },\n        {\n          \"type\": \"minecraft:group\",\n          \"children\": [\n            {\n              \"type\": \"minecraft:item\",\n              \"name\": \"minecraft:poisonous_potato\",\n              \"weight\": 1\n            },\n            {\n              \"type\": \"minecraft:item\",\n              \"name\": \"minecraft:potato\",\n              \"weight\": 1\n            },\n            {\n              \"type\": \"minecraft:item\",\n              \"name\": \"minecraft:baked_potato\",\n              \"weight\": 1\n            },\n            {\n              \"type\": \"minecraft:item\",\n              \"name\": \"minecraft:cobweb\",\n              \"weight\": 2\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:bread\",\n          \"weight\": 1\n        }\n      ],\n      \"functions\": []\n    }\n  ],\n  \"random_sequence\": \"berezka_api:chests/berezkahousesmall_0\"\n}\n";
    private static String reducedCarLoot = "{\n  \"type\": \"minecraft:chest\",\n  \"pools\": [\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:fishing_rod\",\n          \"weight\": 1,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 1\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"weight\": 2,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 5\n              }\n            }\n          ]\n        }\n      ]\n    },\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:emerald\",\n          \"weight\": 1,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 2\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"weight\": 2,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 2\n              }\n            }\n          ]\n        }\n      ]\n    },\n    {\n      \"rolls\": {\n        \"min\": 1,\n        \"max\": 5\n      },\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:gunpowder\",\n          \"weight\": 2,\n          \"functions\": []\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:iron_ingot\",\n          \"weight\": 1,\n          \"functions\": []\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:bread\",\n          \"weight\": 3,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 3\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"weight\": 5\n        }\n      ]\n    }\n  ],\n  \"random_sequence\": \"berezka_api:chests/car\"\n}\n";
    private static String reducedDiningRoomLoot = "{\n  \"type\": \"minecraft:chest\",\n  \"pools\": [\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:bread\",\n          \"weight\": 1,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 4\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"weight\": 2\n        },\n        {\n          \"type\": \"minecraft:empty\",\n          \"weight\": 1\n        }\n      ]\n    },\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cake\",\n          \"weight\": 1,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 1\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:bread\",\n          \"weight\": 5,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 1\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"weight\": 2\n        },\n        {\n          \"type\": \"minecraft:empty\",\n          \"weight\": 1\n        }\n      ]\n    },\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:baked_potato\",\n          \"weight\": 1,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 2\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:poisonous_potato\",\n          \"weight\": 1\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"weight\": 2\n        },\n        {\n          \"type\": \"minecraft:empty\",\n          \"weight\": 1\n        }\n      ]\n    },\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cookie\",\n          \"weight\": 2,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 2\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:mushroom_stew\",\n          \"weight\": 1,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 1\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:suspicious_stew\",\n          \"weight\": 1,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 1\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:empty\",\n          \"weight\": 1\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"weight\": 2\n        }\n      ]\n    },\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:pumpkin_pie\",\n          \"weight\": 1,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 1\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cooked_beef\",\n          \"weight\": 1,\n          \"functions\": []\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"weight\": 2\n        }\n      ]\n    },\n    {\n      \"rolls\": 2,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"functions\": [\n            {\n              \"function\": \"minecraft:set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 5\n              }\n            }\n          ]\n        }\n      ]\n    }\n  ],\n  \"random_sequence\": \"berezka_api:chests/diningroom\"\n}\n";
    private static String reducedFarmLoot = "{\n  \"type\": \"minecraft:chest\",\n  \"pools\": [\n    {\n      \"rolls\": {\n        \"min\": 1,\n        \"max\": 5\n      },\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:wheat_seeds\",\n          \"weight\": 1,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 10\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:pumpkin_seeds\",\n          \"weight\": 1,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 5\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:melon_seeds\",\n          \"weight\": 1,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 5\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:beetroot_seeds\",\n          \"weight\": 1,\n          \"functions\": [\n            {\n              \"function\": \"set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 5\n              }\n            }\n          ]\n        }\n      ]\n    },\n    {\n      \"rolls\": 2,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"functions\": [\n            {\n              \"function\": \"minecraft:set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 5\n              }\n            }\n          ]\n        }\n      ]\n    }\n  ],\n  \"random_sequence\": \"berezka_api:chests/farm\"\n}\n";
    private static String reducedStoreLoot = "{\n  \"type\": \"minecraft:chest\",\n  \"pools\": [\n    {\n      \"rolls\": {\n        \"min\": 1,\n        \"max\": 3\n      },\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:bread\",\n          \"weight\": 10\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:apple\",\n          \"weight\": 8\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cooked_beef\",\n          \"weight\": 6\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:rotten_flesh\",\n          \"weight\": 12\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"weight\": 10\n        }\n      ]\n    },\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:iron_sword\",\n          \"weight\": 1,\n          \"functions\": []\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:crossbow\",\n          \"weight\": 1\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:arrow\",\n          \"functions\": [\n            {\n              \"function\": \"minecraft:set_count\",\n              \"count\": {\n                \"min\": 2,\n                \"max\": 4\n              }\n            }\n          ],\n          \"weight\": 6\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:bow\",\n          \"weight\": 2\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:iron_axe\",\n          \"weight\": 3\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"weight\": 10\n        }\n      ]\n    },\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:iron_ingot\",\n          \"functions\": [],\n          \"weight\": 8\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:gold_nugget\",\n          \"functions\": [\n            {\n              \"function\": \"minecraft:set_count\",\n              \"count\": {\n                \"min\": 2,\n                \"max\": 4\n              }\n            }\n          ],\n          \"weight\": 10\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:emerald\",\n          \"weight\": 5\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"weight\": 50,\n          \"functions\": [\n            {\n              \"function\": \"minecraft:set_count\",\n              \"count\": {\n                \"min\": 1,\n                \"max\": 5\n              }\n            }\n          ]\n        }\n      ]\n    },\n    {\n      \"rolls\": {\n        \"min\": 0,\n        \"max\": 1\n      },\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:book\",\n          \"weight\": 5\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:paper\",\n          \"functions\": [\n            {\n              \"function\": \"minecraft:set_count\",\n              \"count\": {\n                \"min\": 3,\n                \"max\": 8\n              }\n            }\n          ],\n          \"weight\": 6\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:map\",\n          \"weight\": 2\n        }\n      ]\n    },\n    {\n      \"rolls\": {\n        \"min\": 0,\n        \"max\": 1\n      },\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:iron_helmet\",\n          \"weight\": 3\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:iron_chestplate\",\n          \"weight\": 2\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:iron_leggings\",\n          \"weight\": 2\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:iron_boots\",\n          \"weight\": 3\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"weight\": 10\n        }\n      ]\n    }\n  ],\n  \"random_sequence\": \"berezka_api:chests/store\"\n}\n";
    private static String reducedTreasureLoot = "{\n  \"pools\": [\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:iron_ingot\",\n          \"weight\": 100,\n          \"functions\": [\n            {\n              \"function\": \"minecraft:set_count\",\n              \"count\": {\n                \"min\": 5,\n                \"max\": 20\n              }\n            }\n          ]\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:air\",\n          \"weight\": 10\n        }\n      ]\n    },\n    {\n      \"rolls\": 1,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:diamond\",\n          \"weight\": 1\n        },\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:gold_ingot\",\n          \"functions\": [\n            {\n              \"function\": \"minecraft:set_count\",\n              \"count\": {\n                \"type\": \"minecraft:uniform\",\n                \"min\": 1,\n                \"max\": 5\n              }\n            }\n          ]\n        }\n      ]\n    },\n    {\n      \"rolls\": 5,\n      \"entries\": [\n        {\n          \"type\": \"minecraft:item\",\n          \"name\": \"minecraft:cobweb\",\n          \"weight\": 1\n        }\n      ]\n    }\n  ]\n}\n";

    public BuiltInResourcePack() {
        LOGGER.info("[Berezka API] Builtin resource pack created.");
    }

    public IoSupplier<InputStream> m_8017_(String ... fileName) {
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] getRootResource called with: " + Arrays.toString(fileName));
        }
        if (fileName.length > 0 && fileName[0].equals("pack.mcmeta")) {
            return () -> {
                String mcmetaContent = this.createPackMcmetaContent();
                return new ByteArrayInputStream(mcmetaContent.getBytes(StandardCharsets.UTF_8));
            };
        }
        return null;
    }

    private String createPackMcmetaContent() {
        JsonObject root = new JsonObject();
        JsonObject pack = new JsonObject();
        pack.addProperty("description", Berezka_api.resourcePackName);
        pack.addProperty("pack_format", (Number)10);
        root.add("pack", (JsonElement)pack);
        JsonObject custom = new JsonObject();
        custom.addProperty("generated", Boolean.valueOf(true));
        custom.addProperty("author", "Berezka");
        root.add("custom", (JsonElement)custom);
        return root.toString();
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) throws IOException {
        if (serializer.m_7991_().equals("pack")) {
            return (T)this.createPackMetadata();
        }
        return null;
    }

    private PackMetadataSection createPackMetadata() {
        MutableComponent description = Component.m_237113_((String)Berezka_api.resourcePackName);
        int packFormat = 10;
        return new PackMetadataSection((Component)description, packFormat);
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] getResource called with type: " + String.valueOf(type) + " and location: " + String.valueOf(location));
        }
        if (type == PackType.SERVER_DATA && berezka_api_main.allRegisteredModsNames.contains(location.m_135827_())) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] Mod is registered: " + berezka_api_main.allRegisteredModsNames.contains(location.m_135827_()) + " folder: " + berezka_api_main.FolderRegisteredModsNames.contains(location.m_135827_()) + " code: " + berezka_api_main.CodePluginRegisteredModsNames.contains(location.m_135827_()));
            }
            if (location.m_135827_().equals("berezka_api")) {
                String resourcePath = location.m_135815_();
                if (resourcePath.startsWith("loot_tables/chests")) {
                    String fileName = resourcePath.substring("loot_tables/chests/".length());
                    if (berezka_api_main.customLootData.contains(fileName.replace(".json", ""))) {
                        String jsonContent = berezka_api_main.customLootDataDic.get(fileName.replace(".json", ""));
                        if (Berezka_api.debug_mode) {
                            LOGGER.info("[Berezka API] Returning: " + jsonContent + " to " + resourcePath + " of " + location.m_135827_());
                        }
                        return () -> new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                    }
                    if (Berezka_api.filesPluginsFolderExist) {
                        String customFilePath = FMLPaths.GAMEDIR.get().toString() + File.separator + "berezka_plugins" + File.separator + "berezka_api" + File.separator + "lootData" + File.separator + fileName;
                        File customFile = new File(customFilePath);
                        if (customFile.exists()) {
                            IoSupplier ioSupplier;
                            LOGGER.info("[Berezka API] file exist: " + customFilePath);
                            FileInputStream fileInputStream = new FileInputStream(customFile);
                            try {
                                byte[] fileContent = ((InputStream)fileInputStream).readAllBytes();
                                ioSupplier = () -> new ByteArrayInputStream(fileContent);
                            }
                            catch (Throwable fileContent) {
                                try {
                                    try {
                                        ((InputStream)fileInputStream).close();
                                    }
                                    catch (Throwable throwable) {
                                        fileContent.addSuppressed(throwable);
                                    }
                                    throw fileContent;
                                }
                                catch (IOException e) {
                                    LOGGER.error("[Berezka API] Error reading file " + customFile.getPath(), (Throwable)e);
                                    throw new RuntimeException(e);
                                }
                            }
                            ((InputStream)fileInputStream).close();
                            return ioSupplier;
                        }
                        LOGGER.info("[Berezka API] called getResource with namespace berezka_api but file (" + fileName + ") doesnt exist");
                    } else {
                        if (Berezka_api.reducedLoot) {
                            return () -> {
                                String jsonContent = switch (fileName.replace("loot_tables/chests/", "")) {
                                    case "berezkahousesmall_0.json" -> reducedSmallHouseLoot;
                                    case "car.json" -> reducedCarLoot;
                                    case "diningroom.json" -> reducedDiningRoomLoot;
                                    case "farm.json" -> reducedFarmLoot;
                                    case "store.json" -> reducedStoreLoot;
                                    case "treasure.json" -> reducedTreasureLoot;
                                    default -> throw new IllegalArgumentException("[Berezka API] Unknown file: " + fileName);
                                };
                                if (Berezka_api.debug_mode) {
                                    LOGGER.info("[Berezka API] returning reduced loot for: %s. \n loot-table:%s".formatted(fileName, jsonContent));
                                }
                                return new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                            };
                        }
                        LOGGER.warn("[Berezka API] called getResource with namespace berezka_api but file (" + fileName + ") doesnt exist. (most of the time you can ignore this");
                    }
                }
            } else if (berezka_api_main.allRegisteredModsNames.contains(location.m_135827_())) {
                String resourcePath = location.m_135815_();
                if (Berezka_api.loadFolderData) {
                    List<Object> _resources = berezka_api_main.FolderPlugins.get(location.m_135827_());
                    if (Berezka_api.debug_mode) {
                        LOGGER.info("[Berezka API] resource of FolderPlugins for " + location.m_135827_() + " empty: " + (_resources == null) + " full list: " + String.valueOf(berezka_api_main.FolderPlugins));
                    }
                    if (_resources != null) {
                        if (Berezka_api.debug_mode) {
                            LOGGER.info("[Berezka API] resource of FolderPlugins for " + location.m_135827_() + " is  " + String.valueOf(_resources));
                        }
                        for (Object resource : _resources) {
                            String listPath = "loot_tables/" + (String)((List)resource).get(1);
                            if (Berezka_api.debug_mode) {
                                LOGGER.info("[Berezka API] resource of FolderPlugins: " + String.valueOf((List)resource) + " from: " + location.m_135827_() + " current resource: " + (String)((List)resource).get(1) + " path: " + location.m_135815_() + " same?: " + listPath.equals(location.m_135815_()));
                            }
                            if (!listPath.equals(location.m_135815_())) continue;
                            if (Berezka_api.debug_mode) {
                                LOGGER.info("[Berezka API] getting file from FolderPlugins: " + (String)((List)resource).get(0) + " namespace: " + location.m_135827_());
                            }
                            String jsonContent = berezka_api_main.getFileFromFolderPlugins((String)((List)resource).get(0), location.m_135827_());
                            if (Berezka_api.debug_mode) {
                                LOGGER.info("[Berezka API] returning (BerezkaAPI-133): " + jsonContent + " to: " + location.m_135815_() + " of " + location.m_135827_());
                            }
                            return () -> new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                        }
                    }
                }
                if ((location.m_135815_().startsWith("loot_tables/chests") || location.m_135815_().startsWith("loot_tables/") || location.m_135815_().startsWith("loot_tables/chests/" + location.m_135827_())) && berezka_api_main.FolderRegisteredMods.containsKey(location.m_135827_())) {
                    String fileName = "";
                    if (location.m_135815_().startsWith("loot_tables/chests/" + location.m_135827_())) {
                        fileName = resourcePath.replace("loot_tables/chests/" + location.m_135827_() + "/", "").replace(".json", "");
                        if (Berezka_api.debug_mode) {
                            LOGGER.info("[Berezka API] getResource for FolderRegisteredMods fileName: " + fileName);
                        }
                    } else if (location.m_135815_().startsWith("loot_tables/chests/")) {
                        fileName = resourcePath.replace("loot_tables/chests/", "").replace(".json", "");
                        if (Berezka_api.debug_mode) {
                            LOGGER.info("[Berezka API] getResource for FolderRegisteredMods fileName: " + fileName);
                        }
                    } else if (location.m_135815_().startsWith("loot_tables/")) {
                        fileName = resourcePath.replace("loot_tables/", "").replace(".json", "");
                        if (Berezka_api.debug_mode) {
                            LOGGER.info("[Berezka API] getResource for loot_tables FolderRegisteredMods fileName: " + fileName);
                        }
                    }
                    List<String> resourcesList = berezka_api_main.FolderRegisteredMods.get(location.m_135827_());
                    if (Berezka_api.debug_mode) {
                        LOGGER.info("[Berezka API] getResource for FolderRegisteredMods fileName: " + fileName + " isRegistered?: " + resourcesList.contains(fileName));
                        if (!resourcesList.contains(fileName)) {
                            LOGGER.warn("[Berezka API] getResource for FolderRegisteredMods fileName that doesn't registered:" + fileName + " list: " + resourcesList.toString());
                        }
                    }
                    if (resourcesList.contains(fileName)) {
                        String jsonContent = berezka_api_main.getFileFromFolderPlugins(fileName, location.m_135827_());
                        if (jsonContent == null) {
                            if (Berezka_api.debug_mode) {
                                LOGGER.warn("[Berezka API] No JSON found for " + String.valueOf(location));
                            }
                            return null;
                        }
                        if (Berezka_api.debug_mode && jsonContent.length() < 10000) {
                            LOGGER.info("[Berezka API] returning " + jsonContent + " to: " + location.m_135815_() + " of " + location.m_135827_());
                        }
                        return () -> new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                    }
                } else if (berezka_api_main.CodePluginRegisteredModsNames.contains(location.m_135827_())) {
                    String jsonContent;
                    if (Berezka_api.debug_mode) {
                        LOGGER.info("[Berezka API] getting json from " + location.m_135827_() + " " + location.m_135815_());
                    }
                    if ((jsonContent = this.getJson(location.m_135827_(), location.m_135815_())) == null) {
                        if (Berezka_api.debug_mode) {
                            LOGGER.warn("[Berezka API] No JSON found for " + String.valueOf(location));
                        }
                        return null;
                    }
                    if (Berezka_api.debug_mode && jsonContent.length() < 10000) {
                        LOGGER.info("[Berezka API] returning " + jsonContent + " to: " + location.m_135815_() + " of " + location.m_135827_());
                    }
                    return () -> new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                }
            }
        } else if (!location.m_135827_().equals("berezka_api") && berezka_api_main.CodeRegisteredMods.containsKey(location.m_135827_())) {
            LOGGER.info("getting json from " + location.m_135827_() + " " + location.m_135815_());
            String jsonContent = this.getJson(location.m_135827_(), location.m_135815_());
            if (jsonContent == null) {
                if (Berezka_api.debug_mode) {
                    LOGGER.warn("[Berezka API] No JSON found for " + String.valueOf(location));
                }
                return null;
            }
            if (Berezka_api.debug_mode && jsonContent.length() < 10000) {
                LOGGER.info("[Berezka API] returning " + jsonContent + " to: " + location.m_135815_() + " of " + location.m_135827_());
            }
            return () -> new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] returning null to: " + location.m_135815_() + " of " + location.m_135827_());
        }
        return null;
    }

    public void m_8031_(PackType type, String namespace, String path, PackResources.ResourceOutput output) {
        block44: {
            block42: {
                block43: {
                    if (Berezka_api.debug_mode) {
                        LOGGER.info("[Berezka API] listResources called with type: " + String.valueOf(type) + ", namespace: " + namespace + " (" + berezka_api_main.CodePluginRegisteredModsNames.contains(namespace) + "), path: " + path);
                    }
                    if (type != PackType.SERVER_DATA || !berezka_api_main.allRegisteredModsNames.contains(namespace)) break block42;
                    if (!namespace.equals("berezka_api")) break block43;
                    if (!path.equals("loot_tables")) break block44;
                    ArrayList<Object> resources = new ArrayList<Object>();
                    if (berezka_api_main.customLootData != null && !berezka_api_main.customLootData.isEmpty()) {
                        if (Berezka_api.debug_mode) {
                            LOGGER.info("[Berezka API] loaded some loot data.");
                        }
                        for (String string : berezka_api_main.customLootData) {
                            String string2 = string.replace(".json", "");
                            if (!resources.contains("loot_tables/chests/" + string2 + ".json")) {
                                resources.add("loot_tables/chests/" + string2 + ".json");
                                continue;
                            }
                            if (!Berezka_api.debug_mode) continue;
                            LOGGER.info("[Berezka API] rejected file: %s, because its already in list.".formatted("loot_tables/chests/" + string2 + ".json"));
                        }
                    }
                    if (Berezka_api.filesPluginsFolderExist) {
                        List<String> lootData;
                        if (Berezka_api.debug_mode) {
                            LOGGER.info("[Berezka API] berezka api list resource loot_tables");
                        }
                        if (!(lootData = berezka_api_main.loadLootDataFiles(FMLPaths.GAMEDIR.get().toString() + File.separator + "berezka_plugins" + File.separator + "berezka_api" + File.separator + "lootData")).isEmpty()) {
                            if (Berezka_api.debug_mode) {
                                LOGGER.info("[Berezka API] loaded some loot data");
                            }
                            for (String item : lootData) {
                                if (!resources.contains("loot_tables/chests/" + (item = item.replace(".json", "")))) {
                                    resources.add("loot_tables/chests/" + item);
                                    continue;
                                }
                                if (!Berezka_api.debug_mode) continue;
                                LOGGER.info("[Berezka API] rejected file: %s, because its already in list.".formatted("loot_tables/chests/" + item + ".json"));
                            }
                        }
                    }
                    if (berezka_api_main.isLootReduced()) {
                        if (Berezka_api.debug_mode) {
                            LOGGER.info("[Berezka API] listing reduced loot tables.");
                        }
                        ArrayList<String> reducedLootTables = new ArrayList<String>(List.of("loot_tables/chests/berezkahousesmall_0.json", "loot_tables/chests/car.json", "loot_tables/chests/farm.json", "loot_tables/chests/store.json", "loot_tables/chests/diningroom.json", "loot_tables/chests/treasure.json"));
                        Iterator iterator = reducedLootTables.iterator();
                        while (iterator.hasNext()) {
                            String item2 = (String)iterator.next();
                            if (!resources.contains(item2)) {
                                resources.add(item2);
                                continue;
                            }
                            if (!Berezka_api.debug_mode) continue;
                            LOGGER.info("[Berezka API] rejected file: %s, because its already in list.".formatted("loot_tables/chests/" + item2));
                        }
                    }
                    for (String string : resources) {
                        if (Berezka_api.debug_mode) {
                            LOGGER.info("[Berezka API] handleBerezkasResource called with type: " + String.valueOf(type) + ", namespace: " + namespace + " (" + berezka_api_main.CodePluginRegisteredModsNames.contains(namespace) + "), path: " + path + " item: " + string);
                        }
                        this.handleBerezkasResource(output, "berezka_api", string);
                    }
                    break block44;
                }
                if (path.equals("loot_tables")) {
                    List _resources;
                    if (berezka_api_main.FolderRegisteredModsNames.contains(namespace)) {
                        if (Berezka_api.debug_mode) {
                            LOGGER.info("[Berezka API] listResources has found FolderRegisteredModsNames path: " + path + " from: " + namespace + " exist: " + berezka_api_main.FolderPlugins.containsKey(namespace));
                        }
                        if (berezka_api_main.FolderPlugins.containsKey(namespace)) {
                            _resources = berezka_api_main.FolderPlugins.get(namespace);
                            for (Object object : _resources) {
                                if (Berezka_api.debug_mode) {
                                    LOGGER.info("[Berezka API] resource of FolderPlugins: " + String.valueOf((List)object) + " from: " + namespace);
                                }
                                this.handleBerezkasResource(output, namespace, "loot_tables/" + (String)((List)object).get(1));
                            }
                        } else {
                            _resources = berezka_api_main.FolderRegisteredMods.get(namespace);
                            if (Berezka_api.debug_mode) {
                                LOGGER.info("[Berezka API] resources: " + String.valueOf(_resources));
                            }
                            for (String string : _resources) {
                                this.handleBerezkasResource(output, namespace, "loot_tables/" + string + ".json");
                                this.handleBerezkasResource(output, namespace, "loot_tables/chests/" + string + ".json");
                                this.handleBerezkasResource(output, namespace, "loot_tables/chests/" + namespace + "/" + string + ".json");
                            }
                        }
                    }
                    if (berezka_api_main.CodePluginRegisteredModsNames.contains(namespace) && ((List)berezka_api_main.CodeRegisteredMods.get(namespace).get(2)).contains(path)) {
                        _resources = null;
                        try {
                            _resources = (List)((Method)this.getMethodsFromMod(namespace).get("handleResource")).invoke((Object)namespace, path);
                            if (Berezka_api.debug_mode) {
                                LOGGER.info("resources: " + String.valueOf(_resources));
                            }
                            for (String string : _resources) {
                                this.handleResource(output, namespace, string);
                            }
                        }
                        catch (IllegalAccessException | InvocationTargetException e) {
                            throw new RuntimeException(e);
                        }
                    }
                } else if (berezka_api_main.CodeRegisteredMods.containsKey(namespace) && ((List)berezka_api_main.CodeRegisteredMods.get(namespace).get(2)).contains(path)) {
                    List _resources = null;
                    try {
                        _resources = (List)((Method)this.getMethodsFromMod(namespace).get("handleResource")).invoke((Object)namespace, path);
                        if (Berezka_api.debug_mode) {
                            LOGGER.info("resources: " + String.valueOf(_resources));
                        }
                        for (String string : _resources) {
                            this.handleResource(output, namespace, string);
                        }
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        throw new RuntimeException(e);
                    }
                }
                break block44;
            }
            if (type == PackType.CLIENT_RESOURCES && berezka_api_main.CodePluginRegisteredModsNames.contains(namespace) && berezka_api_main.CodeRegisteredMods.containsKey(namespace) && !namespace.equals("berezka_api") && ((List)berezka_api_main.CodeRegisteredMods.get(namespace).get(2)).contains(path)) {
                List _resources = null;
                try {
                    LOGGER.info("[Berezka API] CLIENT_RESOURCES: namespace: " + namespace + " list: " + String.valueOf(berezka_api_main.CodeRegisteredMods.get(namespace)) + " value asked for: " + String.valueOf(berezka_api_main.CodeRegisteredMods.get(namespace).get(1)));
                    _resources = (List)((Method)this.getMethodsFromMod(namespace).get("handleResource")).invoke((Object)namespace, path);
                    if (Berezka_api.debug_mode) {
                        LOGGER.info("[Berezka API] resources: " + String.valueOf(_resources));
                    }
                    for (String string : _resources) {
                        this.handleResource(output, namespace, string);
                    }
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public Set<String> m_5698_(PackType type) {
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] returning namespaces: " + String.valueOf(berezka_api_main.allRegisteredModsNames));
        }
        return new HashSet<String>(berezka_api_main.allRegisteredModsNames);
    }

    public String m_5542_() {
        return Berezka_api.resourcePackID;
    }

    public void close() {
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] resource pack info: close called.");
        }
    }

    private void handleBerezkasResource(PackResources.ResourceOutput output, String namespace, String resourcePath) {
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] handleBerezkasResource() for " + namespace + " path: " + resourcePath);
        }
        try {
            ResourceLocation resourceLocation = new ResourceLocation(namespace, resourcePath);
            output.accept((Object)resourceLocation, () -> {
                try {
                    InputStream resource = (InputStream)this.m_214146_(PackType.SERVER_DATA, resourceLocation).m_247737_();
                    if (Berezka_api.debug_mode) {
                        LOGGER.info("[Berezka API] handleBerezkasResource for " + namespace + " path: " + resourcePath + " resource: " + String.valueOf(resource));
                    }
                    return resource;
                }
                catch (IOException e) {
                    LOGGER.error("[Berezka API] Error getting resource for " + resourcePath, (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("[Berezka API] Exception in listResources method for " + resourcePath, (Throwable)e);
        }
    }

    private void handleResource(PackResources.ResourceOutput output, String namespace, String resourcePath) {
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] handleResource called with namespace: " + namespace + ", path: " + resourcePath);
        }
        boolean _isListened = false;
        try {
            _isListened = (Boolean)((Method)this.getMethodsFromMod(namespace).get("listResource")).invoke((Object)namespace, resourcePath);
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] handleResource called with namespace: " + namespace + ", path: " + resourcePath + " listened: " + _isListened);
            }
            if (_isListened) {
                try {
                    ResourceLocation resourceLocation = new ResourceLocation(namespace, resourcePath);
                    output.accept((Object)resourceLocation, () -> {
                        try {
                            if (Berezka_api.debug_mode) {
                                LOGGER.info("[Berezka API] calling getResource with namespace: " + namespace + ", path: " + resourcePath);
                            }
                            InputStream resource = (InputStream)this.m_214146_(PackType.SERVER_DATA, resourceLocation).m_247737_();
                            return resource;
                        }
                        catch (IOException e) {
                            if (Berezka_api.debug_mode) {
                                LOGGER.error("[Berezka API] Error getting resource for " + resourcePath, (Throwable)e);
                            }
                            throw new RuntimeException(e);
                        }
                    });
                }
                catch (Exception e) {
                    LOGGER.error("[Berezka API] Exception in listResources method for " + resourcePath, (Throwable)e);
                }
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public String getJson(String namespace, String jsonFileName) {
        if (!namespace.equals("berezka_api")) {
            try {
                return (String)((Method)this.getMethodsFromMod(namespace).get("getJson")).invoke((Object)namespace, jsonFileName);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("[Berezka API] Error(265): " + String.valueOf(e) + " data:{jsonFileName:%s, namespace:%s}".formatted(jsonFileName, namespace));
            }
        }
        return null;
    }

    public HashMap getMethodsFromMod(String namespace) {
        try {
            if (!berezka_api_main.CodeRegisteredMods.containsKey(namespace)) {
                throw new IllegalArgumentException("Namespace '" + namespace + "' not registered!");
            }
            List<Object> modList = berezka_api_main.CodeRegisteredMods.get(namespace);
            if (modList == null) {
                throw new IllegalStateException("[Berezka API] Mod list for namespace '" + namespace + "' is null!");
            }
            if (modList.size() <= 1) {
                throw new IndexOutOfBoundsException("[Berezka API] Mod list for namespace '" + namespace + "' is too small!");
            }
            return (HashMap)berezka_api_main.CodeRegisteredMods.get(namespace).get(1);
        }
        catch (Exception e) {
            LOGGER.error("[Berezka API] Failed to access RegisteredMods: " + String.valueOf(e));
            return null;
        }
    }
}

