/*
 * Decompiled with CFR 0.152.
 */
package org.berezka.berezka_api.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.berezka.berezka_api.BerezkaStructures;
import org.berezka.berezka_api.Berezka_api;
import org.berezka.berezka_api.berezka_api_main;
import org.berezka.berezka_api.structures.BerezkasJigsawPlacement;
import org.slf4j.Logger;

public class BerezkaStructureExtra
extends Structure {
    public static final ConcurrentHashMap<ChunkPos, String> TERRAIN_CACHE = new ConcurrentHashMap();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<BerezkaStructureExtra> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BerezkaStructureExtra.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.STRING.optionalFieldOf("banned_tags").forGetter(structure -> structure.disabledTags), (App)Codec.intRange((int)1, (int)1000).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)0, (int)180).optionalFieldOf("structure_rotation").forGetter(structure -> structure.structrure_rotation), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("structure_space").forGetter(structure -> structure.structure_space), (App)Codec.BOOL.optionalFieldOf("do_extra_checks").forGetter(structure -> structure.doExtraChecks), (App)Codec.BOOL.optionalFieldOf("check_for_structures").forGetter(structure -> structure.checkForStructures), (App)Codec.BOOL.optionalFieldOf("allow_custom_checks").forGetter(structure -> structure.allowCustomChecks)).apply((Applicative)instance, BerezkaStructureExtra::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final Optional<Integer> structrure_rotation;
    private final Optional<Integer> structure_space;
    private final Optional<Boolean> doExtraChecks;
    private final Optional<Boolean> allowCustomChecks;
    private final Optional<Boolean> checkForStructures;
    private final Optional<String> disabledTags;

    public BerezkaStructureExtra(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, Optional<String> disabledTags, int maxDistanceFromCenter, Optional<Integer> structrure_rotation, Optional<Integer> structure_space, Optional<Boolean> doExtraChecks, Optional<Boolean> checkForStructures, Optional<Boolean> allowCustomChecks) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.structrure_rotation = structrure_rotation;
        this.structure_space = structure_space;
        this.doExtraChecks = doExtraChecks;
        this.allowCustomChecks = allowCustomChecks;
        this.checkForStructures = checkForStructures;
        this.disabledTags = disabledTags;
    }

    private static boolean extraSpawningChecks(Structure.GenerationContext context, BerezkaStructureExtra data) {
        boolean waterCheck;
        boolean airCheck;
        boolean heightCheck;
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] extraSpawningChecks called.");
        }
        ChunkPos chunkpos = context.f_226628_();
        ServerLevel world = berezka_api_main.getCurWorld();
        if (world == null) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] extraSpawningChecks warn: world is null, returning false.");
            }
            return false;
        }
        int occupiedYPos = context.f_226622_().m_223235_(chunkpos.m_45604_(), chunkpos.m_45605_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_());
        NoiseColumn columnOfBlocks = context.f_226622_().m_214184_(chunkpos.m_151382_(0), chunkpos.m_151391_(0), context.f_226629_(), context.f_226624_());
        BlockState blockState = columnOfBlocks.m_183556_(occupiedYPos);
        boolean bl = heightCheck = occupiedYPos < 100;
        if (!heightCheck) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] extraSpawningChecks info: returning: false (heightCheck = false)");
            }
            return false;
        }
        boolean bl2 = airCheck = !blockState.m_60795_();
        if (!airCheck) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] extraSpawningChecks info: returning: false (airCheck = false)");
            }
            return false;
        }
        boolean bl3 = waterCheck = !blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (!waterCheck) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] extraSpawningChecks info: returning: false (waterCheck = false)");
            }
            return false;
        }
        boolean terrainCheck = BerezkaStructureExtra.isValidTerrainForSpawn(world, chunkpos, data);
        if (!terrainCheck) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] extraSpawningChecks info: returning: false (terrainCheck = false)");
            }
            return false;
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] extraSpawningChecks info: returning: true");
        }
        return true;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        boolean manual = BerezkaStructureExtra.isManualPlacement();
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] findGenerationPoint called. (Manual: %s)".formatted(manual));
        }
        ChunkPos chunkPos = context.f_226628_();
        ServerLevel world = berezka_api_main.getCurWorld();
        BlockPos centerPos = chunkPos.m_151394_(world.m_5736_());
        int rotation = 0;
        Optional<Integer> optionalRotation = this.structrure_rotation;
        if (optionalRotation.isPresent()) {
            rotation = optionalRotation.get();
        }
        if (world == null) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] findGenerationPoint warn: world is null, returning Optional.empty().");
            }
            return Optional.empty();
        }
        if (!world.m_46739_(centerPos)) {
            LOGGER.info("[Berezka API] findGenerationPoint centerPos is out of World bounds.");
            return Optional.empty();
        }
        Rotation _rotation = Rotation.NONE;
        if (rotation >= 90 && rotation < 180) {
            _rotation = Rotation.CLOCKWISE_90;
        } else if (rotation >= 180 && rotation < 270) {
            _rotation = Rotation.CLOCKWISE_180;
        } else if (rotation >= 270) {
            _rotation = Rotation.COUNTERCLOCKWISE_90;
        }
        if (manual) {
            int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
            BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
            Optional<Structure.GenerationStub> structurePiecesGenerator = BerezkasJigsawPlacement.addPieces(context, this.startPool, this.startJigsawName, this.size, blockPos, false, this.projectStartToHeightmap, this.maxDistanceFromCenter, _rotation, optionalRotation.isPresent(), chunkPos, this.structure_space.orElse(berezka_api_main.defaultStructuresSpace), true);
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] Spawning structure with command and without any checks.");
            }
            return structurePiecesGenerator;
        }
        if (TERRAIN_CACHE.contains(chunkPos) && !TERRAIN_CACHE.get(chunkPos).equals("0") && !TERRAIN_CACHE.get(chunkPos).equals(this.startPool.toString())) {
            return Optional.empty();
        }
        boolean extraCheck = true;
        int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
        if (this.allowCustomChecks.orElse(berezka_api_main.defaultDoExtraChecksValue).booleanValue()) {
            extraCheck = berezka_api_main.checkChunk(context);
        }
        if (this.doExtraChecks.orElse(true).booleanValue() && !BerezkaStructureExtra.extraSpawningChecks(context, this) || !extraCheck || world.m_8736_(blockPos, 20)) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] findGenerationPoint warn: extraSpawningCheck || isValidTerrainForSpawn returned false, returning Optional.empty().");
            }
            return Optional.empty();
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] Structure rotation: " + String.valueOf(_rotation) + "(original:" + rotation + ").");
        }
        Optional<Structure.GenerationStub> structurePiecesGenerator = BerezkasJigsawPlacement.addPieces(context, this.startPool, this.startJigsawName, this.size, blockPos, false, this.projectStartToHeightmap, this.maxDistanceFromCenter, _rotation, optionalRotation.isPresent(), chunkPos, this.structure_space.orElse(berezka_api_main.defaultStructuresSpace), false);
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] findGenerationPoint info: returning structurePiecesGenerator. (data: pos:" + String.valueOf(blockPos) + ", pool:" + String.valueOf(this.startPool) + ", rotation: " + rotation + ", rotation isPreset?: " + optionalRotation.isPresent() + ")");
        }
        LOGGER.info("[Berezka API] spawning structure %s at %s".formatted(this.startPool, chunkPos.m_45615_()));
        return structurePiecesGenerator;
    }

    public static Boolean isValidTerrainForSpawn(ServerLevel world, ChunkPos chunkPos, BerezkaStructureExtra data) {
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] isValidTerrainForSpawn called. (ChunkPos:%s, World: %s)".formatted(chunkPos, world));
        }
        if (TERRAIN_CACHE.contains(chunkPos)) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] isValidTerrainForSpawn info: returning cached value: %s.".formatted(TERRAIN_CACHE.get(chunkPos).equals("0") || TERRAIN_CACHE.get(chunkPos).equals(data.startPool.toString())));
            }
            return TERRAIN_CACHE.get(chunkPos).equals("0") || TERRAIN_CACHE.get(chunkPos).equals(data.startPool.toString());
        }
        return true;
    }

    private static boolean quickElevationCheck(ServerLevel world, ChunkPos chunkPos) {
        return true;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)BerezkaStructures.BEREZKA_STRUCTURES_EXTRA.get();
    }

    public static boolean isManualPlacement() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().contains("PlaceCommand") && !element.getMethodName().contains("place")) continue;
            return true;
        }
        return false;
    }

    public void saveChunkInCache(ChunkPos chunk, boolean value) {
        TERRAIN_CACHE.put(chunk, value ? "0" : "1");
    }
}

