/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.berezkaapi;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BuiltInResourcePack
implements PackResources {
    private static final Gson GSON = new Gson();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PACK_METADATA = "{ \"pack\": { \"pack_format\": 15, \"description\": \"Berezka API Structure Set Pack\" } }";
    private static final String CITY_CARS_JSON = "{\n  \"name\": \"the_lost_city:city_cars\",\n  \"fallback\": \"minecraft:empty\",\n  \"elements\": []\n}";
    private final int spacingValue;
    private final int separationValue;
    private final Boolean SpawnCity;
    private final Boolean SpawnCars;
    private final List<? extends String> BiomesList;
    private final List<? extends String> HousesList;
    private final List<? extends String> BasesList;

    public BuiltInResourcePack(int spacingValue, int separationValue, Boolean spawnCityValue, Boolean spawnCarsValue, List<? extends String> biomesListValue, List<? extends String> housesListValue, List<? extends String> basesListValue) {
        this.spacingValue = spacingValue;
        this.separationValue = separationValue;
        this.SpawnCity = spawnCityValue;
        this.SpawnCars = spawnCarsValue;
        this.BiomesList = biomesListValue;
        this.HousesList = housesListValue;
        this.BasesList = basesListValue;
    }

    private String createCityJson(List<String> expansionZonesList) {
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("{\n");
        jsonBuilder.append("  \"structures\": [\n");
        jsonBuilder.append("    {\n");
        jsonBuilder.append("      \"structure\": \"the_lost_city:city\",\n");
        jsonBuilder.append("      \"weight\": 1\n");
        jsonBuilder.append("    }\n");
        jsonBuilder.append("  ],\n");
        jsonBuilder.append("  \"placement\": {\n");
        jsonBuilder.append("    \"type\": \"minecraft:random_spread\",\n");
        jsonBuilder.append("    \"spacing\": ").append(this.spacingValue).append(",\n");
        jsonBuilder.append("    \"separation\": ").append(this.separationValue).append(",\n");
        jsonBuilder.append("    \"salt\": 1687843387\n");
        if (expansionZonesList != null && !expansionZonesList.isEmpty()) {
            jsonBuilder.append("    ,\"expansion_zones\": [\n");
            for (String entry : expansionZonesList) {
                String[] parts = entry.split(" - ");
                if (parts.length != 2) continue;
                String structureName = parts[0].trim();
                int distance = Integer.parseInt(parts[1].trim());
                jsonBuilder.append("      {\n");
                jsonBuilder.append("        \"structure\": \"").append(structureName).append("\",\n");
                jsonBuilder.append("        \"distance\": ").append(distance).append("\n");
                jsonBuilder.append("      },\n");
            }
            jsonBuilder.setLength(jsonBuilder.length() - 2);
            jsonBuilder.append("\n    ]\n");
        }
        jsonBuilder.append("  }\n");
        jsonBuilder.append("}");
        return jsonBuilder.toString();
    }

    public static String createCityHousesJson(List<? extends String> basesList, List<String> housesList, List<String> loadedBasesList) {
        JsonObject element;
        JsonObject root = new JsonObject();
        root.addProperty("name", "the_lost_city:city_houses");
        root.addProperty("fallback", "minecraft:empty");
        JsonArray elements = new JsonArray();
        if (basesList != null && !basesList.isEmpty()) {
            for (String string : basesList) {
                element = BuiltInResourcePack.createElement(string);
                elements.add((JsonElement)element);
            }
        }
        if (housesList != null && !housesList.isEmpty()) {
            for (String string : housesList) {
                element = BuiltInResourcePack.createElement(string);
                elements.add((JsonElement)element);
            }
        }
        if (loadedBasesList != null && !loadedBasesList.isEmpty()) {
            for (String string : loadedBasesList) {
                element = BuiltInResourcePack.createElement(string);
                elements.add((JsonElement)element);
            }
        }
        root.add("elements", (JsonElement)elements);
        return GSON.toJson((JsonElement)root);
    }

    private static JsonObject createElement(String location) {
        JsonObject element = new JsonObject();
        element.addProperty("weight", (Number)100);
        JsonObject elementDetails = new JsonObject();
        elementDetails.addProperty("element_type", "minecraft:single_pool_element");
        elementDetails.addProperty("location", location);
        elementDetails.addProperty("projection", "rigid");
        JsonObject processors = new JsonObject();
        processors.add("processors", (JsonElement)new JsonArray());
        elementDetails.add("processors", (JsonElement)processors);
        element.add("element", (JsonElement)elementDetails);
        return element;
    }

    private String createAdvancedJson(List<String> biomes) {
        if (biomes == null) {
            LOGGER.info("biomes list is empty");
            return "{\n  \"type\": \"minecraft:jigsaw\",\n  \"start_pool\": \"the_lost_city:city\",\n  \"size\": 7,\n  \"max_distance_from_center\": 116,\n  \"spawn_overrides\": {},\n  \"step\": \"surface_structures\",\n  \"terrain_adaptation\": \"beard_box\",\n  \"start_height\": {\n    \"absolute\": 0\n  },\n  \"project_start_to_heightmap\": \"WORLD_SURFACE_WG\",\n  \"biomes\": [],\n  \"use_expansion_hack\": false\n}";
        }
        LOGGER.info("biomes list is not empty");
        StringBuilder biomesJson = new StringBuilder();
        for (int i = 0; i < biomes.size(); ++i) {
            biomesJson.append("\"").append(biomes.get(i)).append("\"");
            if (i >= biomes.size() - 1) continue;
            biomesJson.append(", ");
        }
        return "{\n  \"type\": \"minecraft:jigsaw\",\n  \"start_pool\": \"the_lost_city:city\",\n  \"size\": 7,\n  \"max_distance_from_center\": 116,\n  \"spawn_overrides\": {},\n  \"step\": \"surface_structures\",\n  \"terrain_adaptation\": \"beard_box\",\n  \"start_height\": {\n    \"absolute\": 0\n  },\n  \"project_start_to_heightmap\": \"WORLD_SURFACE_WG\",\n  \"biomes\": [\n    " + biomesJson.toString() + "\n  ],\n  \"use_expansion_hack\": false\n}";
    }

    private String createCitySmallHousesJson(Set<String> blacklist, List<String> customHouses, List<String> loadedHouses) {
        StringBuilder jsonBuilder = new StringBuilder();
        jsonBuilder.append("{\n");
        jsonBuilder.append("  \"name\": \"the_lost_city:city_small_houses\",\n");
        jsonBuilder.append("  \"fallback\": \"minecraft:empty\",\n");
        jsonBuilder.append("  \"elements\": [\n");
        List<String> defaultHouses = List.of("the_lost_city:house01", "the_lost_city:house02", "the_lost_city:house03", "the_lost_city:cafe1", "the_lost_city:cafe2", "the_lost_city:cafe3", "the_lost_city:small_house1", "the_lost_city:small_house2", "the_lost_city:small_house3", "the_lost_city:small_house11", "the_lost_city:small_house21", "the_lost_city:cafe4", "the_lost_city:brick_house1", "the_lost_city:family_house1", "the_lost_city:family_house2", "the_lost_city:family_house3", "the_lost_city:house_with_car", "the_lost_city:skyscraper1", "the_lost_city:skyscraper2", "the_lost_city:family_house31", "the_lost_city:store", "the_lost_city:tall_building", "the_lost_city:blue-tall-house_b_1_0", "the_lost_city:white-tall-office_b_2_0", "the_lost_city:tall-building_a_1_1", "the_lost_city:library_a_2_0");
        for (String string : defaultHouses) {
            if (blacklist.contains(string)) continue;
            jsonBuilder.append("    {\n");
            jsonBuilder.append("      \"weight\": 1,\n");
            jsonBuilder.append("      \"element\": {\n");
            jsonBuilder.append("        \"element_type\": \"minecraft:single_pool_element\",\n");
            jsonBuilder.append("        \"location\": \"").append(string).append("\",\n");
            jsonBuilder.append("        \"projection\": \"rigid\",\n");
            jsonBuilder.append("        \"processors\": {\n");
            jsonBuilder.append("          \"processors\": []\n");
            jsonBuilder.append("        }\n");
            jsonBuilder.append("      }\n");
            jsonBuilder.append("    },\n");
        }
        for (String string : this.HousesList) {
            if (blacklist.contains(string)) continue;
            jsonBuilder.append("    {\n");
            jsonBuilder.append("      \"weight\": 1,\n");
            jsonBuilder.append("      \"element\": {\n");
            jsonBuilder.append("        \"element_type\": \"minecraft:single_pool_element\",\n");
            jsonBuilder.append("        \"location\": \"").append(string).append("\",\n");
            jsonBuilder.append("        \"projection\": \"rigid\",\n");
            jsonBuilder.append("        \"processors\": {\n");
            jsonBuilder.append("          \"processors\": []\n");
            jsonBuilder.append("        }\n");
            jsonBuilder.append("      }\n");
            jsonBuilder.append("    },\n");
        }
        if (customHouses != null && !customHouses.isEmpty()) {
            for (String string : customHouses) {
                jsonBuilder.append("    {\n");
                jsonBuilder.append("      \"weight\": 1,\n");
                jsonBuilder.append("      \"element\": {\n");
                jsonBuilder.append("        \"element_type\": \"minecraft:single_pool_element\",\n");
                jsonBuilder.append("        \"location\": \"").append(string).append("\",\n");
                jsonBuilder.append("        \"projection\": \"rigid\",\n");
                jsonBuilder.append("        \"processors\": {\n");
                jsonBuilder.append("          \"processors\": []\n");
                jsonBuilder.append("        }\n");
                jsonBuilder.append("      }\n");
                jsonBuilder.append("    },\n");
            }
        }
        if (loadedHouses != null && !loadedHouses.isEmpty()) {
            for (String string : loadedHouses) {
                jsonBuilder.append("    {\n");
                jsonBuilder.append("      \"weight\": 1,\n");
                jsonBuilder.append("      \"element\": {\n");
                jsonBuilder.append("        \"element_type\": \"minecraft:single_pool_element\",\n");
                jsonBuilder.append("        \"location\": \"").append(string).append("\",\n");
                jsonBuilder.append("        \"projection\": \"rigid\",\n");
                jsonBuilder.append("        \"processors\": {\n");
                jsonBuilder.append("          \"processors\": []\n");
                jsonBuilder.append("        }\n");
                jsonBuilder.append("      }\n");
                jsonBuilder.append("    },\n");
            }
        }
        if (jsonBuilder.charAt(jsonBuilder.length() - 2) == ',') {
            jsonBuilder.setLength(jsonBuilder.length() - 2);
        }
        jsonBuilder.append("\n  ]\n");
        jsonBuilder.append("}");
        return jsonBuilder.toString();
    }

    public static List<String> loadBasesFromFiles(String directoryPath) {
        ArrayList<String> loadedBases = new ArrayList<String>();
        File directory = new File(directoryPath);
        File[] files = directory.listFiles((dir, name) -> name.endsWith(".json"));
        if (files != null) {
            for (File file : files) {
                try (FileReader reader = new FileReader(file);){
                    JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    String structureName = jsonObject.get("structure_name").getAsString();
                    loadedBases.add(structureName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return loadedBases;
    }

    public static List<String> loadLootDataFiles(String directoryPath) {
        File[] files;
        ArrayList<String> lootDataFiles = new ArrayList<String>();
        File directory = new File(directoryPath);
        if (directory.exists() && directory.isDirectory() && (files = directory.listFiles((dir, name) -> name.endsWith(".json"))) != null) {
            for (File file : files) {
                lootDataFiles.add(file.getName());
            }
        }
        return lootDataFiles;
    }

    public IoSupplier<InputStream> m_8017_(String ... fileName) {
        if (fileName.length > 0 && fileName[0].equals("pack.mcmeta")) {
            return () -> {
                try {
                    return new ByteArrayInputStream(PACK_METADATA.getBytes(StandardCharsets.UTF_8));
                }
                catch (Exception e) {
                    LOGGER.error("Error creating ByteArrayInputStream for pack.mcmeta", (Throwable)e);
                    throw new RuntimeException(e);
                }
            };
        }
        return null;
    }

    public IoSupplier<InputStream> m_214146_(PackType type, ResourceLocation location) {
        LOGGER.info("getResource called with type: " + type + " and location: " + location);
        if (type == PackType.SERVER_DATA) {
            if (location.m_135827_().equals("the_lost_city")) {
                if (location.m_135815_().equals("worldgen/structure_set/city.json")) {
                    try {
                        List<String> defaultExpansionZonesList = List.of("minecraft:village - 10");
                        String jsonContent = this.createCityJson(defaultExpansionZonesList);
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                        return () -> new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error creating ByteArrayInputStream for City.json", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                if (location.m_135815_().equals("worldgen/structure/city.json")) {
                    try {
                        ArrayList<? extends String> biomes = null;
                        if (this.SpawnCity.booleanValue()) {
                            biomes = new ArrayList<String>(this.BiomesList);
                        }
                        String jsonContent = this.createAdvancedJson(biomes);
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                        return () -> new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error creating ByteArrayInputStream for City.json", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                if (location.m_135815_().equals("worldgen/template_pool/city_cars.json")) {
                    try {
                        String jsonContent = CITY_CARS_JSON;
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                        return () -> new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error creating ByteArrayInputStream for City.json", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                if (location.m_135815_().equals("worldgen/template_pool/city_houses.json")) {
                    try {
                        List<String> _houses = List.of("the_lost_city:base1", "the_lost_city:base0", "the_lost_city:police_station1", "the_lost_city:parking_e_1", "the_lost_city:base1", "the_lost_city:base0", "the_lost_city:base1", "the_lost_city:base0", "the_lost_city:greenhouse_r_2_0");
                        List<String> loadedBases = BuiltInResourcePack.loadBasesFromFiles(FMLPaths.GAMEDIR.get().toString() + File.separator + "berezka_plugins" + File.separator + "the_lost_city" + File.separator + "custom_bases");
                        String jsonContent = BuiltInResourcePack.createCityHousesJson(this.BasesList, _houses, loadedBases);
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                        return () -> new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error creating ByteArrayInputStream for worldgen/template_pool/city_houses.json", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                if (location.m_135815_().equals("worldgen/template_pool/city_small_houses.json")) {
                    try {
                        List<String> loadedHouses = BuiltInResourcePack.loadBasesFromFiles(FMLPaths.GAMEDIR.get().toString() + File.separator + "berezka_plugins" + File.separator + "the_lost_city" + File.separator + "custom_houses");
                        Set<String> blackList = Set.of("the_lost_city:none", "the_lost_city:none1");
                        ArrayList<? extends String> _housesList = null;
                        if (this.SpawnCity.booleanValue()) {
                            _housesList = new ArrayList<String>(this.HousesList);
                        }
                        String jsonContent = this.createCitySmallHousesJson(blackList, _housesList, loadedHouses);
                        ByteArrayInputStream inputStream = new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                        return () -> new ByteArrayInputStream(jsonContent.getBytes(StandardCharsets.UTF_8));
                    }
                    catch (Exception e) {
                        LOGGER.error("Error creating ByteArrayInputStream for worldgen/template_pool/city_houses.json", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            } else if (location.m_135827_().equals("berezka_api")) {
                String resourcePath = location.m_135815_();
                LOGGER.info("Path: " + resourcePath);
                if (resourcePath.startsWith("loot_tables/chests")) {
                    LOGGER.info("resourcePath startsWith loot_tables/chests: " + resourcePath);
                    String fileName = resourcePath.substring("loot_tables/chests".length());
                    LOGGER.info("filename: " + fileName);
                    String customFilePath = FMLPaths.GAMEDIR.get().toString() + File.separator + "berezka_plugins" + File.separator + "berezka_api" + File.separator + "lootData" + File.separator + fileName;
                    LOGGER.info("customFilePath: " + customFilePath);
                    File customFile = new File(customFilePath);
                    if (customFile.exists()) {
                        IoSupplier ioSupplier;
                        LOGGER.info("file exist: " + customFilePath);
                        FileInputStream fileInputStream = new FileInputStream(customFile);
                        try {
                            byte[] fileContent = ((InputStream)fileInputStream).readAllBytes();
                            ioSupplier = () -> new ByteArrayInputStream(fileContent);
                        }
                        catch (Throwable throwable) {
                            try {
                                try {
                                    ((InputStream)fileInputStream).close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (IOException e) {
                                LOGGER.error("Error reading file " + customFile.getPath(), (Throwable)e);
                                throw new RuntimeException(e);
                            }
                        }
                        ((InputStream)fileInputStream).close();
                        return ioSupplier;
                    }
                    LOGGER.info("file doesnot exist at: " + customFilePath);
                }
            }
        }
        LOGGER.info("returning null to: " + location.m_135815_() + " of " + location.m_135827_());
        return null;
    }

    public Set<String> m_5698_(PackType type) {
        return Set.of("the_lost_city", "berezka_api");
    }

    public <T> T m_5550_(MetadataSectionSerializer<T> serializer) {
        try {
            String metadataContent = PACK_METADATA;
            JsonElement jsonElement = JsonParser.parseString((String)metadataContent);
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Object section = serializer.m_6322_(jsonObject);
            return (T)section;
        }
        catch (Exception e) {
            LOGGER.error("Error reading metadata section", (Throwable)e);
            return null;
        }
    }

    public void m_8031_(PackType type, String namespace, String path, PackResources.ResourceOutput output) {
        block4: {
            block5: {
                block7: {
                    block6: {
                        LOGGER.info("listResources called with type: " + type + ", namespace: " + namespace + ", path: " + path);
                        if (type != PackType.SERVER_DATA) break block4;
                        if (!namespace.equals("the_lost_city")) break block5;
                        if (!path.equals("worldgen/structure_set")) break block6;
                        this.handleResource(output, "the_lost_city", "worldgen/structure_set/city.json");
                        break block4;
                    }
                    if (!path.equals("worldgen/structure")) break block7;
                    this.handleResource(output, "the_lost_city", "worldgen/structure/city.json");
                    break block4;
                }
                if (!path.equals("worldgen/template_pool")) break block4;
                if (!this.SpawnCars.booleanValue()) {
                    this.handleResource(output, "the_lost_city", "worldgen/template_pool/city_cars.json");
                }
                this.handleResource(output, "the_lost_city", "worldgen/template_pool/city_houses.json");
                this.handleResource(output, "the_lost_city", "worldgen/template_pool/city_small_houses.json");
                break block4;
            }
            if (namespace.equals("berezka_api") && path.equals("loot_tables")) {
                LOGGER.info("berezka api list resource loot_tables");
                List<String> lootData = BuiltInResourcePack.loadLootDataFiles(FMLPaths.GAMEDIR.get().toString() + File.separator + "berezka_plugins" + File.separator + "berezka_api" + File.separator + "lootData");
                if (lootData != null && !lootData.isEmpty()) {
                    LOGGER.info("loaded some loot data");
                    for (String item : lootData) {
                        this.handleResource(output, "berezka_api", "loot_tables/chests/" + item);
                    }
                }
            }
        }
    }

    private void handleResource(PackResources.ResourceOutput output, String namespace, String resourcePath) {
        try {
            ResourceLocation resourceLocation = new ResourceLocation(namespace, resourcePath);
            output.accept((Object)resourceLocation, () -> {
                try {
                    InputStream resource = (InputStream)this.m_214146_(PackType.SERVER_DATA, resourceLocation).m_247737_();
                    return resource;
                }
                catch (IOException e) {
                    LOGGER.error("Error getting resource for " + resourcePath, (Throwable)e);
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("Exception in listResources method for " + resourcePath, (Throwable)e);
        }
    }

    public void close() {
    }

    public String m_5542_() {
        return "berezka_structure_pack";
    }
}

