/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.berezkaapi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.ConfigValue<Boolean> doCitySpawn;
    public static final ForgeConfigSpec.ConfigValue<Integer> CitySpacing;
    public static final ForgeConfigSpec.ConfigValue<Integer> CitySeparation;
    public static final ForgeConfigSpec.ConfigValue<Boolean> SpawnCars;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> CityBiomeList;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> CityCustomHousesList;
    public static final ForgeConfigSpec.ConfigValue<List<? extends String>> CityCustomBasesList;
    private static final Map<String, Map<String, String>> translations;
    private static final Map<String, String> enTranslations;
    private static final Map<String, String> ruTranslations;
    private static final Map<String, String> deTranslations;

    private static String getTranslation(String key) {
        String languageCode = Minecraft.m_91087_().f_91066_.f_92075_;
        Map<String, String> selectedTranslations = translations.getOrDefault(languageCode, enTranslations);
        return selectedTranslations.getOrDefault(key, key);
    }

    static {
        translations = new HashMap<String, Map<String, String>>();
        enTranslations = new HashMap<String, String>();
        ruTranslations = new HashMap<String, String>();
        deTranslations = new HashMap<String, String>();
        enTranslations.put("description1", "Should city spawn?");
        enTranslations.put("description2", "Average distance between two neighboring generation attempts.");
        enTranslations.put("description3", "Minimum distance between two neighboring attempts.");
        enTranslations.put("description4", "Should Cars spawn?");
        enTranslations.put("description5", "Defines the list of biomes where cities can spawn.");
        enTranslations.put("description6", "Allows adding new houses to the city generation.");
        ruTranslations.put("description1", "\u0411\u0443\u0434\u0443\u0442 \u043b\u0438 \u043f\u043e\u044f\u0432\u043b\u044f\u0442\u044c\u0441\u044f \u0433\u043e\u0440\u043e\u0434\u0430 \u0432 \u043c\u0438\u0440\u0435.");
        ruTranslations.put("description2", "\u0421\u0440\u0435\u0434\u043d\u0435\u0435 \u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043c\u0435\u0436\u0434\u0443 \u0434\u0432\u0443\u043c\u044f \u0441\u043e\u0441\u0435\u0434\u043d\u0438\u043c\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0430\u043c\u0438 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u0438.");
        ruTranslations.put("description3", "\u041c\u0438\u043d\u0438\u043c\u0430\u043b\u044c\u043d\u043e\u0435 \u0440\u0430\u0441\u0441\u0442\u043e\u044f\u043d\u0438\u0435 \u043c\u0435\u0436\u0434\u0443 \u0434\u0432\u0443\u043c\u044f \u0441\u043e\u0441\u0435\u0434\u043d\u0438\u043c\u0438 \u043f\u043e\u043f\u044b\u0442\u043a\u0430\u043c\u0438.");
        ruTranslations.put("description4", "\u0411\u0443\u0434\u0443\u0442 \u043b\u0438 \u043f\u043e\u044f\u0432\u043b\u044f\u0442\u044c\u0441\u044f \u043c\u0430\u0448\u0438\u043d\u044b \u0432 \u0433\u043e\u0440\u043e\u0434\u0435.");
        ruTranslations.put("description5", "\u041e\u043f\u0440\u0435\u0434\u0435\u043b\u044f\u0435\u0442 \u0441\u043f\u0438\u0441\u043e\u043a \u0431\u0438\u043e\u043c\u043e\u0432, \u0432 \u043a\u043e\u0442\u043e\u0440\u044b\u0445 \u043c\u043e\u0433\u0443\u0442 \u0433\u0435\u043d\u0435\u0440\u0438\u0440\u043e\u0432\u0430\u0442\u044c\u0441\u044f \u0433\u043e\u0440\u043e\u0434\u0430.");
        ruTranslations.put("description6", "\u041f\u043e\u0437\u0432\u043e\u043b\u044f\u0435\u0442 \u0434\u043e\u0431\u0430\u0432\u043b\u044f\u0442\u044c \u043d\u043e\u0432\u044b\u0435 \u0434\u043e\u043c\u0430 \u0432 \u0433\u0435\u043d\u0435\u0440\u0430\u0446\u0438\u044e \u0433\u043e\u0440\u043e\u0434\u0430.");
        deTranslations.put("description1", "Werden St\u00e4dte in der Welt erscheinen?");
        deTranslations.put("description2", "Durchschnittliche Entfernung zwischen zwei aufeinander folgenden Generierungsversuchen.");
        deTranslations.put("description3", "Mindestabstand zwischen zwei aufeinander folgenden Versuchen.");
        deTranslations.put("description4", "Werden Autos in der Stadt erscheinen?");
        deTranslations.put("description5", "Definiert die Liste der Biome, in denen St\u00e4dte erscheinen k\u00f6nnen.");
        deTranslations.put("description6", "Erm\u00f6glicht das Hinzuf\u00fcgen neuer H\u00e4user zur Stadtgenerierung.");
        translations.put("en_us", enTranslations);
        translations.put("ru_ru", ruTranslations);
        translations.put("de_de", deTranslations);
        BUILDER.push("Spawn Config");
        ForgeConfigSpec.BooleanValue tempDoCitySpawn = null;
        ForgeConfigSpec.ConfigValue tempCitySpacing = null;
        ForgeConfigSpec.ConfigValue tempCitySeparation = null;
        ForgeConfigSpec.BooleanValue tempSpawnCars = null;
        ForgeConfigSpec.ConfigValue tempBiomeList = null;
        ForgeConfigSpec.ConfigValue tempCityCustomHousesList = null;
        ForgeConfigSpec.ConfigValue tempCityCustomBasesList = null;
        if (ModList.get().isLoaded("the_lost_city")) {
            BUILDER.push("The Lost City");
            tempDoCitySpawn = BUILDER.comment(Config.getTranslation("description1")).define("Spawn City", true);
            tempCitySpacing = BUILDER.comment(Config.getTranslation("description2")).define("City Spacing", (Object)34);
            tempCitySeparation = BUILDER.comment(Config.getTranslation("description3")).define("City Separation", (Object)8);
            tempSpawnCars = BUILDER.comment(Config.getTranslation("description4")).define("Spawn Cars", true);
            tempBiomeList = BUILDER.comment(Config.getTranslation("description5")).defineList("Biomes", Arrays.asList("plains", "snowy_plains", "sunflower_plains"), obj -> obj instanceof String);
            tempCityCustomHousesList = BUILDER.comment(Config.getTranslation("description6")).defineList("Houses", Arrays.asList(new String[0]), obj1 -> obj1 instanceof String);
            tempCityCustomBasesList = BUILDER.comment(Config.getTranslation("description6")).defineList("Bases", Arrays.asList(new String[0]), obj2 -> obj2 instanceof String);
            BUILDER.pop();
        }
        doCitySpawn = tempDoCitySpawn;
        CitySpacing = tempCitySpacing;
        CitySeparation = tempCitySeparation;
        SpawnCars = tempSpawnCars;
        CityBiomeList = tempBiomeList;
        CityCustomHousesList = tempCityCustomHousesList;
        CityCustomBasesList = tempCityCustomBasesList;
        SPEC = BUILDER.build();
    }
}

