/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.berezkaapi;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.mcreator.berezkaapi.BerezkaApiMod;
import net.mcreator.berezkaapi.Config;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="berezka_api", bus=Mod.EventBusSubscriber.Bus.MOD)
public class RegisterConfig {
    public static final Logger LOGGER = LogManager.getLogger(BerezkaApiMod.class);

    public RegisterConfig() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public static void register(FMLConstructModEvent event) {
        event.enqueueWork(() -> {
            ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC, "BerezkaLibraryConfig.toml");
            Path optionsPath = Paths.get(FMLPaths.GAMEDIR.get().toString(), "minecraftinstance.json");
            try {
                Object content = new String(Files.readAllBytes(optionsPath));
                if (!((String)content).contains("resourcePacks:[")) {
                    content = (String)content + "\nresourcePacks:[\"berezka_resources.zip\"]";
                } else if (!((String)content).contains("\"berezka_resources.zip\"")) {
                    content = ((String)content).replace("resourcePacks:[", "resourcePacks:[\"berezka_resources.zip\", ");
                }
                Files.write(optionsPath, ((String)content).getBytes(), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    public static void registerConfig(FMLConstructModEvent event, String mod_id) {
        event.enqueueWork(() -> ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC, String.format("%s.toml", mod_id)));
    }
}

