/*
 * Decompiled with CFR 0.152.
 */
package org.berezka.berezka_api.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.berezka.berezka_api.BerezkaStructures;
import org.berezka.berezka_api.Berezka_api;
import org.berezka.berezka_api.berezka_api_main;
import org.berezka.berezka_api.structures.BerezkasJigsawPlacement;
import org.slf4j.Logger;

public class BerezkaStructureExtra
extends Structure {
    public static ConcurrentHashMap StructuresIDList = new ConcurrentHashMap();
    public static ConcurrentHashMap<ChunkPos, String> TERRAIN_CACHE = new ConcurrentHashMap();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<BerezkaStructureExtra> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BerezkaStructureExtra.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.STRING.optionalFieldOf("banned_tags").forGetter(structure -> structure.disabledTags), (App)Codec.intRange((int)1, (int)1000).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)0, (int)180).optionalFieldOf("structure_rotation").forGetter(structure -> structure.structrure_rotation), (App)Codec.intRange((int)1, (int)1000).optionalFieldOf("structure_space").forGetter(structure -> structure.structure_space), (App)Codec.BOOL.optionalFieldOf("do_extra_checks").forGetter(structure -> structure.doExtraChecks), (App)Codec.BOOL.optionalFieldOf("check_for_structures").forGetter(structure -> structure.checkForStructures), (App)Codec.BOOL.optionalFieldOf("allow_custom_checks").forGetter(structure -> structure.allowCustomChecks)).apply((Applicative)instance, BerezkaStructureExtra::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final Optional<Integer> structrure_rotation;
    private final Optional<Integer> structure_space;
    private final Optional<Boolean> doExtraChecks;
    private final Optional<Boolean> allowCustomChecks;
    private final Optional<Boolean> checkForStructures;
    private final Optional<String> disabledTags;

    public BerezkaStructureExtra(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, Optional<String> disabledTags, int maxDistanceFromCenter, Optional<Integer> structrure_rotation, Optional<Integer> structure_space, Optional<Boolean> doExtraChecks, Optional<Boolean> checkForStructures, Optional<Boolean> allowCustomChecks) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.structrure_rotation = structrure_rotation;
        this.structure_space = structure_space;
        this.doExtraChecks = doExtraChecks;
        this.allowCustomChecks = allowCustomChecks;
        this.checkForStructures = checkForStructures;
        this.disabledTags = disabledTags;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean extraSpawningChecks(Structure.GenerationContext context, BerezkaStructureExtra data, BlockPos blockPos) {
        block16: {
            chunkpos = context.f_226628_();
            if (Berezka_api.debug_mode) {
                BerezkaStructureExtra.LOGGER.info("[Berezka API] extraSpawningChecks called at {}.", (Object)chunkpos.m_45615_());
            }
            if ((world = berezka_api_main.getCurWorld()) == null) {
                if (Berezka_api.debug_mode) {
                    BerezkaStructureExtra.LOGGER.info("[Berezka API] extraSpawningChecks warn: world is null, returning false.");
                }
                return false;
            }
            occupiedYPos = context.f_226622_().m_223235_(chunkpos.m_45604_(), chunkpos.m_45605_(), Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), context.f_226624_());
            columnOfBlocks = context.f_226622_().m_214184_(chunkpos.m_151382_(0), chunkpos.m_151391_(0), context.f_226629_(), context.f_226624_());
            blockState = columnOfBlocks.m_183556_(occupiedYPos);
            v0 = heightCheck = occupiedYPos < 100;
            if (!heightCheck) {
                if (Berezka_api.debug_mode) {
                    BerezkaStructureExtra.LOGGER.info("[Berezka API] extraSpawningChecks info: returning: false (heightCheck = false)");
                }
                return false;
            }
            v1 = airCheck = blockState.m_60795_() == false;
            if (!airCheck) {
                if (Berezka_api.debug_mode) {
                    BerezkaStructureExtra.LOGGER.info("[Berezka API] extraSpawningChecks info: returning: false (airCheck = false)");
                }
                return false;
            }
            v2 = waterCheck = blockState.m_60819_().m_205070_(FluidTags.f_13131_) == false;
            if (!waterCheck) {
                if (Berezka_api.debug_mode) {
                    BerezkaStructureExtra.LOGGER.info("[Berezka API] extraSpawningChecks info: returning: false (waterCheck = false)");
                }
                return false;
            }
            terrainCheck = BerezkaStructureExtra.isValidTerrainForSpawn(world, chunkpos, data);
            if (!terrainCheck) {
                if (Berezka_api.debug_mode) {
                    BerezkaStructureExtra.LOGGER.info("[Berezka API] extraSpawningChecks info: returning: false (terrainCheck = false)");
                }
                return false;
            }
            if (!Berezka_api.debug_mode) break block16;
            v3 = chunkpos.m_45615_();
            if (!BerezkaStructureExtra.TERRAIN_CACHE.getOrDefault(chunkpos, "not found").equals("not found")) ** GOTO lbl-1000
            if (!BerezkaStructureExtra.TERRAIN_CACHE.getOrDefault(chunkpos, "not found").equals(BerezkaStructureExtra.getValueFromPool(data.startPool))) {
                v4 = true;
            } else lbl-1000:
            // 2 sources

            {
                v4 = false;
            }
            BerezkaStructureExtra.LOGGER.info("[Berezka API] checking {} for structures, chunk has any structures: {}.", (Object)v3, (Object)v4);
        }
        if (BerezkaStructureExtra.TERRAIN_CACHE.containsKey(chunkpos)) {
            if (!BerezkaStructureExtra.TERRAIN_CACHE.getOrDefault(chunkpos, "not found").equals(BerezkaStructureExtra.getValueFromPool(data.startPool))) {
                return false;
            }
        }
        if (Berezka_api.debug_mode) {
            BerezkaStructureExtra.LOGGER.info("[Berezka API] extraSpawningChecks info: returning: true");
        }
        return true;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.f_226628_();
        if (!StructuresIDList.contains(BerezkaStructureExtra.getValueFromPool(this.startPool))) {
            StructuresIDList.put(BerezkaStructureExtra.getValueFromPool(this.startPool), StructuresIDList.size() + 1);
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] adding new structure {} to StructuresIDList, new list: {}", (Object)BerezkaStructureExtra.getValueFromPool(this.startPool), (Object)StructuresIDList);
            }
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] CACHE: {}, current pos: {} {}, contains chunk: {}, value: {} ({})", new Object[]{TERRAIN_CACHE, chunkPos, chunkPos.m_45615_(), TERRAIN_CACHE.containsKey(chunkPos), TERRAIN_CACHE.getOrDefault(chunkPos, "not found")});
        }
        boolean manual = BerezkaStructureExtra.isManualPlacement();
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] findGenerationPoint called. (Manual: %s)".formatted(manual));
        }
        ServerLevel world = berezka_api_main.getCurWorld();
        BlockPos centerPos = chunkPos.m_151394_(world.m_5736_());
        int rotation = 0;
        Optional<Integer> optionalRotation = this.structrure_rotation;
        if (optionalRotation.isPresent()) {
            rotation = optionalRotation.get();
        }
        if (world == null) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] findGenerationPoint warn: world is null, returning Optional.empty().");
            }
            return Optional.empty();
        }
        if (!world.m_46739_(centerPos)) {
            LOGGER.info("[Berezka API] findGenerationPoint centerPos is out of World bounds.");
            return Optional.empty();
        }
        Rotation _rotation = Rotation.NONE;
        if (rotation >= 90 && rotation < 180) {
            _rotation = Rotation.CLOCKWISE_90;
        } else if (rotation >= 180 && rotation < 270) {
            _rotation = Rotation.CLOCKWISE_180;
        } else if (rotation >= 270) {
            _rotation = Rotation.COUNTERCLOCKWISE_90;
        }
        if (manual) {
            int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
            BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
            Optional<Structure.GenerationStub> structurePiecesGenerator = BerezkasJigsawPlacement.addPieces(context, this.startPool, this.startJigsawName, this.size, blockPos, false, this.projectStartToHeightmap, this.maxDistanceFromCenter, _rotation, optionalRotation.isPresent(), chunkPos, this.structure_space.orElse(berezka_api_main.defaultStructuresSpace), true);
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] Spawning structure with command and without any checks.");
            }
            return structurePiecesGenerator;
        }
        if (TERRAIN_CACHE.containsKey(chunkPos) && !TERRAIN_CACHE.get(chunkPos).equals(BerezkaStructureExtra.getValueFromPool(this.startPool))) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] Structure {} can't be spawned in {}, because it already contains: {}", new Object[]{BerezkaStructureExtra.getValueFromPool(this.startPool), chunkPos.m_45615_(), TERRAIN_CACHE.get(chunkPos)});
            }
            return Optional.empty();
        }
        boolean extraCheck = true;
        int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos chunkToBlock = chunkPos.m_45615_();
        BlockPos blockPos = new BlockPos(chunkToBlock.m_123341_(), startY, chunkToBlock.m_123343_());
        if (this.allowCustomChecks.orElse(berezka_api_main.defaultDoExtraChecksValue).booleanValue()) {
            extraCheck = berezka_api_main.checkChunk(context);
        }
        if (this.doExtraChecks.orElse(true).booleanValue() && !BerezkaStructureExtra.extraSpawningChecks(context, this, blockPos) || !extraCheck) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] findGenerationPoint warn: extraSpawningCheck || isValidTerrainForSpawn returned false, returning Optional.empty().");
            }
            return Optional.empty();
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] Structure rotation: " + String.valueOf(_rotation) + "(original:" + rotation + ").");
        }
        Optional<Structure.GenerationStub> structurePiecesGenerator = BerezkasJigsawPlacement.addPieces(context, this.startPool, this.startJigsawName, this.size, blockPos, false, this.projectStartToHeightmap, this.maxDistanceFromCenter, _rotation, optionalRotation.isPresent(), chunkPos, this.structure_space.orElse(berezka_api_main.defaultStructuresSpace), false);
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] findGenerationPoint info: returning structurePiecesGenerator. (data: pos:" + String.valueOf(blockPos) + ", pool:" + BerezkaStructureExtra.getValueFromPool(this.startPool) + ", rotation: " + rotation + ", rotation isPreset?: " + optionalRotation.isPresent() + ")");
        }
        LOGGER.info("[Berezka API] spawning structure %s at %s".formatted(BerezkaStructureExtra.getValueFromPool(this.startPool), chunkPos.m_45615_()));
        return structurePiecesGenerator;
    }

    /*
     * Unable to fully structure code
     */
    public static Boolean isValidTerrainForSpawn(ServerLevel world, ChunkPos chunkPos, BerezkaStructureExtra data) {
        block5: {
            block6: {
                if (Berezka_api.debug_mode) {
                    BerezkaStructureExtra.LOGGER.info("[Berezka API] isValidTerrainForSpawn called. (ChunkPos:%s, World: %s)".formatted(new Object[]{chunkPos, world}));
                }
                if (!BerezkaStructureExtra.TERRAIN_CACHE.contains(chunkPos)) break block5;
                if (!Berezka_api.debug_mode) break block6;
                v0 = new Object[1];
                if (BerezkaStructureExtra.TERRAIN_CACHE.get(chunkPos).equals("0")) ** GOTO lbl-1000
                if (BerezkaStructureExtra.TERRAIN_CACHE.get(chunkPos).equals(BerezkaStructureExtra.getValueFromPool(data.startPool))) lbl-1000:
                // 2 sources

                {
                    v1 = true;
                } else {
                    v1 = false;
                }
                v0[0] = v1;
                BerezkaStructureExtra.LOGGER.info("[Berezka API] isValidTerrainForSpawn info: returning cached value: %s.".formatted(v0));
            }
            if (BerezkaStructureExtra.TERRAIN_CACHE.get(chunkPos).equals("0")) ** GOTO lbl-1000
            if (BerezkaStructureExtra.TERRAIN_CACHE.get(chunkPos).equals(BerezkaStructureExtra.getValueFromPool(data.startPool))) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            return v2;
        }
        return true;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)BerezkaStructures.BEREZKA_STRUCTURES_EXTRA.get();
    }

    public static boolean isManualPlacement() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().contains("PlaceCommand") && !element.getMethodName().contains("place")) continue;
            return true;
        }
        return false;
    }

    public void saveChunkInCache(ChunkPos chunk, String value) {
        if (TERRAIN_CACHE.size() > 1000 && Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] cache is full.");
        }
        TERRAIN_CACHE.put(chunk, value);
    }

    public static String getValueFromPool(Holder<StructureTemplatePool> poolHolder) {
        return poolHolder.m_203543_().map(key -> key.m_135782_()).orElse(new ResourceLocation("unknown", "unregistered_pool")).toString();
    }
}

