/*
 * Decompiled with CFR 0.152.
 */
package org.berezka.berezka_api.structures;

import com.mojang.logging.LogUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.EmptyPoolElement;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.berezka.berezka_api.Berezka_api;
import org.berezka.berezka_api.structures.BerezkaStructureExtra;
import org.slf4j.Logger;

public class BerezkasJigsawPlacement {
    public static final Logger LOGGER = LogUtils.getLogger();

    public static Optional<Structure.GenerationStub> addPieces(Structure.GenerationContext context, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, BlockPos blockPos, boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, Rotation rotation, boolean useCustomRotation, ChunkPos chunkPos, int radius, boolean manual) {
        if (size == 1) {
            StructureTemplatePool pool = (StructureTemplatePool)startPool.m_203334_();
            if (pool.m_210590_() == 0) {
                LOGGER.error("[Berezka API] pool {} is empty!", (Object)BerezkaStructureExtra.getValueFromPool(startPool));
                return Optional.empty();
            }
            StructurePoolElement element = pool.m_227355_((RandomSource)context.f_226626_());
            if (element == EmptyPoolElement.f_210175_) {
                LOGGER.error("[Berezka API] pool {} contains empty element!", (Object)BerezkaStructureExtra.getValueFromPool(startPool));
                return Optional.empty();
            }
            BoundingBox _box = element.m_214015_(context.f_226625_(), blockPos, rotation);
            if (Berezka_api.debug_mode) {
                Berezka_api.LOGGER.info("[Berezka API] boundingBox data:{minX:%s, maxX:%s, minY:%s, maxY:%s. minZ:%s, maxZ:%s, size:%s}".formatted(_box.m_162395_(), _box.m_162399_(), _box.m_162396_(), _box.m_162400_(), _box.m_162398_(), _box.m_162401_(), size));
            }
            if (!manual) {
                if (BerezkaStructureExtra.TERRAIN_CACHE.containsKey(chunkPos)) {
                    LOGGER.info("[Berezka API] CACHE chunk {} is already in cache, value: {}", (Object)chunkPos, (Object)BerezkaStructureExtra.TERRAIN_CACHE.get(chunkPos));
                } else {
                    LOGGER.info("[Berezka API] there is no CACHE for {}", (Object)chunkPos.m_45615_());
                }
                BerezkaStructureExtra.TERRAIN_CACHE.put(chunkPos, BerezkaStructureExtra.getValueFromPool(startPool));
                int minX = _box.m_162395_();
                int minZ = _box.m_162398_();
                int maxX = _box.m_162399_();
                int maxZ = _box.m_162401_();
                int chunkMinX = minX >> 4;
                int chunkMaxX = maxX >> 4;
                int chunkMinZ = minZ >> 4;
                int chunkMaxZ = maxZ >> 4;
                for (int cx = chunkMinX; cx <= chunkMaxX; ++cx) {
                    for (int cz = chunkMinZ; cz <= chunkMaxZ; ++cz) {
                        ChunkPos pos = new ChunkPos(cx, cz);
                        if (Berezka_api.debug_mode) {
                            LOGGER.info("[Berezka API] adding {} ({}) to cache.", (Object)pos, (Object)pos.m_45615_());
                        }
                        BerezkaStructureExtra.TERRAIN_CACHE.put(pos, BerezkaStructureExtra.getValueFromPool(startPool));
                    }
                }
            }
            PoolElementStructurePiece startPiece = new PoolElementStructurePiece(context.f_226625_(), element, blockPos, element.m_210540_(), rotation, _box);
            BoundingBox box = startPiece.m_73547_();
            int centerX = (box.m_162395_() + box.m_162399_()) / 2;
            int centerZ = (box.m_162398_() + box.m_162401_()) / 2;
            int centerY = blockPos.m_123342_();
            if (projectStartToHeightmap.isPresent()) {
                centerY = context.f_226622_().m_223221_(centerX, centerZ, projectStartToHeightmap.get(), context.f_226629_(), context.f_226624_());
                int yOffset = box.m_162396_() + startPiece.m_72647_();
                startPiece.m_6324_(0, centerY - yOffset, 0);
            }
            BlockPos genPos = new BlockPos(centerX, centerY, centerZ);
            if (Berezka_api.debug_mode) {
                Berezka_api.LOGGER.info("[Berezka API] Jigsaw: placing structure {}. pos:{}", (Object)BerezkaStructureExtra.getValueFromPool(startPool), (Object)blockPos);
            }
            return Optional.of(new Structure.GenerationStub(genPos, builder -> {
                builder.m_142679_((StructurePiece)startPiece);
                BerezkasJigsawPlacement.addPieces(context, startPool, startJigsawName, size, blockPos, false, projectStartToHeightmap, maxDistanceFromCenter, Rotation.NONE, false, new ChunkPos(genPos), radius, manual);
            }));
        }
        BerezkaStructureExtra.TERRAIN_CACHE.put(chunkPos, BerezkaStructureExtra.getValueFromPool(startPool));
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, startPool, startJigsawName, (int)size, (BlockPos)blockPos, (boolean)useExpansionHack, projectStartToHeightmap, (int)maxDistanceFromCenter);
    }

    private static BoundingBox expandBoundingBox(BoundingBox original, int expansion) {
        return new BoundingBox(original.m_162395_() - expansion, original.m_162396_() - expansion, original.m_162398_() - expansion, original.m_162399_() + expansion, original.m_162400_() + expansion, original.m_162401_() + expansion);
    }
}

