/*
 * Decompiled with CFR 0.152.
 */
package org.berezka.berezka_api.structures;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import org.berezka.berezka_api.BerezkaStructures;
import org.berezka.berezka_api.Berezka_api;
import org.berezka.berezka_api.berezka_api_main;
import org.slf4j.Logger;

public class BerezkaStructureExtra
extends Structure {
    public static ConcurrentHashMap StructuresIDList = new ConcurrentHashMap();
    public static ConcurrentHashMap<String, Rotation> StructuresRotations = new ConcurrentHashMap();
    public static ConcurrentHashMap<ChunkPos, String> TERRAIN_CACHE = new ConcurrentHashMap();
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<BerezkaStructureExtra> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BerezkaStructureExtra.m_226567_((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)30).fieldOf("size").forGetter(structure -> structure.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.STRING.optionalFieldOf("banned_tags").forGetter(structure -> structure.disabledTags), (App)Codec.intRange((int)1, (int)1000).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)0, (int)180).optionalFieldOf("structure_rotation").forGetter(structure -> structure.structrure_rotation), (App)Codec.BOOL.optionalFieldOf("do_extra_checks").forGetter(structure -> structure.doExtraChecks), (App)Codec.BOOL.optionalFieldOf("only_flat_terrain").forGetter(structure -> structure.onlyFlatTerrain), (App)Codec.BOOL.optionalFieldOf("check_for_structures").forGetter(structure -> structure.checkForStructures), (App)Codec.BOOL.optionalFieldOf("allow_custom_checks").forGetter(structure -> structure.allowCustomChecks)).apply((Applicative)instance, BerezkaStructureExtra::new));
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int size;
    private final HeightProvider startHeight;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final Optional<Integer> structrure_rotation;
    private final Optional<Boolean> doExtraChecks;
    private final Optional<Boolean> allowCustomChecks;
    private final Optional<Boolean> checkForStructures;
    private final Optional<Boolean> onlyFlatTerrain;
    private final Optional<String> disabledTags;

    public BerezkaStructureExtra(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Optional<Heightmap.Types> projectStartToHeightmap, Optional<String> disabledTags, int maxDistanceFromCenter, Optional<Integer> structrure_rotation, Optional<Boolean> doExtraChecks, Optional<Boolean> checkForStructures, Optional<Boolean> onlyFlatTerrain, Optional<Boolean> allowCustomChecks) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.structrure_rotation = structrure_rotation;
        this.doExtraChecks = doExtraChecks;
        this.allowCustomChecks = allowCustomChecks;
        this.checkForStructures = checkForStructures;
        this.onlyFlatTerrain = onlyFlatTerrain;
        this.disabledTags = disabledTags;
    }

    private static boolean extraSpawningChecks(Structure.GenerationContext context, BerezkaStructureExtra data, BlockPos blockPos, Heightmap.Types projectStartToHeightmap) {
        boolean waterCheck;
        boolean airCheck;
        boolean heightCheck;
        ServerLevel world;
        ChunkPos chunkpos = context.f_226628_();
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] extraSpawningChecks called at {}.", (Object)chunkpos.m_45615_());
        }
        if ((world = berezka_api_main.getCurWorld()) == null) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] extraSpawningChecks warn: world is null, returning false.");
            }
            return false;
        }
        int occupiedYPos = context.f_226622_().m_223235_(chunkpos.m_45604_(), chunkpos.m_45605_(), projectStartToHeightmap, context.f_226629_(), context.f_226624_());
        NoiseColumn columnOfBlocks = context.f_226622_().m_214184_(chunkpos.m_151382_(0), chunkpos.m_151391_(0), context.f_226629_(), context.f_226624_());
        BlockState blockState = columnOfBlocks.m_183556_(occupiedYPos);
        boolean bl = heightCheck = occupiedYPos < 100;
        if (!heightCheck) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] extraSpawningChecks info: returning: false (heightCheck = false)");
            }
            return false;
        }
        boolean bl2 = airCheck = !blockState.m_60795_();
        if (!airCheck) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] extraSpawningChecks info: returning: false (airCheck = false)");
            }
            return false;
        }
        boolean bl3 = waterCheck = !blockState.m_60819_().m_205070_(FluidTags.f_13131_);
        if (!waterCheck) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] extraSpawningChecks info: returning: false (waterCheck = false)");
            }
            return false;
        }
        boolean terrainCheck = BerezkaStructureExtra.isValidTerrainForSpawn(world, chunkpos, data);
        if (!terrainCheck) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] extraSpawningChecks info: returning: false (terrainCheck = false)");
            }
            return false;
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] checking {} for structures, chunk has any structures: {}.", (Object)chunkpos.m_45615_(), (Object)(TERRAIN_CACHE.containsKey(chunkpos) && !TERRAIN_CACHE.get(chunkpos).equals(BerezkaStructureExtra.getValueFromPool(data.startPool)) ? 1 : 0));
        }
        if (TERRAIN_CACHE.containsKey(chunkpos) && !TERRAIN_CACHE.get(chunkpos).equals(BerezkaStructureExtra.getValueFromPool(data.startPool))) {
            return false;
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] extraSpawningChecks info: returning: true");
        }
        return true;
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        Optional structurePiecesGenerator;
        ChunkPos chunkPos = context.f_226628_();
        String structureId = BerezkaStructureExtra.getValueFromPool(this.startPool);
        if (!StructuresIDList.contains(BerezkaStructureExtra.getValueFromPool(this.startPool))) {
            StructuresIDList.put(BerezkaStructureExtra.getValueFromPool(this.startPool), StructuresIDList.size() + 1);
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] adding new structure {} to StructuresIDList, new list: {}", (Object)BerezkaStructureExtra.getValueFromPool(this.startPool), (Object)StructuresIDList);
            }
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] CACHE: {}, current pos: {} {}, contains chunk: {}, value: {}", new Object[]{TERRAIN_CACHE, chunkPos, chunkPos.m_45615_(), TERRAIN_CACHE.containsKey(chunkPos), TERRAIN_CACHE.getOrDefault(chunkPos, "not found")});
        }
        boolean manual = BerezkaStructureExtra.isManualPlacement();
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] findGenerationPoint called. (Manual: %s)".formatted(manual));
        }
        ServerLevel world = berezka_api_main.getCurWorld();
        int rotation = 0;
        Optional<Integer> optionalRotation = this.structrure_rotation;
        if (optionalRotation.isPresent()) {
            rotation = optionalRotation.get();
        }
        if (world == null) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] findGenerationPoint warn: world is null, returning Optional.empty().");
            }
            return Optional.empty();
        }
        BlockPos centerPos = chunkPos.m_151394_(world.m_5736_());
        if (!world.m_46739_(centerPos)) {
            LOGGER.info("[Berezka API] findGenerationPoint centerPos is out of World bounds.");
            return Optional.empty();
        }
        Rotation _rotation = Rotation.NONE;
        if (rotation >= 90 && rotation < 180) {
            _rotation = Rotation.CLOCKWISE_90;
        } else if (rotation >= 180 && rotation < 270) {
            _rotation = Rotation.CLOCKWISE_180;
        } else if (rotation >= 270) {
            _rotation = Rotation.COUNTERCLOCKWISE_90;
        }
        if (!StructuresRotations.containsKey(structureId) && optionalRotation.isPresent()) {
            StructuresRotations.put(structureId, _rotation);
        }
        if (manual) {
            int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
            BlockPos blockPos = new BlockPos(chunkPos.m_45604_(), startY, chunkPos.m_45605_());
            Optional structurePiecesGenerator2 = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] Spawning structure with command and without any checks.");
            }
            return structurePiecesGenerator2;
        }
        if (TERRAIN_CACHE.containsKey(chunkPos) && !TERRAIN_CACHE.get(chunkPos).equals(BerezkaStructureExtra.getValueFromPool(this.startPool))) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] Structure {} can't be spawned in {}, because it already contains: {}", new Object[]{BerezkaStructureExtra.getValueFromPool(this.startPool), chunkPos.m_45615_(), TERRAIN_CACHE.get(chunkPos)});
            }
            return Optional.empty();
        }
        boolean extraCheck = true;
        int startY = this.startHeight.m_213859_((RandomSource)context.f_226626_(), new WorldGenerationContext(context.f_226622_(), context.f_226629_()));
        BlockPos chunkToBlock = chunkPos.m_45615_();
        BlockPos blockPos = new BlockPos(chunkToBlock.m_123341_(), startY, chunkToBlock.m_123343_());
        if (this.allowCustomChecks.orElse(berezka_api_main.defaultDoExtraChecksValue).booleanValue()) {
            extraCheck = berezka_api_main.checkChunk(context);
        }
        if (this.doExtraChecks.orElse(true).booleanValue() && !BerezkaStructureExtra.extraSpawningChecks(context, this, blockPos, this.projectStartToHeightmap.orElse(Heightmap.Types.OCEAN_FLOOR_WG)) || !extraCheck) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] findGenerationPoint warn: extraSpawningCheck || isValidTerrainForSpawn returned false, returning Optional.empty().");
            }
            return Optional.empty();
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] Structure rotation: " + String.valueOf(_rotation) + "(original:" + rotation + ").");
        }
        if ((structurePiecesGenerator = JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter)).isEmpty()) {
            return Optional.empty();
        }
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] findGenerationPoint info: returning structurePiecesGenerator. (data: pos:" + String.valueOf(blockPos) + ", pool:" + BerezkaStructureExtra.getValueFromPool(this.startPool) + ", rotation: " + rotation + ", rotation isPreset?: " + optionalRotation.isPresent() + ")");
            LOGGER.info("[Berezka API] spawning structure %s at %s".formatted(BerezkaStructureExtra.getValueFromPool(this.startPool), chunkPos.m_45615_()));
        }
        Structure.GenerationStub stub = (Structure.GenerationStub)structurePiecesGenerator.get();
        BlockPos genPos = stub.f_226669_();
        Consumer originalConsumer = (Consumer)stub.f_226670_().left().get();
        Optional<Structure.GenerationStub> result = this.getGenerationStub(genPos, originalConsumer, structureId);
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] returning result.");
        }
        return result;
    }

    private Optional<Structure.GenerationStub> getGenerationStub(BlockPos genPos, Consumer<StructurePiecesBuilder> originalConsumer, String structureId) {
        Structure.GenerationStub newStub = new Structure.GenerationStub(genPos, builder -> {
            final ArrayList recordedPieces = new ArrayList();
            StructurePiecesBuilder proxyBuilder = new StructurePiecesBuilder((StructurePiecesBuilder)builder){
                final /* synthetic */ StructurePiecesBuilder val$builder;
                {
                    this.val$builder = structurePiecesBuilder;
                }

                public void m_142679_(StructurePiece piece) {
                    recordedPieces.add(piece);
                    this.val$builder.m_142679_(piece);
                }
            };
            originalConsumer.accept(proxyBuilder);
            for (StructurePiece piece : recordedPieces) {
                BoundingBox box = piece.m_73547_();
                int minChunkX = box.m_162395_() >> 4;
                int maxChunkX = box.m_162399_() >> 4;
                int minChunkZ = box.m_162398_() >> 4;
                int maxChunkZ = box.m_162401_() >> 4;
                for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
                    for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                        ChunkPos chunkpos = new ChunkPos(cx, cz);
                        boolean contains = TERRAIN_CACHE.containsKey(chunkpos);
                        boolean same = TERRAIN_CACHE.getOrDefault(chunkpos, "not found").equals(structureId);
                        if (!contains) {
                            if (Berezka_api.debug_mode) {
                                LOGGER.info("[Berezka API] adding chunk {} to cache with value {}", (Object)chunkpos.m_45615_(), (Object)BerezkaStructureExtra.getValueFromPool(this.startPool));
                            }
                            BerezkaStructureExtra.saveChunkInCache(chunkpos, structureId);
                            continue;
                        }
                        if (Berezka_api.debug_mode) {
                            LOGGER.info("[Berezka API] chunk: {} in cache: {}, same: {} ({} {} {})", new Object[]{chunkpos.m_45615_(), contains, same, structureId, same ? "==" : "!=", TERRAIN_CACHE.getOrDefault(chunkpos, "not found")});
                        }
                        if (same) continue;
                        LOGGER.warn("[Berezka API] structure {} at {} is spawned inside other structure {}, trying to destroy structure...", new Object[]{structureId, genPos, TERRAIN_CACHE.getOrDefault(chunkpos, "not found")});
                        BlockPos pos = piece.m_142171_();
                        BlockPos newPos = new BlockPos(pos.m_123341_(), pos.m_123342_() + 500, pos.m_123343_());
                        piece.m_6324_(newPos.m_123341_(), newPos.m_123342_(), newPos.m_123343_());
                        LOGGER.info("[Berezka API] structure {} at {} was removed.", (Object)structureId, (Object)genPos);
                        return;
                    }
                }
            }
        });
        Optional<Structure.GenerationStub> result = Optional.of(newStub);
        return result;
    }

    public static Boolean isValidTerrainForSpawn(ServerLevel world, ChunkPos chunkPos, BerezkaStructureExtra data) {
        if (Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] isValidTerrainForSpawn called. (ChunkPos:%s, World: %s)".formatted(chunkPos, world));
        }
        if (TERRAIN_CACHE.containsKey(chunkPos)) {
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] isValidTerrainForSpawn info: returning cached value: %s.".formatted(TERRAIN_CACHE.get(chunkPos).equals("0") || TERRAIN_CACHE.get(chunkPos).equals(BerezkaStructureExtra.getValueFromPool(data.startPool))));
            }
            return TERRAIN_CACHE.get(chunkPos).equals("0") || TERRAIN_CACHE.get(chunkPos).equals(BerezkaStructureExtra.getValueFromPool(data.startPool));
        }
        return true;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)BerezkaStructures.BEREZKA_STRUCTURES_EXTRA.get();
    }

    public static boolean isManualPlacement() {
        StackTraceElement[] stackTrace;
        for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().contains("PlaceCommand") && !element.getMethodName().contains("place")) continue;
            return true;
        }
        return false;
    }

    public static void saveChunkInCache(ChunkPos chunk, String value) {
        if (TERRAIN_CACHE.size() > 1000 && Berezka_api.debug_mode) {
            LOGGER.info("[Berezka API] cache is full. calling clearCache()");
            BerezkaStructureExtra.clearCache();
        }
        TERRAIN_CACHE.put(chunk, value);
    }

    public static void clearCache() {
        ArrayList<ChunkPos> chunks = Collections.list(TERRAIN_CACHE.keys());
        for (ChunkPos chunk : chunks) {
            if (berezka_api_main.getCurWorld().m_46749_(chunk.m_45615_())) continue;
            if (Berezka_api.debug_mode) {
                LOGGER.info("[Berezka API] removing {} from cache.", (Object)chunk.m_45615_());
            }
            TERRAIN_CACHE.remove(chunk);
        }
        chunks.clear();
    }

    public static Boolean boxContainsStructures(BoundingBox box, String structureID) {
        int minChunkX = box.m_162395_() >> 4;
        int maxChunkX = box.m_162399_() >> 4;
        int minChunkZ = box.m_162398_() >> 4;
        int maxChunkZ = box.m_162401_() >> 4;
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                ChunkPos chunkpos = new ChunkPos(cx, cz);
                boolean contains = TERRAIN_CACHE.containsKey(chunkpos);
                boolean same = TERRAIN_CACHE.getOrDefault(chunkpos, "not found").equals(structureID);
                if (!contains || same) continue;
                return true;
            }
        }
        return false;
    }

    public static String getValueFromPool(Holder<StructureTemplatePool> poolHolder) {
        return poolHolder.m_203543_().map(key -> key.m_135782_()).orElse(new ResourceLocation("unknown", "unregistered_pool")).toString();
    }

    public static Rotation getRotationOfStructure(Structure.GenerationContext context, String id) {
        return StructuresRotations.getOrDefault(id, Rotation.m_221990_((RandomSource)context.f_226626_()));
    }
}

