/*
 * Decompiled with CFR 0.152.
 */
package de.zkinqjustin.itemClear;

import de.zkinqjustin.itemClear.commands.ItemClearCommand;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ItemClear
extends JavaPlugin {
    private int clearInterval;
    private String clearMessage;
    private String warningMessage;
    private int warningTime;
    private String commandSuccessMessage;
    private String commandBroadcastMessage;
    private String commandNoPermissionMessage;
    private String commandPlayerOnlyMessage;

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getCommand("ic").setExecutor((CommandExecutor)new ItemClearCommand(this));
        this.scheduleClearTask();
        this.getLogger().info("ItemClear wurde eingeschaltet!");
        this.getLogger().info("made by zKinqJustinTW");
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        config.addDefault("clear-interval", (Object)600);
        config.addDefault("warning-time", (Object)60);
        config.addDefault("clear-message", (Object)"&cAlle Items wurden vom Boden entfernt!");
        config.addDefault("warning-message", (Object)"&eAchtung! In einer Minute werden alle Items vom Boden entfernt!");
        config.addDefault("command-success-message", (Object)"&aItem Clear wurde sofort ausgef\u00fchrt!");
        config.addDefault("command-broadcast-message", (Object)"&eEin Admin hat den Item Clear manuell ausgel\u00f6st!");
        config.addDefault("command-no-permission-message", (Object)"&cDu hast keine Berechtigung f\u00fcr diesen Command!");
        config.addDefault("command-player-only-message", (Object)"&cDieser Command kann nur von Spielern ausgef\u00fchrt werden!");
        config.options().copyDefaults(true);
        this.saveConfig();
        this.clearInterval = config.getInt("clear-interval") * 20;
        this.warningTime = config.getInt("warning-time");
        this.clearMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("clear-message"));
        this.warningMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("warning-message"));
        this.commandSuccessMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("command-success-message"));
        this.commandBroadcastMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("command-broadcast-message"));
        this.commandNoPermissionMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("command-no-permission-message"));
        this.commandPlayerOnlyMessage = ChatColor.translateAlternateColorCodes((char)'&', (String)config.getString("command-player-only-message"));
    }

    private void scheduleClearTask() {
        new BukkitRunnable(){

            public void run() {
                Bukkit.getScheduler().runTaskLater((Plugin)ItemClear.this, () -> Bukkit.broadcastMessage((String)ItemClear.this.warningMessage), (long)((ItemClear.this.clearInterval - ItemClear.this.warningTime * 20) / 20));
                Bukkit.getScheduler().runTaskLater((Plugin)ItemClear.this, () -> {
                    Bukkit.getWorlds().forEach(world -> world.getEntities().stream().filter(entity -> entity.getType().toString().contains("ITEM")).forEach(Entity::remove));
                    Bukkit.broadcastMessage((String)ItemClear.this.clearMessage);
                }, (long)(ItemClear.this.clearInterval / 20));
            }
        }.runTaskTimer((Plugin)this, 0L, (long)this.clearInterval);
    }

    public String getCommandSuccessMessage() {
        return this.commandSuccessMessage;
    }

    public String getCommandBroadcastMessage() {
        return this.commandBroadcastMessage;
    }

    public String getCommandNoPermissionMessage() {
        return this.commandNoPermissionMessage;
    }

    public String getCommandPlayerOnlyMessage() {
        return this.commandPlayerOnlyMessage;
    }

    public void onDisable() {
        this.getLogger().info("ItemClear wurde deaktiviert!");
    }
}

