/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasydice;

import dev.apexstudios.fantasydice.util.DiceRegistries;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.entity.UniquelyIdentifyable;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DiceEntity
extends Entity
implements TraceableEntity {
    public static final String NBT_AGE = "Age";
    public static final String NBT_THROWER = "Thrower";
    public static final String NBT_ITEM = "Item";
    private static final EntityDataAccessor<ItemStack> DATA_ITEM = SynchedEntityData.defineId(DiceEntity.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    public static final int DEFAULT_LIFETIME = 10;
    private int age = 0;
    @Nullable
    private EntityReference<Entity> thrower;
    public final float bobOffs = this.random.nextFloat() * (float)Math.PI * 2.0f;

    public DiceEntity(EntityType<? extends DiceEntity> entityType, Level level) {
        super(entityType, level);
        this.setYRot(this.getRandom().nextFloat() * 360.0f);
    }

    public DiceEntity(Level level, ItemStack stack, @Nullable Entity thrower) {
        this((EntityType<? extends DiceEntity>)((EntityType)DiceRegistries.DICE_ENTITY.value()), level);
        this.setItem(stack);
        this.setThrower(thrower);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(DATA_ITEM, (Object)ItemStack.EMPTY);
    }

    public boolean hurtServer(ServerLevel level, DamageSource damageSource, float amount) {
        return false;
    }

    protected void readAdditionalSaveData(ValueInput input) {
        this.age = input.getIntOr(NBT_AGE, 0);
        this.thrower = EntityReference.read((ValueInput)input, (String)NBT_THROWER);
        this.setItem(input.read(NBT_ITEM, ItemStack.CODEC).orElse(ItemStack.EMPTY));
        if (this.getItem().isEmpty()) {
            this.discard();
        }
    }

    protected void addAdditionalSaveData(ValueOutput output) {
        output.putInt(NBT_AGE, this.age);
        EntityReference.store(this.thrower, (ValueOutput)output, (String)NBT_THROWER);
        if (!this.getItem().isEmpty()) {
            output.store(NBT_ITEM, ItemStack.CODEC, (Object)this.getItem());
        }
    }

    @Nullable
    public Entity getOwner() {
        return (Entity)EntityReference.get(this.thrower, (Level)this.level(), Entity.class);
    }

    public void restoreFrom(Entity entity) {
        super.restoreFrom(entity);
        if (entity instanceof DiceEntity) {
            DiceEntity dice = (DiceEntity)entity;
            this.thrower = dice.thrower;
        }
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    public void tick() {
        double d0;
        if (this.getItem().isEmpty()) {
            this.discard();
            return;
        }
        super.tick();
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        Vec3 delta = this.getDeltaMovement();
        if (this.isInWater() && this.getFluidHeight(FluidTags.WATER) > (double)0.1f) {
            this.setFluidMovement(0.99f);
        } else if (this.isInLava() && this.getFluidHeight(FluidTags.LAVA) > (double)0.1f) {
            this.setFluidMovement(0.95f);
        } else {
            this.applyGravity();
        }
        if (this.level().isClientSide()) {
            this.noPhysics = false;
        } else {
            AABB boundingBox = this.getBoundingBox();
            boolean bl = this.noPhysics = !this.level().noCollision((Entity)this, boundingBox.deflate(1.0E-7));
            if (this.noPhysics) {
                this.moveTowardsClosestSpace(this.getX(), (boundingBox.minY + boundingBox.maxY) / 2.0, this.getZ());
            }
        }
        if (!this.onGround() || this.getDeltaMovement().horizontalDistanceSqr() > (double)1.0E-5f || (this.tickCount + this.getId()) % 4 == 0) {
            this.move(MoverType.SELF, this.getDeltaMovement());
            this.applyEffectsFromBlocks();
            float f = 0.98f;
            if (this.onGround()) {
                BlockPos groundPos = this.getBlockPosBelowThatAffectsMyMovement();
                f = this.level().getBlockState(groundPos).getFriction((LevelReader)this.level(), groundPos, (Entity)this) * f;
            }
            this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, (double)f, (double)f));
            if (this.onGround()) {
                Vec3 delta1 = this.getDeltaMovement();
                if (delta1.y < 0.0) {
                    this.setDeltaMovement(delta1.multiply(1.0, -0.5, 1.0));
                }
            }
        }
        ++this.age;
        this.hasImpulse |= this.updateInWaterStateAndDoFluidPushing();
        if (!this.level().isClientSide() && (d0 = this.getDeltaMovement().subtract(delta).lengthSqr()) > 0.01) {
            this.hasImpulse = true;
        }
        ItemStack item = this.getItem();
        if (!this.level().isClientSide() && this.age >= this.getLifeTime()) {
            this.discard();
        }
        if (item.isEmpty() && !this.isRemoved()) {
            this.discard();
        }
    }

    public BlockPos getBlockPosBelowThatAffectsMyMovement() {
        return this.getOnPos(0.999999f);
    }

    private void setFluidMovement(double multiplier) {
        Vec3 delta = this.getDeltaMovement();
        this.setDeltaMovement(delta.x * multiplier, delta.y + (double)(delta.y < (double)0.06f ? 5.0E-4f : 0.0f), delta.z * multiplier);
    }

    public boolean fireImmune() {
        return true;
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public Component getName() {
        Component customName = this.getCustomName();
        return customName == null ? this.getItem().getItemName() : customName;
    }

    public boolean isAttackable() {
        return false;
    }

    public ItemStack getItem() {
        return (ItemStack)this.getEntityData().get(DATA_ITEM);
    }

    public void setItem(ItemStack stack) {
        this.getEntityData().set(DATA_ITEM, (Object)stack);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (DATA_ITEM.equals(key)) {
            this.getItem().setEntityRepresentation((Entity)this);
        }
    }

    public void setThrower(Entity thrower) {
        this.thrower = EntityReference.of((UniquelyIdentifyable)thrower);
    }

    public SoundSource getSoundSource() {
        return SoundSource.AMBIENT;
    }

    public float getVisualRotationYInDegrees() {
        return 180.0f - ItemEntity.getSpin((float)((float)this.age + 0.5f), (float)this.bobOffs) / ((float)Math.PI * 2) * 360.0f;
    }

    public SlotAccess getSlot(int slot) {
        return slot == 0 ? SlotAccess.of(this::getItem, this::setItem) : super.getSlot(slot);
    }

    public int getLifeTime() {
        int n;
        Level level = this.level();
        if (level instanceof ServerLevel) {
            ServerLevel sLevel = (ServerLevel)level;
            n = sLevel.getGameRules().getInt(DiceRegistries.RULE_DICE_LIFETIME);
        } else {
            n = 10;
        }
        int lifeTime = n;
        return lifeTime * 20;
    }
}

