/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasydice;

import dev.apexstudios.fantasydice.util.Dice;
import dev.apexstudios.fantasydice.util.DiceRegistries;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

@Mod(value="fantasydice")
public final class FantasyDice {
    public static final String ID = "fantasydice";

    public FantasyDice(IEventBus modBus) {
        DiceRegistries.REGISTREE.registerEvents(modBus);
        NeoForge.EVENT_BUS.addListener(PlayerInteractEvent.RightClickItem.class, event -> {
            InteractionHand hand;
            Player player;
            ItemStack stack;
            Level level = event.getLevel();
            if (Dice.throwDice(level, stack = (player = event.getEntity()).getItemInHand(hand = event.getHand()), (LivingEntity)player)) {
                player.getCooldowns().addCooldown(stack, 10);
                event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                event.setCanceled(true);
            }
        });
        NeoForge.EVENT_BUS.addListener(ItemTooltipEvent.class, event -> {
            ItemStack stack = event.getItemStack();
            if (Dice.isValid((DataComponentHolder)stack)) {
                event.getToolTip().add(Dice.getDescription((DataComponentHolder)stack));
            }
        });
    }

    public static ResourceLocation identifier(String identifier) {
        return DiceRegistries.REGISTREE.registryName(identifier);
    }
}

