/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasydice.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.apexstudios.fantasydice.DiceEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemEntityRenderer;
import net.minecraft.client.renderer.entity.state.EntityRenderState;
import net.minecraft.client.renderer.entity.state.ItemClusterRenderState;
import net.minecraft.client.renderer.entity.state.ItemEntityRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.joml.Quaternionfc;

public class DiceEntityRenderer
extends EntityRenderer<DiceEntity, ItemEntityRenderState> {
    private final ItemModelResolver modelResolver;
    private final RandomSource random = RandomSource.create();

    public DiceEntityRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.modelResolver = context.getItemModelResolver();
        this.shadowRadius = 0.15f;
        this.shadowStrength = 0.75f;
    }

    public ItemEntityRenderState createRenderState() {
        return new ItemEntityRenderState();
    }

    public void extractRenderState(DiceEntity entity, ItemEntityRenderState reusedState, float partialTick) {
        super.extractRenderState((Entity)entity, (EntityRenderState)reusedState, partialTick);
        reusedState.bobOffset = entity.bobOffs;
        reusedState.shouldBob = IClientItemExtensions.of((ItemStack)entity.getItem()).shouldBobAsEntity(entity.getItem());
        reusedState.shouldSpread = IClientItemExtensions.of((ItemStack)entity.getItem()).shouldSpreadAsEntity(entity.getItem());
        reusedState.extractItemGroupRenderState((Entity)entity, entity.getItem(), this.modelResolver);
    }

    public void submit(ItemEntityRenderState renderState, PoseStack pose, SubmitNodeCollector nodes, CameraRenderState camera) {
        if (renderState.item.isEmpty()) {
            return;
        }
        pose.pushPose();
        AABB aabb = renderState.item.getModelBoundingBox();
        float f = -((float)aabb.minY) + 0.0625f;
        float f1 = renderState.shouldBob ? Mth.sin((float)(renderState.ageInTicks / 10.0f + renderState.bobOffset)) * 0.1f + 0.1f : 0.0f;
        pose.translate(0.0f, f1 + f, 0.0f);
        float f2 = ItemEntity.getSpin((float)renderState.ageInTicks, (float)renderState.bobOffset);
        pose.mulPose((Quaternionfc)Axis.YP.rotation(f2));
        ItemEntityRenderer.submitMultipleFromCount((PoseStack)pose, (SubmitNodeCollector)nodes, (int)renderState.lightCoords, (ItemClusterRenderState)renderState, (RandomSource)this.random, (AABB)aabb);
        pose.popPose();
        super.submit((EntityRenderState)renderState, pose, nodes, camera);
    }
}

