/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasydice.util;

import dev.apexstudios.apexcore.lib.util.StringHelper;
import dev.apexstudios.fantasydice.DiceEntity;
import dev.apexstudios.fantasydice.util.DiceRegistries;
import java.util.Objects;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import org.jetbrains.annotations.Nullable;

public interface Dice {
    public static final int[] DEFAULT_SIDES = new int[]{4, 6, 8, 10, 12, 20};
    public static final String[] DEFAULT_MATERIALS = new String[]{"wooden", "stone", "bone", "iron", "golden", "diamond", "emerald", "netherite", "copper", "ender", "frozen", "slime", "redstone", "paper", "amethyst", "chocolate"};
    public static final String DESCRIPTION_ID = "fantasydice.description";

    @Nullable
    public static String getMaterial(DataComponentHolder components) {
        return (String)components.get(DiceRegistries.MATERIAL_COMPONENT);
    }

    public static void setMaterial(MutableDataComponentHolder components, String material) {
        components.set(DiceRegistries.MATERIAL_COMPONENT, (Object)material);
    }

    public static String getMaterialKey(String material) {
        return "fantasydice.material." + material;
    }

    public static int getSides(DataComponentHolder components) {
        return (Integer)components.getOrDefault(DiceRegistries.SIDES_COMPONENT, (Object)-1);
    }

    public static void setSides(MutableDataComponentHolder components, int sides) {
        components.set(DiceRegistries.SIDES_COMPONENT, (Object)sides);
    }

    public static Component getDescription(DataComponentHolder components) {
        int sides = Dice.getSides(components);
        String material = Objects.requireNonNullElse(Dice.getMaterial(components), "unknown_dice");
        MutableComponent materialName = Component.translatableWithFallback((String)Dice.getMaterialKey(material), (String)StringHelper.toEnglishName((String)material));
        return Component.translatable((String)DESCRIPTION_ID, (Object[])new Object[]{materialName, sides});
    }

    public static ItemStack create(int sides, String material) {
        ItemStack stack = DiceRegistries.DICE_ITEM.toStack();
        Dice.setMaterial((MutableDataComponentHolder)stack, material);
        Dice.setSides((MutableDataComponentHolder)stack, sides);
        return stack;
    }

    public static boolean throwDice(Level level, ItemStack stack, LivingEntity thrower) {
        if (stack.isEmpty() || !Dice.isValid((DataComponentHolder)stack)) {
            return false;
        }
        int sides = Dice.getSides((DataComponentHolder)stack);
        if (level.isClientSide()) {
            return true;
        }
        int count = stack.getCount();
        float d0 = ((EntityType)DiceRegistries.DICE_ENTITY.value()).getWidth() + 2.5f;
        double d1 = 1.0 - (double)d0;
        double d2 = (double)d0 / 2.0;
        double x = Math.floor(thrower.getX());
        double y = thrower.getEyeY() - (double)0.3f;
        double z = Math.floor(thrower.getZ());
        int color = thrower.getTeamColor();
        ItemStack diceStack = stack.copyWithCount(1);
        for (int i = 0; i < count; ++i) {
            int roll = level.random.nextInt(sides) + 1;
            DiceEntity dice = Dice.createDiceEntity(level, diceStack, thrower);
            dice.setPos(x + level.random.nextDouble() * d1 + d2, y, z + level.random.nextDouble() * d1 + d2);
            dice.setCustomName((Component)Component.literal((String)String.valueOf(roll)).withColor(color));
            dice.setCustomNameVisible(true);
            level.addFreshEntity((Entity)dice);
        }
        return true;
    }

    public static boolean isValid(DataComponentHolder components) {
        return components.has(DiceRegistries.SIDES_COMPONENT) && components.has(DiceRegistries.MATERIAL_COMPONENT);
    }

    private static DiceEntity createDiceEntity(Level level, ItemStack stack, LivingEntity thrower) {
        RandomSource random = thrower.getRandom();
        float f8 = Mth.sin((float)(thrower.getXRot() * ((float)Math.PI / 180)));
        float f2 = Mth.cos((float)(thrower.getXRot() * ((float)Math.PI / 180)));
        float f3 = Mth.sin((float)(thrower.getYRot() * ((float)Math.PI / 180)));
        float f4 = Mth.cos((float)(thrower.getYRot() * ((float)Math.PI / 180)));
        float f5 = random.nextFloat();
        float f6 = 0.02f * random.nextFloat();
        DiceEntity dice = new DiceEntity(level, stack.copyWithCount(1), (Entity)thrower);
        dice.setDeltaMovement((double)(-f3 * f2 * 0.3f) + Math.cos(f5) * (double)f6, -f8 * 0.3f + 0.1f + (random.nextFloat() - random.nextFloat()) * 0.1f, (double)(f4 * f2 * 0.3f) + Math.sin(f5) * (double)f6);
        return dice;
    }
}

