/*
 * Decompiled with CFR 0.152.
 */
package dev.apexstudios.fantasydice.util;

import dev.apexstudios.fantasydice.DiceEntity;
import dev.apexstudios.fantasydice.util.Dice;
import dev.apexstudios.fantasydice.util.DiceCodecs;
import dev.apexstudios.registree.api.Registree;
import dev.apexstudios.registree.api.holder.DeferredDataComponent;
import dev.apexstudios.registree.api.holder.DeferredEntity;
import dev.apexstudios.registree.api.holder.DeferredItem;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;

public interface DiceRegistries {
    public static final Registree REGISTREE = Registree.create((String)"fantasydice");
    public static final DeferredDataComponent<String> MATERIAL_COMPONENT = REGISTREE.registerDataComponent("material", DiceCodecs.MATERIAL_CODEC);
    public static final DeferredDataComponent<Integer> SIDES_COMPONENT = REGISTREE.registerDataComponent("sides", DiceCodecs.SIDES_CODEC);
    public static final DeferredItem<Item> DICE_ITEM = REGISTREE.registerItem("dice", Item::new, properties -> properties.stacksTo(8));
    public static final DeferredEntity<DiceEntity> DICE_ENTITY = REGISTREE.registerEntity("dice", DiceEntity::new, MobCategory.MISC, properties -> properties.noLootTable().sized(0.25f, 0.25f).eyeHeight(0.2125f).clientTrackingRange(6).updateInterval(20));
    public static final ResourceKey<CreativeModeTab> CREATIVE_MODE_TAB = REGISTREE.registerCreativeModeTab("dice", () -> Dice.create(Dice.DEFAULT_SIDES[0], Dice.DEFAULT_MATERIALS[0]), (parameters, output) -> {
        for (String material : Dice.DEFAULT_MATERIALS) {
            for (int side : Dice.DEFAULT_SIDES) {
                output.accept(Dice.create(side, material));
            }
        }
    });
    public static final GameRules.Key<GameRules.IntegerValue> RULE_DICE_LIFETIME = REGISTREE.registerIntegerGameRule("diceLifetime", GameRules.Category.MISC, 10);
}

