/*
 * Decompiled with CFR 0.152.
 */
package com.unanimousvoid.goetyendbiomes.common.worldgen.feature;

import com.Polarice3.Goety.common.blocks.ModBlocks;
import com.mojang.serialization.Codec;
import com.unanimousvoid.goetyendbiomes.common.worldgen.feature.configurations.EndGrowthVinesConfiguration;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GrowingPlantHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class EndGrowthVinesFeature
extends Feature<EndGrowthVinesConfiguration> {
    private static final int VINE_BASE_AGE = 17;
    private static final int VINE_MAX_AGE = 20;
    private static final int DOUBLE_LENGTH_CHANCE = 3;
    private static final int MIN_LENGTH_CHANCE = 5;

    public EndGrowthVinesFeature(Codec<EndGrowthVinesConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<EndGrowthVinesConfiguration> context) {
        BlockPos origin;
        WorldGenLevel level = context.m_159774_();
        if (EndGrowthVinesFeature.isInvalidPlacementLocation((LevelAccessor)level, origin = context.m_159777_())) {
            return false;
        }
        RandomSource random = context.m_225041_();
        EndGrowthVinesConfiguration config = (EndGrowthVinesConfiguration)context.m_159778_();
        int spreadWidth = config.spreadWidth();
        int spreadHeight = config.spreadHeight();
        int maxHeight = config.maxHeight();
        BlockPos.MutableBlockPos currentPos = new BlockPos.MutableBlockPos();
        int attempts = spreadWidth * spreadWidth;
        for (int i = 0; i < attempts; ++i) {
            int xOffset = Mth.m_216271_((RandomSource)random, (int)(-spreadWidth), (int)spreadWidth);
            int yOffset = Mth.m_216271_((RandomSource)random, (int)(-spreadHeight), (int)spreadHeight);
            int zOffset = Mth.m_216271_((RandomSource)random, (int)(-spreadWidth), (int)spreadWidth);
            currentPos.m_122190_((Vec3i)origin).m_122184_(xOffset, yOffset, zOffset);
            if (!EndGrowthVinesFeature.findFirstAirBlockAboveGround((LevelAccessor)level, currentPos) || EndGrowthVinesFeature.isInvalidPlacementLocation((LevelAccessor)level, (BlockPos)currentPos)) continue;
            int vineLength = this.determineVineLength(random, maxHeight);
            EndGrowthVinesFeature.placeVineColumn((LevelAccessor)level, random, currentPos, vineLength, 17, 20);
        }
        return true;
    }

    private int determineVineLength(RandomSource random, int maxLength) {
        int length = Mth.m_216271_((RandomSource)random, (int)1, (int)maxLength);
        if (random.m_188503_(3) == 0) {
            length *= 2;
        }
        if (random.m_188503_(5) == 0) {
            length = 1;
        }
        return length;
    }

    private static boolean findFirstAirBlockAboveGround(LevelAccessor level, BlockPos.MutableBlockPos pos) {
        while (level.m_8055_((BlockPos)pos).m_60795_()) {
            pos.m_122184_(0, -1, 0);
            if (!level.m_151570_((BlockPos)pos)) continue;
            return false;
        }
        pos.m_122184_(0, 1, 0);
        return true;
    }

    public static void placeVineColumn(LevelAccessor level, RandomSource random, BlockPos.MutableBlockPos pos, int length, int minAge, int maxAge) {
        for (int i = 1; i <= length && level.m_46859_((BlockPos)pos); ++i) {
            if (i == length || !level.m_46859_(pos.m_7494_())) {
                BlockState vineHead = (BlockState)((Block)ModBlocks.END_GROWTH_VINES.get()).m_49966_().m_61124_((Property)GrowingPlantHeadBlock.f_53924_, (Comparable)Integer.valueOf(Mth.m_216271_((RandomSource)random, (int)minAge, (int)maxAge)));
                level.m_7731_((BlockPos)pos, vineHead, 2);
                break;
            }
            level.m_7731_((BlockPos)pos, ((Block)ModBlocks.END_GROWTH_VINES_PLANT.get()).m_49966_(), 2);
            pos.m_122173_(Direction.UP);
        }
    }

    private static boolean isInvalidPlacementLocation(LevelAccessor level, BlockPos pos) {
        if (!level.m_46859_(pos)) {
            return true;
        }
        BlockState blockBelow = level.m_8055_(pos.m_7495_());
        return !blockBelow.m_60713_((Block)ModBlocks.GROWN_END_ROCK.get()) && !blockBelow.m_60713_((Block)ModBlocks.END_GROWTH_BLOCK.get());
    }
}

