/*
 * Decompiled with CFR 0.152.
 */
package com.unanimousvoid.goetyendbiomes.common.worldgen.feature;

import com.mojang.serialization.Codec;
import com.unanimousvoid.goetyendbiomes.common.worldgen.feature.configurations.NBTFeatureConfiguration;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class NBTFeature
extends Feature<NBTFeatureConfiguration> {
    public NBTFeature(Codec<NBTFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NBTFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel curLevel = featurePlaceContext.m_159774_();
        if (curLevel.m_5776_()) {
            return false;
        }
        NBTFeatureConfiguration config = (NBTFeatureConfiguration)featurePlaceContext.m_159778_();
        Optional treeTemplate = curLevel.m_7654_().m_236738_().m_230407_((ResourceLocation)config.template().left().get());
        if (treeTemplate.isEmpty()) {
            return false;
        }
        BlockPos origin = featurePlaceContext.m_159777_();
        Vec3i size = ((StructureTemplate)treeTemplate.get()).m_163801_();
        if (origin.m_123342_() + size.m_123342_() > curLevel.m_151558_()) {
            return false;
        }
        RandomSource rand = featurePlaceContext.m_225041_();
        StructurePlaceSettings settings = new StructurePlaceSettings();
        settings.m_74385_(new BlockPos(size.m_123341_() / 2, 0, size.m_123343_() / 2));
        settings.m_74379_(this.randomRotation(rand));
        if (config.processors().isPresent()) {
            config.processors().get().m_74425_().forEach(structureProcessor -> settings.m_74383_(structureProcessor));
        }
        ((StructureTemplate)treeTemplate.get()).m_230328_((ServerLevelAccessor)curLevel, origin, origin, settings, rand, 2);
        return true;
    }

    private Rotation randomRotation(RandomSource random) {
        return switch (random.m_188503_(4)) {
            case 0 -> Rotation.NONE;
            case 1 -> Rotation.CLOCKWISE_90;
            case 2 -> Rotation.CLOCKWISE_180;
            default -> Rotation.COUNTERCLOCKWISE_90;
        };
    }
}

