/*
 * Decompiled with CFR 0.152.
 */
package com.unanimousvoid.goetyendbiomes.common.worldgen.feature.configurations;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public record NBTFeatureConfiguration(Either<ResourceLocation, StructureTemplate> template, int groundLevel, Optional<StructureProcessorList> processors) implements FeatureConfiguration
{
    public static final Codec<Either<ResourceLocation, StructureTemplate>> TEMPLATE_CODEC = Codec.of(NBTFeatureConfiguration::encodeTemplate, (Decoder)ResourceLocation.f_135803_.map(Either::left));
    public static final Codec<NBTFeatureConfiguration> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)TEMPLATE_CODEC.fieldOf("location").forGetter(conf -> conf.template), (App)Codec.intRange((int)0, (int)32).fieldOf("ground_level").forGetter(conf -> conf.groundLevel), (App)StructureProcessorType.f_74466_.optionalFieldOf("processors").forGetter(conf -> conf.processors)).apply((Applicative)instance, NBTFeatureConfiguration::new));

    private static <T> DataResult<T> encodeTemplate(Either<ResourceLocation, StructureTemplate> either, DynamicOps<T> ops, T templateObj) {
        Optional templateLoc = either.left();
        return templateLoc.isEmpty() ? DataResult.error(() -> "Cannot serialize a runtime pool element") : ResourceLocation.f_135803_.encode((Object)((ResourceLocation)templateLoc.get()), ops, templateObj);
    }
}

