/*
 * Decompiled with CFR 0.152.
 */
package com.unanimousvoid.goetyendbiomes.common.worldgen.placement_modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unanimousvoid.goetyendbiomes.common.registry.GEBFeatures;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class SurfaceAreaCheckPlacement
extends PlacementModifier {
    public static final Codec<SurfaceAreaCheckPlacement> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BlockStateProvider.f_68747_.fieldOf("state").forGetter(check -> check.provider), (App)BoundingBox.f_162354_.fieldOf("box").forGetter(check -> check.box)).apply((Applicative)instance, SurfaceAreaCheckPlacement::new));
    public final BlockStateProvider provider;
    public final BoundingBox box;

    public SurfaceAreaCheckPlacement(BlockStateProvider provider, BoundingBox box) {
        this.provider = provider;
        this.box = box;
    }

    public Stream<BlockPos> m_213676_(PlacementContext context, RandomSource source, BlockPos pos) {
        WorldGenLevel level = context.m_191831_();
        BlockPos firstCorner = level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_7918_(this.box.m_162395_(), 0, this.box.m_162398_()));
        BlockPos secondCorner = level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_7918_(this.box.m_162399_(), 0, this.box.m_162398_()));
        BlockPos thirdCorner = level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_7918_(this.box.m_162395_(), 0, this.box.m_162401_()));
        BlockPos fourthCorner = level.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, pos.m_7918_(this.box.m_162399_(), 0, this.box.m_162401_()));
        if (!this.provider.m_213972_(source, pos).equals(level.m_8055_(firstCorner.m_7495_()))) {
            return Stream.empty();
        }
        if (!this.provider.m_213972_(source, pos).equals(level.m_8055_(secondCorner.m_7495_()))) {
            return Stream.empty();
        }
        if (!this.provider.m_213972_(source, pos).equals(level.m_8055_(thirdCorner.m_7495_()))) {
            return Stream.empty();
        }
        if (!this.provider.m_213972_(source, pos).equals(level.m_8055_(fourthCorner.m_7495_()))) {
            return Stream.empty();
        }
        return Stream.of(pos);
    }

    public PlacementModifierType<?> m_183327_() {
        return (PlacementModifierType)GEBFeatures.PlacementModifiers.SURFACE_AREA_CHECK.get();
    }
}

