/*
 * Decompiled with CFR 0.152.
 */
package golden.scnicknamer;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import golden.scnicknamer.DisplayMapping;
import golden.scnicknamer.ServerResponse;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class NameLinkAPI {
    public static final String MOD_ID = "SCNicknamer";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SCNicknamer");
    static final String CACHE_PATH = "config/scnicknamer-cache.json";
    static final int MAX_RETRIES = 5;
    static final int BASE_DELAY_MS = 500;
    static String status = "Working";

    public static ServerResponse getData(String source) {
        status = "Working";
        try {
            String jsonData = NameLinkAPI.loadJsonFromUrl(source);
            LOGGER.info("Load data from url");
            ServerResponse displayMappings = NameLinkAPI.loadJsonToObjects(jsonData);
            LOGGER.info("Converted string to Object");
            NameLinkAPI.saveJsonToFile(jsonData);
            LOGGER.info("Saved the data to {}", (Object)CACHE_PATH);
            status = "Success";
            return displayMappings;
        }
        catch (IOException | RuntimeException | URISyntaxException e) {
            try {
                ServerResponse displayMappings = NameLinkAPI.loadJsonFromFile();
                status = "Fallback";
                LOGGER.warn("Could not reach the server. Using cached fallback.");
                return displayMappings;
            }
            catch (IOException | RuntimeException ex) {
                status = "Failure";
                LOGGER.warn("Could not reach the server or find a fallback.");
                return new ServerResponse(new HashMap<UUID, DisplayMapping>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadJsonFromUrl(String source) throws IOException, URISyntaxException {
        StringBuilder result = new StringBuilder();
        URL url = new URI(source).toURL();
        int retries = 0;
        while (retries < 5) {
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                try (Object reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String line;
                    while ((line = ((BufferedReader)reader).readLine()) != null) {
                        result.append(line);
                    }
                }
                reader = result.toString();
                return reader;
            }
            catch (IOException e) {
                if (++retries == 5) {
                    throw new IOException("Failed to load JSON from URL after " + retries + " retries", e);
                }
                long backoffDelay = 500L * (1L << retries);
                LOGGER.warn("Could not load JSON from URL. Retrying in {}ms (attempt {} of 5)", (Object)backoffDelay, (Object)retries);
                try {
                    Thread.sleep(backoffDelay);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Retry was interrupted", ie);
                }
            }
            finally {
                if (conn == null) continue;
                conn.disconnect();
            }
        }
        return result.toString();
    }

    private static void saveJsonToFile(String jsonData) throws IOException {
        try (FileWriter fileWriter = new FileWriter(CACHE_PATH);){
            fileWriter.write(jsonData);
        }
    }

    private static ServerResponse loadJsonToObjects(String jsonData) throws IOException {
        Gson gson = new Gson();
        return (ServerResponse)gson.fromJson(jsonData, NameLinkAPI.getResponseType());
    }

    private static ServerResponse loadJsonFromFile() throws IOException {
        Gson gson = new Gson();
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(CACHE_PATH, new String[0]));){
            ServerResponse serverResponse = (ServerResponse)gson.fromJson((Reader)reader, NameLinkAPI.getResponseType());
            return serverResponse;
        }
    }

    private static Type getResponseType() {
        return new TypeToken<ServerResponse>(){}.getType();
    }

    public static String getStatus() {
        return status;
    }

    public static void disableMod() {
        status = "Disabled";
    }
}

