/*
 * Decompiled with CFR 0.152.
 */
package golden.scnicknamer;

import com.mojang.brigadier.CommandDispatcher;
import golden.scnicknamer.CommandManager;
import golden.scnicknamer.DisplayMapping;
import golden.scnicknamer.GradientUtil;
import golden.scnicknamer.NameLinkAPI;
import golden.scnicknamer.ServerResponse;
import golden.scnicknamer.config.SCNicknamerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class SCNicknamerClient
implements ClientModInitializer {
    private static final String MOD_ID = "scnicknamer";
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"scnicknamer");
    private static SCNicknamerConfig config;
    private static HashMap<UUID, DisplayMapping> mappings;
    private static List<String> whitelist;
    private static List<String> blacklist;
    private static List<String> messages;
    private static String server;

    public static DisplayMapping getMapping(UUID uuid) {
        return mappings.get(uuid);
    }

    static class_5250 applyMapping(class_2561 message, DisplayMapping mapping, boolean replaceName, boolean replaceColour) {
        if (message == null || message.getString().isEmpty() || mapping == null) {
            return (class_5250)message;
        }
        class_5250 outputMessage = class_2561.method_43473();
        message.method_27658((style, text) -> {
            if (!text.contains(mapping.mc_name())) {
                outputMessage.method_10852((class_2561)class_2561.method_43470((String)text).method_10862(style));
                return Optional.empty();
            }
            String replacedText = text;
            class_2583 replacedStyle = style;
            if (mapping.nickname() != null && replaceName) {
                replacedText = replacedText.replace(mapping.mc_name(), mapping.nickname());
            }
            if (mapping.colour() != null && replaceColour) {
                replacedStyle = replacedStyle.method_36139(Integer.parseInt(mapping.colour(), 16));
            }
            class_5250 newText = (class_5250)class_2561.method_30163((String)replacedText);
            newText.method_10862(replacedStyle);
            if (mapping.colours() != null && mapping.colours().length > 1 && replaceColour) {
                newText = (class_5250)GradientUtil.applyGradient((class_2561)newText, List.of(mapping.colours()));
            }
            outputMessage.method_10852((class_2561)newText);
            return Optional.empty();
        }, class_2583.field_24360);
        return outputMessage;
    }

    public static class_2561 getStyledName(class_2561 displayName, UUID uuid, boolean replaceName, boolean replaceColour) {
        DisplayMapping mapping = SCNicknamerClient.getMapping(uuid);
        return mapping != null ? SCNicknamerClient.applyMapping(displayName, mapping, replaceName, replaceColour) : displayName;
    }

    public static class_2561 getStyledChat(class_2561 message, boolean replaceName, boolean replaceColour) {
        if (message == null || message.getString().isEmpty()) {
            return class_2561.method_43473();
        }
        class_5250 outputMessage = class_2561.method_43473();
        message.method_27658((style, text) -> {
            class_5250 newText = class_2561.method_43470((String)text).method_10862(style);
            class_2568 event = style.method_10969();
            if (event != null && event.method_10892() == class_2568.class_5247.field_24344) {
                class_2568.class_5248 entity = ((class_2568.class_10611)event).comp_3508();
                newText = (class_5250)SCNicknamerClient.getStyledName((class_2561)newText, entity.field_24352, replaceName, replaceColour);
                newText.method_10862(newText.method_10866().method_10949(event));
            }
            outputMessage.method_10852((class_2561)newText);
            return Optional.empty();
        }, class_2583.field_24360);
        return outputMessage;
    }

    public static int getData(String source) {
        String s = source == null || source.isEmpty() ? "https://gwaff.uqcloud.net/scnicknamer/" : source;
        ServerResponse data = NameLinkAPI.getData(s);
        mappings = data.mappings() != null ? data.mappings() : new HashMap();
        whitelist = data.whitelist() != null ? data.whitelist() : new ArrayList<String>();
        blacklist = data.blacklist() != null ? data.blacklist() : new ArrayList<String>();
        messages = data.messages() != null ? data.messages() : new ArrayList<String>();
        return mappings.size();
    }

    public static class_2561 getStatusString() {
        return switch (NameLinkAPI.getStatus()) {
            case "Success" -> class_2561.method_43471((String)"text.scnicknamer.status.success").method_27692(class_124.field_1068);
            case "Working" -> class_2561.method_43471((String)"text.scnicknamer.status.working").method_27692(class_124.field_1054);
            case "Fallback" -> class_2561.method_43471((String)"text.scnicknamer.status.fallback").method_27692(class_124.field_1061);
            case "Failure" -> class_2561.method_43471((String)"text.scnicknamer.status.failure").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
            default -> class_2561.method_30163((String)NameLinkAPI.getStatus());
        };
    }

    public static void setServer(String currentServer) {
        server = currentServer;
    }

    public static boolean isEnabled() {
        if (!SCNicknamerClient.config.enableMod) {
            return false;
        }
        if (!SCNicknamerClient.config.useWhitelist) {
            return true;
        }
        if (whitelist.isEmpty()) {
            return true;
        }
        if (server == null || server.isEmpty()) {
            return false;
        }
        return whitelist.contains(server);
    }

    public void onInitializeClient() {
        AutoConfig.register(SCNicknamerConfig.class, Toml4jConfigSerializer::new);
        config = (SCNicknamerConfig)AutoConfig.getConfigHolder(SCNicknamerConfig.class).getConfig();
        int count = SCNicknamerClient.getData(SCNicknamerClient.config.apiLink);
        if (count > 0) {
            LOGGER.info("{} initialised with {} mappings", (Object)MOD_ID, (Object)mappings.size());
        } else {
            LOGGER.warn("{} initialised with NO mappings found", (Object)MOD_ID);
        }
        if (!SCNicknamerClient.config.enableMod) {
            NameLinkAPI.disableMod();
            LOGGER.warn("Mod disabled.");
            return;
        }
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> CommandManager.register((CommandDispatcher<FabricClientCommandSource>)dispatcher));
    }

    static {
        mappings = new HashMap();
        whitelist = new ArrayList<String>();
        blacklist = new ArrayList<String>();
        messages = new ArrayList<String>();
    }
}

