/*
 * Decompiled with CFR 0.152.
 */
package golden.scnicknamer;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import golden.scnicknamer.DisplayMapping;
import java.io.BufferedReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class NameLinkAPI {
    public static final String MOD_ID = "SC-Name-Link";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"SC-Name-Link");
    static final String CACHE_PATH = "config/spooncraft-name-link-cache.json";
    static final int MAX_RETRIES = 5;
    static final int BASE_DELAY_MS = 500;
    static String status = "Working";

    public static List<DisplayMapping> getMappings(String source) {
        status = "Working";
        try {
            String jsonData = NameLinkAPI.loadJsonFromUrl(source);
            LOGGER.info("Load data from url");
            List<DisplayMapping> displayMappings = NameLinkAPI.loadJsonToObjects(jsonData);
            LOGGER.info("Converted sting to Object");
            NameLinkAPI.saveJsonToFile(jsonData);
            LOGGER.info("Saved the data to {}", (Object)CACHE_PATH);
            status = "Success";
            return displayMappings;
        }
        catch (IOException | RuntimeException | URISyntaxException e) {
            try {
                List<DisplayMapping> displayMappings = NameLinkAPI.loadJsonFromFile();
                status = "Fallback";
                LOGGER.warn("Could not reach the server. Using cached fallback.");
                return displayMappings;
            }
            catch (IOException | RuntimeException ex) {
                status = "Failure";
                LOGGER.warn("Could not reach the server or find a fallback.");
                return new ArrayList<DisplayMapping>(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadJsonFromUrl(String source) throws IOException, URISyntaxException {
        StringBuilder result = new StringBuilder();
        URL url = new URI(source).toURL();
        int retries = 0;
        while (retries < 5) {
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                try (Object reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));){
                    String line;
                    while ((line = ((BufferedReader)reader).readLine()) != null) {
                        result.append(line);
                    }
                }
                reader = result.toString();
                return reader;
            }
            catch (IOException e) {
                if (++retries == 5) {
                    throw new IOException("Failed to load JSON from URL after " + retries + " retries", e);
                }
                long backoffDelay = 500L * (1L << retries);
                LOGGER.warn("Could not load JSON from URL. Retrying in {}ms (attempt {} of 5)", (Object)backoffDelay, (Object)retries);
                try {
                    Thread.sleep(backoffDelay);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new IOException("Retry was interrupted", ie);
                }
            }
            finally {
                if (conn == null) continue;
                conn.disconnect();
            }
        }
        return result.toString();
    }

    private static void saveJsonToFile(String jsonData) throws IOException {
        try (FileWriter fileWriter = new FileWriter(CACHE_PATH);){
            fileWriter.write(jsonData);
        }
    }

    private static List<DisplayMapping> loadJsonToObjects(String jsonData) throws IOException {
        Gson gson = new Gson();
        return (List)gson.fromJson(jsonData, NameLinkAPI.getDisplayMappingListType());
    }

    private static List<DisplayMapping> loadJsonFromFile() throws IOException {
        Gson gson = new Gson();
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(CACHE_PATH, new String[0]));){
            List list = (List)gson.fromJson((Reader)reader, NameLinkAPI.getDisplayMappingListType());
            return list;
        }
    }

    private static Type getDisplayMappingListType() {
        return new TypeToken<List<DisplayMapping>>(){}.getType();
    }

    public static String getStatus() {
        return status;
    }

    public static void disableMod() {
        status = "Disabled";
    }
}

