/*
 * Decompiled with CFR 0.152.
 */
package golden.scnicknamer;

import com.mojang.brigadier.CommandDispatcher;
import golden.scnicknamer.CommandManager;
import golden.scnicknamer.DisplayMapping;
import golden.scnicknamer.GradientUtil;
import golden.scnicknamer.NameLinkAPI;
import golden.scnicknamer.config.SCNicknamerConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.Toml4jConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Environment(value=EnvType.CLIENT)
public class SCNicknamerClient
implements ClientModInitializer {
    static final String MOD_ID = "scnamelink";
    static final Logger LOGGER = LoggerFactory.getLogger((String)"scnamelink");
    static SCNicknamerConfig config;
    private static List<DisplayMapping> mappings;

    public static DisplayMapping getMapping(UUID uuid, String name) {
        for (DisplayMapping mapping : mappings) {
            if (!Objects.equals(mapping.mc_uuid, uuid) && !Objects.equals(mapping.mc_name, name)) continue;
            return mapping;
        }
        return null;
    }

    static class_5250 applyMapping(class_2561 message, DisplayMapping mapping, boolean replaceName, boolean replaceColour) {
        if (message == null || message.getString().isEmpty() || mapping == null) {
            return (class_5250)message;
        }
        class_5250 outputMessage = class_2561.method_43473();
        message.method_27658((style, text) -> {
            if (!text.contains(mapping.mc_name)) {
                outputMessage.method_10852((class_2561)class_2561.method_43470((String)text).method_10862(style));
                return Optional.empty();
            }
            String replacedText = text;
            class_2583 replacedStyle = style;
            if (mapping.discord_nick != null && replaceName) {
                replacedText = replacedText.replace(mapping.mc_name, mapping.discord_nick);
            }
            if (mapping.colour != null && replaceColour) {
                replacedStyle = replacedStyle.method_36139(Integer.parseInt(mapping.colour, 16));
            }
            class_5250 newText = (class_5250)class_2561.method_30163((String)replacedText);
            newText.method_10862(replacedStyle);
            if (mapping.colours != null && mapping.colours.length > 1 && replaceColour) {
                newText = (class_5250)GradientUtil.applyGradient((class_2561)newText, List.of(mapping.colours));
            }
            outputMessage.method_10852((class_2561)newText);
            return Optional.empty();
        }, class_2583.field_24360);
        return outputMessage;
    }

    public static class_2561 getStyledName(class_2561 displayName, UUID uuid, String name, boolean replaceName, boolean replaceColour) {
        DisplayMapping mapping = SCNicknamerClient.getMapping(uuid, name);
        if (mapping != null) {
            return SCNicknamerClient.applyMapping(displayName, mapping, replaceName, replaceColour);
        }
        return displayName;
    }

    public static class_2561 getStyledName(class_2561 displayName, String name, boolean replaceName, boolean replaceColour) {
        return SCNicknamerClient.getStyledName(displayName, UUID.randomUUID(), name, replaceName, replaceColour);
    }

    public static class_2561 getStyledChat(class_2561 message, boolean replaceName, boolean replaceColour) {
        if (message == null || message.getString().isEmpty()) {
            return class_2561.method_43473();
        }
        class_5250 outputMessage = class_2561.method_43473();
        message.method_27658((style, text) -> {
            class_5250 newText = class_2561.method_43470((String)text).method_10862(style);
            class_2568 event = style.method_10969();
            if (event != null && event.method_10892() == class_2568.class_5247.field_24344) {
                class_2568.class_5248 entity = ((class_2568.class_10611)event).comp_3508();
                newText = (class_5250)SCNicknamerClient.getStyledName((class_2561)newText, entity.field_24352, String.valueOf(entity.field_24353), replaceName, replaceColour);
                newText.method_10862(newText.method_10866().method_10949(event));
            }
            outputMessage.method_10852((class_2561)newText);
            return Optional.empty();
        }, class_2583.field_24360);
        return outputMessage;
    }

    public static int getMappings(String source) {
        String s = source == null || source.isEmpty() ? "https://gwaff.uqcloud.net/api/spooncraft" : source;
        mappings = NameLinkAPI.getMappings(s);
        return mappings.size();
    }

    public static class_2561 getStatusString() {
        String status;
        return switch (status = NameLinkAPI.getStatus()) {
            case "Success" -> class_2561.method_43471((String)"text.scnamelink.status.success").method_27692(class_124.field_1068);
            case "Working" -> class_2561.method_43471((String)"text.scnamelink.status.working").method_27692(class_124.field_1054);
            case "Fallback" -> class_2561.method_43471((String)"text.scnamelink.status.fallback").method_27692(class_124.field_1061);
            case "Failure" -> class_2561.method_43471((String)"text.scnamelink.status.failure").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067});
            default -> class_2561.method_30163((String)NameLinkAPI.getStatus());
        };
    }

    public void onInitializeClient() {
        AutoConfig.register(SCNicknamerConfig.class, Toml4jConfigSerializer::new);
        config = (SCNicknamerConfig)AutoConfig.getConfigHolder(SCNicknamerConfig.class).getConfig();
        int count = SCNicknamerClient.getMappings(SCNicknamerClient.config.apiLink);
        if (count > 0) {
            LOGGER.info("{} initialised with {} mappings", (Object)MOD_ID, (Object)mappings.size());
        } else {
            LOGGER.warn("{} initialised with NO mappings found", (Object)MOD_ID);
        }
        if (!SCNicknamerClient.config.enableMod) {
            NameLinkAPI.disableMod();
            LOGGER.warn("Mod disabled.");
            return;
        }
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> CommandManager.register((CommandDispatcher<FabricClientCommandSource>)dispatcher));
    }

    static {
        mappings = new ArrayList<DisplayMapping>();
    }
}

