/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.ext.snakeyaml;

import cc.dsnb.bedrockplayersupport.dazzleconf.ext.snakeyaml.IteratorWithElementPrepended;
import cc.dsnb.bedrockplayersupport.dazzleconf.ext.snakeyaml.SnakeYamlOptions;
import cc.dsnb.bedrockplayersupport.dazzleconf.ext.snakeyaml.YamlWriter;
import cc.dsnb.bedrockplayersupport.dazzleconf.factory.CommentedWrapper;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class CommentedWriter
implements YamlWriter {
    private final Writer writer;
    private final String commentFormat;
    private int depth;
    private boolean firstMapEntryIsPartOfList;

    CommentedWriter(Writer writer, String commentFormat) {
        this.writer = writer;
        this.commentFormat = commentFormat;
    }

    @Override
    public void writeData(Map<String, Object> configMap, List<String> headerComments) throws IOException {
        this.writeComments(headerComments);
        this.writeMap(configMap);
    }

    void writeMap(Map<?, ?> map) throws IOException {
        this.writeRemainingMapEntries(map.entrySet().iterator());
    }

    private <K, V> void writeRemainingMapEntries(Iterator<Map.Entry<K, V>> entryIterator) throws IOException {
        while (entryIterator.hasNext()) {
            Map.Entry<K, V> entry = entryIterator.next();
            K key = entry.getKey();
            Object value = entry.getValue();
            if (!this.firstMapEntryIsPartOfList && value instanceof CommentedWrapper) {
                CommentedWrapper commentWrapper = (CommentedWrapper)value;
                this.writeComments(commentWrapper);
                this.writeKey(key);
                this.writeValue(commentWrapper.getValue());
                continue;
            }
            if (this.firstMapEntryIsPartOfList && value instanceof CommentedWrapper) {
                value = ((CommentedWrapper)value).getValue();
            }
            this.writeKey(key);
            this.writeValue(value);
        }
    }

    void writeComments(List<String> comments) throws IOException {
        CharSequence depthPrefix = this.depthPrefix();
        for (String comment : comments) {
            this.writer.append(depthPrefix).append(String.format(this.commentFormat, comment)).append('\n');
        }
    }

    private void writeComments(CommentedWrapper commentWrapper) throws IOException {
        this.writeComments(commentWrapper.getComments());
    }

    private CharSequence depthPrefix() {
        if (this.depth == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        int spaces = 2 * this.depth;
        for (int n = 0; n < spaces; ++n) {
            builder.append(' ');
        }
        return builder;
    }

    private void descendAndDo(WriterAction whenDescended) throws IOException {
        ++this.depth;
        whenDescended.run();
        --this.depth;
    }

    private void writeKey(Object key) throws IOException {
        if (this.firstMapEntryIsPartOfList) {
            this.firstMapEntryIsPartOfList = false;
        } else {
            this.writer.append(this.depthPrefix());
        }
        this.writer.append(key.toString()).append(':');
    }

    /*
     * Enabled aggressive block sorting
     */
    private void writeValue(Object value) throws IOException {
        Objects.requireNonNull(value, "Null value in map entry");
        if (value instanceof Map) {
            Map map = (Map)value;
            if (map.isEmpty()) {
                this.writer.append(" {}");
            } else {
                this.writer.append('\n');
                this.descendAndDo(() -> this.writeMap(map));
            }
        } else if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty()) {
                this.writer.append('\n');
                this.descendAndDo(() -> {
                    CharSequence depthPrefix = this.depthPrefix();
                    for (Object element : list) {
                        if (element instanceof Map) {
                            Map map = (Map)element;
                            if (map.isEmpty()) {
                                this.writer.append(depthPrefix).append("- {}");
                            } else {
                                this.writeMapWhichIsListElement(map);
                            }
                        } else {
                            this.writer.append(depthPrefix).append('-');
                            this.writeSingleValue(element);
                        }
                        this.writer.append('\n');
                    }
                });
                return;
            }
            this.writer.append(" []");
        } else {
            this.writeSingleValue(value);
        }
        this.writer.append('\n');
    }

    private <K, V> void writeMapWhichIsListElement(Map<K, V> map) throws IOException {
        Iterator<Map.Entry<K, V>> entryIterator = map.entrySet().iterator();
        Map.Entry<K, V> firstEntry = entryIterator.next();
        Object firstEntryValue = firstEntry.getValue();
        if (firstEntryValue instanceof CommentedWrapper) {
            this.descendAndDo(() -> this.writeComments((CommentedWrapper)firstEntryValue));
        }
        IteratorWithElementPrepended newIterator = new IteratorWithElementPrepended(firstEntry, entryIterator);
        this.writer.append(this.depthPrefix()).append("- ");
        this.firstMapEntryIsPartOfList = true;
        this.descendAndDo(() -> this.writeRemainingMapEntries(newIterator));
    }

    private void writeSingleValue(Object value) throws IOException {
        this.writer.append(' ');
        if (value instanceof String || value instanceof Character) {
            this.writer.append('\'');
            this.writer.append(value.toString().replace("'", "''"));
            this.writer.append('\'');
            return;
        }
        if (value instanceof Number || value instanceof Boolean) {
            this.writer.append(value.toString());
            return;
        }
        throw new IllegalArgumentException("Unknown single value type " + value.getClass());
    }

    @FunctionalInterface
    private static interface WriterAction {
        public void run() throws IOException;
    }

    static final class Factory
    implements YamlWriter.Factory {
        private final String commentFormat;

        Factory(String commentFormat) {
            this.commentFormat = commentFormat;
        }

        @Override
        public CommentedWriter newWriter(SnakeYamlOptions yamlOptions, Writer writer) {
            return new CommentedWriter(writer, this.commentFormat);
        }

        @Override
        public boolean supportsComments() {
            return true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Factory factory = (Factory)o;
            return this.commentFormat.equals(factory.commentFormat);
        }

        public int hashCode() {
            return this.commentFormat.hashCode();
        }
    }
}

