/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.factory;

import cc.dsnb.bedrockplayersupport.dazzleconf.ConfigurationFactory;
import cc.dsnb.bedrockplayersupport.dazzleconf.ConfigurationOptions;
import cc.dsnb.bedrockplayersupport.dazzleconf.error.IllDefinedConfigException;
import cc.dsnb.bedrockplayersupport.dazzleconf.error.InvalidConfigException;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.ConfigurationDefinition;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.DefinitionReader;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.deprocessor.AddCommentStringBeforeDeprocessor;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.deprocessor.CommentedDeprocessor;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.deprocessor.DeprocessorBase;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.deprocessor.SimpleDeprocessor;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.processor.DefaultsProcessor;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.processor.MapProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class ConfigurationFormatFactory<C>
implements ConfigurationFactory<C> {
    private final ConfigurationOptions options;
    private final ConfigurationDefinition<C> definition;

    protected ConfigurationFormatFactory(Class<C> configClass, ConfigurationOptions options) {
        if (!configClass.isInterface()) {
            throw new IllegalArgumentException(configClass.getName() + " is not an interface");
        }
        this.options = Objects.requireNonNull(options, "options");
        this.definition = new DefinitionReader<C>(configClass, options).read();
    }

    @Override
    public final Class<C> getConfigClass() {
        return this.definition.getConfigClass();
    }

    @Override
    public final ConfigurationOptions getOptions() {
        return this.options;
    }

    public final List<String> getHeader() {
        return this.definition.getHeader();
    }

    @Override
    public final C load(ReadableByteChannel readChannel) throws IOException, InvalidConfigException {
        return this.fromRawMap(this.loadMap(readChannel));
    }

    @Override
    public final C load(InputStream inputStream) throws IOException, InvalidConfigException {
        return this.fromRawMap(this.loadMap(inputStream));
    }

    @Override
    public final C load(ReadableByteChannel readChannel, C auxiliaryEntries) throws IOException, InvalidConfigException {
        Objects.requireNonNull(this.getConfigClass().cast(auxiliaryEntries), "auxiliaryEntries");
        return this.fromRawMap(this.loadMap(readChannel), auxiliaryEntries);
    }

    @Override
    public final C load(InputStream inputStream, C auxiliaryEntries) throws IOException, InvalidConfigException {
        Objects.requireNonNull(this.getConfigClass().cast(auxiliaryEntries), "auxiliaryEntries");
        return this.fromRawMap(this.loadMap(inputStream), auxiliaryEntries);
    }

    @Override
    public final C loadDefaults() {
        DefaultsProcessor<C> processor = new DefaultsProcessor<C>(this.options, this.definition);
        try {
            return processor.createConfig();
        }
        catch (InvalidConfigException ex) {
            throw new IllDefinedConfigException(ex);
        }
    }

    public abstract Map<String, Object> loadMap(ReadableByteChannel var1) throws IOException, InvalidConfigException;

    public abstract Map<String, Object> loadMap(InputStream var1) throws IOException, InvalidConfigException;

    private C fromRawMap(Map<String, Object> rawMap) throws InvalidConfigException {
        return this.fromRawMap(rawMap, null);
    }

    private C fromRawMap(Map<String, Object> rawMap, C auxiliaryValues) throws InvalidConfigException {
        return new MapProcessor<C>(this.getOptions(), this.definition, rawMap, auxiliaryValues).createConfig();
    }

    @Override
    public final void write(C configData, WritableByteChannel writeChannel) throws IOException {
        Objects.requireNonNull(this.getConfigClass().cast(configData), "configData");
        this.writeMap(this.toRawMap(configData), writeChannel);
    }

    @Override
    public final void write(C configData, OutputStream outputStream) throws IOException {
        Objects.requireNonNull(this.getConfigClass().cast(configData), "configData");
        this.writeMap(this.toRawMap(configData), outputStream);
    }

    public abstract void writeMap(Map<String, Object> var1, WritableByteChannel var2) throws IOException;

    public abstract void writeMap(Map<String, Object> var1, OutputStream var2) throws IOException;

    private Map<String, Object> toRawMap(C configData) {
        return this.createDeprocessor(configData).deprocess();
    }

    private DeprocessorBase<C> createDeprocessor(C configData) {
        if (this.supportsCommentsThroughWrapper()) {
            return new CommentedDeprocessor<C>(this.definition, configData);
        }
        String pseudoCommentsSuffix = this.pseudoCommentsSuffix();
        if (!pseudoCommentsSuffix.isEmpty()) {
            return new AddCommentStringBeforeDeprocessor<C>(this.definition, configData, pseudoCommentsSuffix);
        }
        return new SimpleDeprocessor<C>(this.definition, configData);
    }

    public boolean supportsCommentsThroughWrapper() {
        return false;
    }

    public String pseudoCommentsSuffix() {
        return "";
    }
}

