/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.helper;

import cc.dsnb.bedrockplayersupport.dazzleconf.AuxiliaryKeys;
import cc.dsnb.bedrockplayersupport.dazzleconf.ConfigurationFactory;
import cc.dsnb.bedrockplayersupport.dazzleconf.error.InvalidConfigException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class ConfigurationHelper<C> {
    private final Path configFolder;
    private final String fileName;
    private final ConfigurationFactory<C> factory;

    public ConfigurationHelper(Path configFolder, String fileName, ConfigurationFactory<C> factory) {
        this.configFolder = configFolder;
        this.fileName = fileName;
        this.factory = factory;
    }

    public ConfigurationFactory<C> getFactory() {
        return this.factory;
    }

    public C reloadConfigData() throws IOException, InvalidConfigException {
        C loadedData;
        Files.createDirectories(this.configFolder, new FileAttribute[0]);
        C defaults = this.factory.loadDefaults();
        Path configPath = this.configFolder.resolve(this.fileName);
        if (!Files.exists(configPath, new LinkOption[0])) {
            try (FileChannel fileChannel = FileChannel.open(configPath, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
                this.factory.write(defaults, fileChannel);
            }
            return defaults;
        }
        try (FileChannel fileChannel = FileChannel.open(configPath, StandardOpenOption.READ);){
            loadedData = this.factory.load(fileChannel, defaults);
        }
        if (loadedData instanceof AuxiliaryKeys) {
            fileChannel = FileChannel.open(configPath, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
            try {
                this.factory.write(loadedData, fileChannel);
            }
            finally {
                if (fileChannel != null) {
                    fileChannel.close();
                }
            }
        }
        return loadedData;
    }
}

