/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal;

import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.ReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.MethodUtil;
import cc.dsnb.bedrockplayersupport.dazzleconf.sorter.SortableConfigurationEntry;
import cc.dsnb.bedrockplayersupport.dazzleconf.validator.ValueValidator;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;

public final class ConfEntry
implements SortableConfigurationEntry {
    private final Method method;
    private final String key;
    private final List<String> comments;
    private final ReturnType<?> returnType;
    private final ValueValidator validator;

    public ConfEntry(Method method, String key, List<String> comments, ReturnType<?> returnType, ValueValidator validator) {
        this.method = method;
        this.key = key;
        this.comments = comments;
        this.returnType = returnType;
        this.validator = validator;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public List<String> getComments() {
        return this.comments;
    }

    public ReturnType<?> returnType() {
        return this.returnType;
    }

    public Optional<ValueValidator> getValidator() {
        return Optional.ofNullable(this.validator);
    }

    public String getQualifiedMethodName() {
        return MethodUtil.getQualifiedName(this.method);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.method.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ConfEntry)) {
            return false;
        }
        ConfEntry other = (ConfEntry)object;
        return this.method.equals(other.method);
    }

    public String toString() {
        return "ConfEntry [method=" + this.method + "]";
    }
}

