/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal;

import cc.dsnb.bedrockplayersupport.dazzleconf.annote.ConfComments;
import cc.dsnb.bedrockplayersupport.dazzleconf.annote.ConfKey;
import cc.dsnb.bedrockplayersupport.dazzleconf.annote.ConfValidator;
import cc.dsnb.bedrockplayersupport.dazzleconf.error.IllDefinedConfigException;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.ConfEntry;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.ConfigurationDefinition;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.DefinitionReader;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.ReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.ReturnTypeCreation;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.SimpleSubSectionReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.TypeInfo;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.TypeInfoCreation;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.ImmutableCollections;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.MethodUtil;
import cc.dsnb.bedrockplayersupport.dazzleconf.validator.ValueValidator;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Supplier;

class ConfEntryCreation {
    private final DefinitionReader<?> reader;
    private final Method method;
    private final TypeInfoCreation typeInfoCreation;

    ConfEntryCreation(DefinitionReader<?> reader, Method method, TypeInfoCreation typeInfoCreation) {
        this.reader = reader;
        this.method = method;
        this.typeInfoCreation = typeInfoCreation;
    }

    private String getQualifiedMethodName() {
        return MethodUtil.getQualifiedName(this.method);
    }

    ConfEntry create() {
        List<String> comments;
        if (this.method.getParameterCount() > 0) {
            throw new IllDefinedConfigException(this.getQualifiedMethodName() + " should not have parameters");
        }
        TypeInfo<?> returnTypeInfo = this.typeInfoCreation.create(this.method.getReturnType());
        if (!returnTypeInfo.isTypeAccessible()) {
            throw new IllDefinedConfigException(this.getQualifiedMethodName() + " has inaccessible return type " + returnTypeInfo.rawType());
        }
        ReturnType<?> returnType = new ReturnTypeCreation(this.reader, returnTypeInfo).create(this.method);
        if (returnType instanceof SimpleSubSectionReturnType) {
            ConfigurationDefinition configDefinition = ((SimpleSubSectionReturnType)returnType).configDefinition();
            comments = this.findComments(configDefinition::getHeader);
        } else {
            comments = this.findComments(ImmutableCollections::emptyList);
        }
        return new ConfEntry(this.method, this.findKey(), comments, returnType, this.getValidator());
    }

    private ValueValidator getValidator() {
        ConfValidator chosenValidator = this.method.getAnnotation(ConfValidator.class);
        return chosenValidator == null ? null : this.reader.instantiate(ValueValidator.class, chosenValidator.value());
    }

    private String findKey() {
        ConfKey confKey = this.method.getAnnotation(ConfKey.class);
        return confKey != null ? confKey.value() : this.method.getName();
    }

    private List<String> findComments(Supplier<List<String>> backupSupplier) {
        ConfComments commentsAnnotation = this.method.getAnnotation(ConfComments.class);
        if (commentsAnnotation != null) {
            return ImmutableCollections.listOf(commentsAnnotation.value());
        }
        return backupSupplier.get();
    }
}

