/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal;

import cc.dsnb.bedrockplayersupport.dazzleconf.annote.ConfHeader;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.ConfEntry;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.ImmutableCollections;
import cc.dsnb.bedrockplayersupport.dazzleconf.serialiser.ValueSerialiserMap;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public final class ConfigurationDefinition<C> {
    private final Class<C> configClass;
    private final List<ConfEntry> entries;
    private final Set<Method> defaultMethods;
    private final ValueSerialiserMap serialisers;

    public ConfigurationDefinition(Class<C> configClass, List<ConfEntry> entries, Set<Method> defaultMethods, ValueSerialiserMap serialisers) {
        this.configClass = configClass;
        this.entries = ImmutableCollections.listOf(entries);
        this.defaultMethods = ImmutableCollections.setOf(defaultMethods);
        this.serialisers = serialisers;
    }

    public Class<C> getConfigClass() {
        return this.configClass;
    }

    public List<String> getHeader() {
        ConfHeader header = this.getConfigClass().getAnnotation(ConfHeader.class);
        return header == null ? ImmutableCollections.emptyList() : ImmutableCollections.listOf(header.value());
    }

    public Collection<ConfEntry> getEntries() {
        return this.entries;
    }

    public boolean hasDefaultMethods() {
        return !this.defaultMethods.isEmpty();
    }

    public Set<Method> getDefaultMethods() {
        if (!this.hasDefaultMethods()) {
            throw new IllegalStateException("No default methods present");
        }
        return this.defaultMethods;
    }

    public ValueSerialiserMap getSerialisers() {
        return this.serialisers;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.configClass.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        return this.configClass == ((ConfigurationDefinition)object).configClass;
    }

    public String toString() {
        return "ConfigurationDefinition{configClass=" + this.configClass + ", entries=" + this.entries + ", defaultMethods=" + this.defaultMethods + ", serialisers=" + this.serialisers + '}';
    }
}

