/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal;

import cc.dsnb.bedrockplayersupport.dazzleconf.ConfigurationOptions;
import cc.dsnb.bedrockplayersupport.dazzleconf.annote.ConfSerialisers;
import cc.dsnb.bedrockplayersupport.dazzleconf.error.IllDefinedConfigException;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.ConfEntry;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.ConfEntryCreation;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.ConfigurationDefinition;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.TypeInfo;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.TypeInfoCreation;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.MethodUtil;
import cc.dsnb.bedrockplayersupport.dazzleconf.serialiser.ValueSerialiser;
import cc.dsnb.bedrockplayersupport.dazzleconf.serialiser.ValueSerialiserMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class DefinitionReader<C> {
    private final Class<C> configClass;
    private final ConfigurationOptions options;
    private final Set<Class<?>> nestedConfigDejaVu;
    private final Set<Method> defaultMethods = new HashSet<Method>();
    private final Map<String, ConfEntry> entries = new LinkedHashMap<String, ConfEntry>();

    public DefinitionReader(Class<C> configClass, ConfigurationOptions options) {
        this(configClass, options, new HashSet());
    }

    private DefinitionReader(Class<C> configClass, ConfigurationOptions options, Set<Class<?>> nestedConfigDejaVu) {
        Objects.requireNonNull(configClass, "config class");
        if (!configClass.isInterface()) {
            throw new IllDefinedConfigException(configClass.getName() + " is not an interface");
        }
        this.configClass = configClass;
        this.options = options;
        this.nestedConfigDejaVu = nestedConfigDejaVu;
    }

    public ConfigurationDefinition<C> read() {
        ValueSerialiserMap serialiserMap = this.readSerialisers();
        List<ConfEntry> sortedEntries = this.readAndSortEntries();
        return new ConfigurationDefinition<C>(this.configClass, sortedEntries, this.defaultMethods, serialiserMap);
    }

    public <N> ConfigurationDefinition<N> createChildDefinition(TypeInfo<N> configClassTypeInfo) {
        Class<N> configClass = configClassTypeInfo.rawType();
        DefinitionReader<N> reader = new DefinitionReader<N>(configClass, this.options, this.nestedConfigDejaVu);
        return reader.read();
    }

    private ValueSerialiserMap readSerialisers() {
        ConfSerialisers confSerialisers = this.configClass.getAnnotation(ConfSerialisers.class);
        if (confSerialisers == null) {
            return this.options.getSerialisers();
        }
        HashMap serialisers = new HashMap(this.options.getSerialisers().asMap());
        for (Class<? extends ValueSerialiser<?>> serialiserClass : confSerialisers.value()) {
            ValueSerialiser<?> serialiser = this.instantiate(ValueSerialiser.class, serialiserClass);
            serialisers.put(serialiser.getTargetClass(), serialiser);
        }
        return ValueSerialiserMap.of(serialisers);
    }

    private List<ConfEntry> readAndSortEntries() {
        if (!this.nestedConfigDejaVu.add(this.configClass)) {
            throw new IllDefinedConfigException("Circular nested configuration for " + this.configClass.getName());
        }
        for (Method method : this.configClass.getMethods()) {
            if (Modifier.isStatic(method.getModifiers())) continue;
            if (MethodUtil.isDefault(method)) {
                this.defaultMethods.add(method);
                continue;
            }
            this.create(method);
        }
        boolean cleared = this.nestedConfigDejaVu.remove(this.configClass);
        assert (cleared) : this.configClass;
        ArrayList<ConfEntry> entriesList = new ArrayList<ConfEntry>(this.entries.values());
        this.options.getConfigurationSorter().ifPresent(entriesList::sort);
        return entriesList;
    }

    private void create(Method method) {
        ConfEntryCreation entryCreation = new ConfEntryCreation(this, method, new TypeInfoCreation(method.getAnnotatedReturnType()));
        ConfEntry entry = entryCreation.create();
        ConfEntry previous = this.entries.put(entry.getKey(), entry);
        if (previous != null) {
            throw new IllDefinedConfigException("Duplicate key " + entry.getKey() + ". It is not possible to have multiple configuration options using the same key.");
        }
    }

    <V> V instantiate(Class<V> intf, Class<? extends V> impl) {
        try {
            Method createMethod = impl.getDeclaredMethod("getInstance", new Class[0]);
            if (Modifier.isStatic(createMethod.getModifiers()) && intf.isAssignableFrom(createMethod.getReturnType())) {
                return intf.cast(createMethod.invoke(null, new Object[0]));
            }
        }
        catch (NoSuchMethodException createMethod) {
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException ex) {
            throw this.uninstantiable(intf, impl, ex);
        }
        try {
            return impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            throw this.uninstantiable(intf, impl, ex);
        }
    }

    private <V> IllDefinedConfigException uninstantiable(Class<V> intf, Class<? extends V> impl, Throwable cause) {
        return new IllDefinedConfigException("Unable to instantiate " + intf.getSimpleName() + " implemented by " + impl.getName(), cause);
    }
}

