/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal;

import cc.dsnb.bedrockplayersupport.dazzleconf.error.MissingKeyException;
import cc.dsnb.bedrockplayersupport.dazzleconf.error.MissingValueException;
import cc.dsnb.bedrockplayersupport.dazzleconf.factory.CommentedWrapper;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.error.DeveloperError;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.error.Errors;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.error.UserError;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public class NestedMapHelper {
    private final Map<String, Object> topLevelMap;
    private static final Pattern PERIOD_PATTERN = Pattern.compile(".", 16);

    public NestedMapHelper(Map<String, Object> topLevelMap) {
        this.topLevelMap = Objects.requireNonNull(topLevelMap, "topLevelMap");
    }

    public Map<String, Object> getTopLevelMap() {
        return this.topLevelMap;
    }

    public void put(String key, Object value) {
        this.put0(key, value, false);
    }

    public void combine(String key, Object object) {
        this.put0(key, object, true);
    }

    private void put0(String key, Object value, boolean combine) {
        String[] keyParts = PERIOD_PATTERN.split(key);
        Map<String, Object> currentMap = this.topLevelMap;
        int lastIndex = keyParts.length - 1;
        for (int n = 0; n < lastIndex; ++n) {
            currentMap = NestedMapHelper.computeMapOrFail(key, currentMap, keyParts[n]);
        }
        if (combine) {
            Map combineWith;
            LinkedHashMap toCombine;
            LinkedHashMap toCombineOriginal = NestedMapHelper.computeMapOrFail(key, currentMap, keyParts[lastIndex]);
            LinkedHashMap linkedHashMap = toCombine = toCombineOriginal instanceof LinkedHashMap ? toCombineOriginal : new LinkedHashMap(toCombineOriginal);
            if (value instanceof CommentedWrapper) {
                CommentedWrapper commentWrapper = (CommentedWrapper)value;
                currentMap.put(keyParts[lastIndex], new CommentedWrapper(commentWrapper.getComments(), toCombine));
                combineWith = (Map)commentWrapper.getValue();
            } else {
                currentMap.put(keyParts[lastIndex], toCombine);
                combineWith = (Map)value;
            }
            toCombine.putAll(combineWith);
        } else {
            Object previous = currentMap.put(keyParts[lastIndex], value);
            if (previous != null) {
                throw DeveloperError.replacedObject(key, previous, value).toConfigException();
            }
        }
    }

    private static Map<String, Object> computeMapOrFail(String fullKey, Map<String, Object> currentMap, String keyPart) {
        Object shouldBeMap = currentMap.computeIfAbsent(keyPart, k -> new LinkedHashMap());
        if (shouldBeMap instanceof CommentedWrapper) {
            shouldBeMap = ((CommentedWrapper)shouldBeMap).getValue();
        }
        if (!(shouldBeMap instanceof Map)) {
            throw DeveloperError.expectedMap(Errors.When.WRITE_CONFIG, fullKey, shouldBeMap).toConfigException();
        }
        return (Map)shouldBeMap;
    }

    public Object get(String key) throws MissingKeyException, MissingValueException {
        Map currentMap = this.topLevelMap;
        String[] keyParts = PERIOD_PATTERN.split(key);
        int lastIndex = keyParts.length - 1;
        for (int n = 0; n < lastIndex; ++n) {
            String keyPart = keyParts[n];
            Object nextMap = currentMap.get(keyPart);
            if (nextMap == null) {
                throw MissingKeyException.forKeyAndMessage(key, UserError.missingKey(key));
            }
            if (!(nextMap instanceof Map)) {
                throw DeveloperError.expectedMap(Errors.When.LOAD_CONFIG, key, nextMap).toConfigException();
            }
            currentMap = (Map)nextMap;
        }
        Object value = currentMap.get(keyParts[lastIndex]);
        if (value == null) {
            if (currentMap.containsKey(keyParts[lastIndex])) {
                throw MissingValueException.forKeyAndMessage(key, UserError.nullValue(key));
            }
            throw MissingKeyException.forKeyAndMessage(key, UserError.missingKey(key));
        }
        return value;
    }
}

