/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal.deprocessor;

import cc.dsnb.bedrockplayersupport.dazzleconf.internal.ConfEntry;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.ConfigurationDefinition;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.deprocessor.DeprocessorBase;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.CollectionReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.MapReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.ReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.SimpleCollectionReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.SimpleMapReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.SimpleSubSectionReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.SubSectionCollectionReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.type.SubSectionMapReturnType;
import cc.dsnb.bedrockplayersupport.dazzleconf.serialiser.Decomposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

class Decomposition {
    private final DeprocessorBase<?> deprocessor;
    private final ConfEntry entry;
    private final Object value;
    private final Decomposer decomposer;

    Decomposition(DeprocessorBase<?> deprocessor, ConfEntry entry, Object value, Decomposer decomposer) {
        this.deprocessor = deprocessor;
        this.entry = entry;
        this.value = value;
        this.decomposer = decomposer;
    }

    Object deprocessObject() {
        return this.deprocessObjectWithReturnType(this.entry.returnType());
    }

    private <G> Object deprocessObjectWithReturnType(ReturnType<G> returnType) {
        if (returnType instanceof SimpleSubSectionReturnType) {
            SimpleSubSectionReturnType subSectionReturnType = (SimpleSubSectionReturnType)returnType;
            ConfigurationDefinition configDefinition = subSectionReturnType.configDefinition();
            return this.deprocessor.deprocessNested(configDefinition, configDefinition.getConfigClass().cast(this.value));
        }
        if (returnType instanceof CollectionReturnType) {
            return this.decomposeCollection((CollectionReturnType)returnType);
        }
        if (returnType instanceof MapReturnType) {
            return this.decomposeMap((MapReturnType)returnType);
        }
        Class<G> goal = returnType.typeInfo().rawType();
        Object castedValue = this.value;
        return this.decomposer.decompose(goal, castedValue);
    }

    private <E, R extends Collection<E>> Collection<Object> decomposeCollection(CollectionReturnType<E, R> returnType) {
        Collection collection = (Collection)this.value;
        if (returnType instanceof SimpleCollectionReturnType) {
            return this.decomposer.decomposeCollection(returnType.elementTypeInfo().rawType(), collection);
        }
        SubSectionCollectionReturnType subSectionReturnType = (SubSectionCollectionReturnType)returnType;
        ConfigurationDefinition configDefinition = subSectionReturnType.configDefinition();
        ArrayList<Object> serialised = new ArrayList<Object>(collection.size());
        for (Object element : collection) {
            serialised.add(this.deprocessor.deprocessNested(configDefinition, element));
        }
        return serialised;
    }

    private <K, V> Map<Object, Object> decomposeMap(MapReturnType<K, V> returnType) {
        Class<K> keyType = returnType.keyTypeInfo().rawType();
        Class<V> valueType = returnType.valueTypeInfo().rawType();
        Map map = (Map)this.value;
        if (returnType instanceof SimpleMapReturnType) {
            return this.decomposer.decomposeMap(keyType, valueType, map);
        }
        SubSectionMapReturnType subSectionReturnType = (SubSectionMapReturnType)returnType;
        ConfigurationDefinition configDefinition = subSectionReturnType.configDefinition();
        LinkedHashMap<Object, Object> serialised = new LinkedHashMap<Object, Object>((int)((float)map.size() / 0.74f));
        for (Map.Entry entry : map.entrySet()) {
            serialised.put(this.decomposer.decompose(keyType, entry.getKey()), this.deprocessor.deprocessNested(configDefinition, entry.getValue()));
        }
        return serialised;
    }
}

