/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal.deprocessor;

import cc.dsnb.bedrockplayersupport.dazzleconf.internal.ConfEntry;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.ConfigurationDefinition;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.NestedMapHelper;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.deprocessor.DecomposerImpl;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.deprocessor.Decomposition;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.util.ConfigurationInvoker;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class DeprocessorBase<C> {
    private final ConfigurationDefinition<C> definition;
    private final ConfigurationInvoker<C> configDataInvoker;
    final NestedMapHelper mapHelper = new NestedMapHelper(new LinkedHashMap<String, Object>());

    DeprocessorBase(ConfigurationDefinition<C> definition, C configData) {
        this.definition = definition;
        this.configDataInvoker = new ConfigurationInvoker<C>(configData);
    }

    abstract Object wrapValue(ConfEntry var1, Object var2);

    abstract <N> DeprocessorBase<N> createChildDeprocessor(ConfigurationDefinition<N> var1, N var2);

    public Map<String, Object> deprocess() {
        for (ConfEntry entry : this.definition.getEntries()) {
            String key = entry.getKey();
            Object deprocessedValue = this.getDeprocessedValue(entry, this.configDataInvoker.getEntryValue(entry));
            Object wrappedValue = this.wrapValue(entry, deprocessedValue);
            if (deprocessedValue instanceof Map) {
                this.mapHelper.combine(key, wrappedValue);
                continue;
            }
            this.mapHelper.put(key, wrappedValue);
        }
        return this.mapHelper.getTopLevelMap();
    }

    private Object getDeprocessedValue(ConfEntry entry, Object value) {
        DecomposerImpl decomposer = new DecomposerImpl(entry.getKey(), this.definition.getSerialisers());
        Decomposition decomposition = new Decomposition(this, entry, value, decomposer);
        return decomposition.deprocessObject();
    }

    <N> Map<String, Object> deprocessNested(ConfigurationDefinition<N> childDefinition, N childConfig) {
        return this.createChildDeprocessor(childDefinition, childConfig).deprocess();
    }
}

