/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal.error;

import cc.dsnb.bedrockplayersupport.dazzleconf.error.IllDefinedConfigException;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.error.Errors;
import cc.dsnb.bedrockplayersupport.dazzleconf.serialiser.ValueSerialiser;
import java.util.stream.IntStream;

public final class DeveloperError
implements Errors.StandardError {
    private final Errors.When when;
    private final String message;

    private DeveloperError(Errors.When when, String message) {
        this.when = when;
        this.message = message;
    }

    public static DeveloperError expectedMap(Errors.When when, String fullKey, Object actualValue) {
        return new DeveloperError(Errors.When.LOAD_CONFIG, "Expected a configuration section inside the data, but a simple object was present. Key: " + fullKey + ". Actual value: " + actualValue);
    }

    public static DeveloperError replacedObject(String key, Object replaced, Object replacement) {
        return new DeveloperError(Errors.When.WRITE_CONFIG, "Unexpectedly replaced object " + replaced + " at key " + key + " with " + replacement + ". No objects should be replaced during writing of the configuration, so this indicates an issue.");
    }

    public static DeveloperError noSerializerFound(Errors.When when, String key, Class<?> type) {
        return new DeveloperError(when, "No ValueSerialiser was found for " + type + " at entry " + key + ". To use custom types, a relevant ValueSerialiser must exist.");
    }

    public static DeveloperError serializerReturnedNull(Errors.When when, String key, ValueSerialiser<?> serialiser) {
        return new DeveloperError(when, "At key " + key + ", the ValueSerialiser (" + serialiser + ") returned null. This is a breach of contract; ValueSerialisers should never return null");
    }

    @Override
    public Errors.When when() {
        return this.when;
    }

    @Override
    public String message() {
        return this.message + "\n(This is an error on behalf of the developer)";
    }

    public IllDefinedConfigException toConfigException() {
        return new IllDefinedConfigException(this.toString());
    }

    @Override
    public String toString() {
        return this.withExtraInfo("");
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public IntStream chars() {
        return this.toString().chars();
    }

    @Override
    public IntStream codePoints() {
        return this.toString().codePoints();
    }
}

