/*
 * Decompiled with CFR 0.152.
 */
package cc.dsnb.bedrockplayersupport.dazzleconf.internal.error;

import cc.dsnb.bedrockplayersupport.dazzleconf.internal.error.Errors;
import cc.dsnb.bedrockplayersupport.dazzleconf.internal.error.UserType;
import java.util.Objects;
import java.util.stream.IntStream;

public final class UserError
implements Errors.StandardError {
    private final Errors.When when;
    private final String message;

    private UserError(Errors.When when, String message) {
        this.when = Objects.requireNonNull(when, "when");
        this.message = Objects.requireNonNull(message, "message");
    }

    public static UserError wrongType(UserType expected, Object actual) {
        StringBuilder message = new StringBuilder();
        message.append("The wrong type was entered. The value should be ");
        message.append(expected.toString());
        message.append(", ");
        message.append("but it was really ");
        message.append(actual.toString());
        String[] validExamples = expected.examples();
        if (validExamples.length != 0) {
            message.append('\n');
            message.append("Some examples of valid input: ");
            for (int n = 0; n < validExamples.length; ++n) {
                if (n == 0) continue;
                message.append(", ");
                message.append(validExamples[n]);
            }
        }
        return new UserError(Errors.When.LOAD_CONFIG, message.toString());
    }

    public static UserError sizeTooSmall(Number actual, Number minimum) {
        assert (actual.doubleValue() < minimum.doubleValue()) : "Internal error";
        return new UserError(Errors.When.LOAD_CONFIG, "The value's size of " + actual + " must be more than the minimum size of " + minimum);
    }

    public static UserError sizeTooBig(Number actual, Number maximum) {
        assert (actual.doubleValue() > maximum.doubleValue()) : "Internal error";
        return new UserError(Errors.When.LOAD_CONFIG, "The value's size of " + actual + " must be less than the maximum size of " + maximum);
    }

    public static UserError missingKey(String key) {
        return new UserError(Errors.When.LOAD_CONFIG, "The configuration option was deleted. You need to recreate the configuration option at " + key + ", then set it to a valid value.");
    }

    public static UserError nullValue(String key) {
        return new UserError(Errors.When.LOAD_CONFIG, "The configuration option at " + key + " was set to an empty value. You must set it to a valid value - it cannot be empty.");
    }

    @Override
    public Errors.When when() {
        return this.when;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public String toString() {
        return this.withExtraInfo("");
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public IntStream chars() {
        return this.toString().chars();
    }

    @Override
    public IntStream codePoints() {
        return this.toString().codePoints();
    }
}

